/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.GC.JStyleSWTBridge;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class JStylePlugin extends AbstractUIPlugin implements IStartup {

	// The plug-in ID
	public static final String PLUGIN_ID = JStylePlugin.class.getPackage().getName();

	// The shared instance
	private static JStylePlugin plugin;
	
	/**
	 * The constructor
	 */
	public JStylePlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static JStylePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	/*
	 * @see IStartup#earlyStartup()
	 */
	public void earlyStartup() {
		applySWT();
	}

	/**
	 * Apply JStyle preference to SWT.
	 */
	public void applySWT() {
		
		JStyleSWTBridge.lineBreakRGB =
			getRGBPreference(JStyleConstants.P_LINE_BREAK);
		JStyleSWTBridge.tabRGB =
			getRGBPreference(JStyleConstants.P_TAB);
		JStyleSWTBridge.fullWidthSpaceRGB =
			getRGBPreference(JStyleConstants.P_FULL_WIDTH_SPACE);
		JStyleSWTBridge.halfWidthSpaceRGB =
			getRGBPreference(JStyleConstants.P_HALF_WIDTH_SPACE);
		
		JStyleSWTBridge.tabGlyph =
			getComboPreference(JStyleConstants.P_TAB + JStyleConstants.SUFFIX_COMBO);
		
		JStyleSWTBridge.forceMonospace =
			getBooleanPreference(JStyleConstants.P_FORCE_MONOSPACE);

		StyledText.redrawJStyle();
	}
	
	/**
	 * Returns an RGB preference.
	 * 
	 * @param key Preference key
	 * @return RGB preference
	 */
	private RGB getRGBPreference(String key) {
		
		try {
			IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
			if (store.getBoolean(key + JStyleConstants.SUFFIX_SHOW)) {
				String value = store.getString(key + JStyleConstants.SUFFIX_COLOR);
				if (value != null) {
					return StringConverter.asRGB(value);
				}
			}
			
		} catch (Exception e) {
			
			Status status = new Status(IStatus.ERROR,
					getBundle().getSymbolicName(), 0,
					"Unable to get RGB preference. key:" + key, e);
			plugin.getLog().log(status);
			return StringConverter.asRGB(JStyleConstants.DEFAULT_RGB_STRING);
		}
		return null;
	}
	
	/**
	 * Returns a boolean preference.
	 * 
	 * @param key Preference key
	 * @return boolean preference
	 */
	private boolean getBooleanPreference(String key) {
		IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
		return store.getBoolean(key);
	}
	
	/**
	 * Returns a combo preference.
	 * 
	 * @param key Preference key
	 * @return combo preference
	 */
	private String getComboPreference(String key) {
		IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
		return store.getString(key);
	}
	
	/**
	 * Logs the message.
	 *
	 * @param message
	 */
	public static void log(String msg) {
		ILog log = plugin.getLog();
		log.log(new Status(IStatus.INFO, PLUGIN_ID, IStatus.OK, msg, null));
	}
}
