/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Vector;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String cacheParentPath;
    String[] pluginDirs;
    boolean isXULRunner;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";
    static boolean IsSparc;

    AppFileLocProvider(String mozillaPath, String profilePath, String cacheParentPath, boolean isXULRunner) {
        this.mozillaPath = mozillaPath + SEPARATOR_OS;
        this.profilePath = profilePath + SEPARATOR_OS;
        this.cacheParentPath = cacheParentPath;
        this.isXULRunner = isXULRunner;
        if (!Compatibility.fileExists(profilePath, "")) {
            long[] result = new long[1];
            nsEmbedString pathString = new nsEmbedString(profilePath);
            int rc = XPCOM.NS_NewLocalFile(pathString.getAddress(), 1, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            pathString.dispose();
            nsILocalFile file = new nsILocalFile(result[0]);
            rc = file.Create(1, 448);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            file.Release();
        }
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public long method0(long[] args) {
                return AppFileLocProvider.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] args) {
                return AppFileLocProvider.this.Release();
            }
        };
        this.directoryServiceProvider = new XPCOMObject(new int[]{2, 0, 0, 3}){

            public long method0(long[] args) {
                return AppFileLocProvider.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] args) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] args) {
                return AppFileLocProvider.this.getFile(args[0], args[1], args[2]);
            }
        };
        this.directoryServiceProvider2 = new XPCOMObject(new int[]{2, 0, 0, 3, 2}){

            public long method0(long[] args) {
                return AppFileLocProvider.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public long method2(long[] args) {
                return AppFileLocProvider.this.Release();
            }

            public long method3(long[] args) {
                return AppFileLocProvider.this.getFile(args[0], args[1], args[2]);
            }

            public long method4(long[] args) {
                return AppFileLocProvider.this.getFiles(args[0], args[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    long getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.directoryServiceProvider.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.directoryServiceProvider2.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int getFiles(long prop, long _retval) {
        int size = XPCOM.strlen(prop);
        byte[] bytes = new byte[size];
        XPCOM.memmove(bytes, prop, (long)size);
        String propertyName = new String(MozillaDelegate.mbcsToWcs(null, bytes));
        String[] propertyValues = null;
        if (propertyName.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int index = 0;
                long ptr = C.getenv(MozillaDelegate.wcsToMbcs(null, "MOZ_PLUGIN_PATH", true));
                if (ptr != 0L) {
                    int length = C.strlen(ptr);
                    byte[] buffer = new byte[length];
                    C.memmove(buffer, ptr, (long)length);
                    String value = new String(MozillaDelegate.mbcsToWcs(null, buffer));
                    if (value.length() > 0) {
                        String separator = System.getProperty("path.separator");
                        Vector<String> segments = new Vector<String>();
                        int end = -1;
                        do {
                            int start;
                            String segment;
                            if ((segment = (end = value.indexOf(separator, start = end + 1)) == -1 ? value.substring(start) : value.substring(start, end)).length() <= 0) continue;
                            segments.addElement(segment);
                        } while (end != -1);
                        int segmentsSize = segments.size();
                        this.pluginDirs = new String[segmentsSize + (IsSparc ? 1 : 2)];
                        for (index = 0; index < segmentsSize; ++index) {
                            this.pluginDirs[index] = (String)segments.elementAt(index);
                        }
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[IsSparc ? 1 : 2];
                }
                if (!IsSparc) {
                    this.pluginDirs[index++] = this.mozillaPath + PLUGINS_DIR;
                }
                this.pluginDirs[index++] = System.getProperty("user.home") + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            propertyValues = this.pluginDirs;
        }
        XPCOM.memmove(_retval, new long[]{0L}, (long)C.PTR_SIZEOF);
        if (propertyValues != null) {
            long[] result = new long[1];
            nsISupports[] files = new nsISupports[propertyValues.length];
            int index = 0;
            for (int i = 0; i < propertyValues.length; ++i) {
                nsEmbedString pathString = new nsEmbedString(propertyValues[i]);
                int rc = XPCOM.NS_NewLocalFile(pathString.getAddress(), 1, result);
                if (rc != -2142109695) {
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0L) {
                        Mozilla.error(-2147467261);
                    }
                    nsILocalFile localFile = new nsILocalFile(result[0]);
                    result[0] = 0L;
                    rc = localFile.QueryInterface(Mozilla.IsPre_17 ? nsIFile.NS_IFILE_IID : nsIFile.NS_IFILE_17_IID, result);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0L) {
                        Mozilla.error(-2147467262);
                    }
                    localFile.Release();
                    nsIFile file = new nsIFile(result[0]);
                    files[index++] = file;
                }
                pathString.dispose();
                result[0] = 0L;
            }
            if (index < propertyValues.length) {
                nsISupports[] temp = new nsISupports[index];
                System.arraycopy(files, 0, temp, 0, index);
                files = temp;
            }
            SimpleEnumerator enumerator = new SimpleEnumerator(files);
            enumerator.AddRef();
            XPCOM.memmove(_retval, new long[]{enumerator.getAddress()}, (long)C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(long prop, long persistent, long _retval) {
        int size = XPCOM.strlen(prop);
        byte[] bytes = new byte[size];
        XPCOM.memmove(bytes, prop, (long)size);
        String propertyName = new String(MozillaDelegate.mbcsToWcs(null, bytes));
        String propertyValue = null;
        if (propertyName.equals("UHist")) {
            propertyValue = this.profilePath + HISTORY_FILE;
        } else if (propertyName.equals("UMimTyp")) {
            propertyValue = this.profilePath + MIMETYPES_FILE;
        } else if (propertyName.equals("PrefF")) {
            propertyValue = this.profilePath + PREFERENCES_FILE;
        } else if (propertyName.equals("PrefD")) {
            propertyValue = this.profilePath;
        } else if (propertyName.equals("UChrm")) {
            propertyValue = this.profilePath + CHROME_DIR;
        } else if (propertyName.equals("ProfD")) {
            propertyValue = this.profilePath;
        } else if (propertyName.equals("LclSt")) {
            propertyValue = this.profilePath + LOCALSTORE_FILE;
        } else if (propertyName.equals("cachePDir")) {
            propertyValue = this.cacheParentPath;
        } else if (propertyName.equals("Home")) {
            propertyValue = System.getProperty("user.home");
        } else if (propertyName.equals("TmpD")) {
            propertyValue = System.getProperty("java.io.tmpdir");
        } else if (propertyName.equals("GreD")) {
            propertyValue = this.mozillaPath;
        } else if (propertyName.equals("GreComsD")) {
            propertyValue = this.profilePath + COMPONENTS_DIR;
        } else if (propertyName.equals("MozBinD")) {
            propertyValue = this.mozillaPath;
        } else if (propertyName.equals("CurProcD")) {
            propertyValue = this.mozillaPath;
        } else if (propertyName.equals("ComsD")) {
            propertyValue = this.mozillaPath + COMPONENTS_DIR;
        } else if (propertyName.equals("XCurProcD")) {
            propertyValue = this.mozillaPath;
        } else if (propertyName.equals("PrfDef") && this.isXULRunner) {
            propertyValue = this.profilePath;
        }
        XPCOM.memmove(persistent, new boolean[]{true});
        XPCOM.memmove(_retval, new long[]{0L}, (long)C.PTR_SIZEOF);
        if (propertyValue != null && propertyValue.length() > 0) {
            long[] result = new long[1];
            nsEmbedString pathString = new nsEmbedString(propertyValue);
            int rc = XPCOM.NS_NewLocalFile(pathString.getAddress(), 1, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0L) {
                Mozilla.error(-2147467261);
            }
            pathString.dispose();
            nsILocalFile localFile = new nsILocalFile(result[0]);
            result[0] = 0L;
            rc = localFile.QueryInterface(Mozilla.IsPre_17 ? nsIFile.NS_IFILE_IID : nsIFile.NS_IFILE_17_IID, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0L) {
                Mozilla.error(-2147467262);
            }
            XPCOM.memmove(_retval, new long[]{result[0]}, (long)C.PTR_SIZEOF);
            localFile.Release();
            return 0;
        }
        return -2147467259;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        IsSparc = (osName.startsWith("sunos") || osName.startsWith("solaris")) && osArch.startsWith("sparc");
    }
}

