/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Random;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;

public class BrowserFunction {
    Browser browser;
    String name;
    String functionString;
    int index;
    boolean isEvaluate;
    boolean top;
    String token;
    String[] frameNames;

    public BrowserFunction(Browser browser, String name) {
        this(browser, name, true, null, true);
    }

    public BrowserFunction(Browser browser, String name, boolean top, String[] frameNames) {
        this(browser, name, top, frameNames, true);
    }

    BrowserFunction(Browser browser, String name, boolean top, String[] frameNames, boolean create) {
        if (browser == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        if (browser.isDisposed()) {
            SWT.error(24);
        }
        browser.checkWidget();
        this.browser = browser;
        this.name = name;
        this.top = top;
        this.frameNames = frameNames;
        Random random = new Random();
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(Integer.toHexString(bytes[i] & 0xFF));
        }
        this.token = buffer.toString();
        if (create) {
            browser.webBrowser.createFunction(this);
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    void dispose(boolean remove) {
        if (this.index < 0) {
            return;
        }
        if (remove) {
            this.browser.webBrowser.destroyFunction(this);
        }
        this.browser = null;
        this.functionString = null;
        this.name = null;
        this.index = -1;
    }

    public Object function(Object[] arguments) {
        if (this.index < 0) {
            SWT.error(49);
        }
        this.browser.checkWidget();
        return null;
    }

    public Browser getBrowser() {
        if (this.index < 0) {
            SWT.error(49);
        }
        this.browser.checkWidget();
        return this.browser;
    }

    public String getName() {
        if (this.index < 0) {
            SWT.error(49);
        }
        this.browser.checkWidget();
        return this.name;
    }

    public boolean isDisposed() {
        return this.index < 0;
    }
}

