/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURLW = "UniformResourceLocatorW";
    static final int CFSTR_INETURLIDW = URLTransfer.registerType("UniformResourceLocatorW");
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String url = (String)object;
        if (transferData.type == CFSTR_INETURLIDW) {
            int charCount = url.length();
            char[] chars = new char[charCount + 1];
            url.getChars(0, charCount, chars, 0);
            int byteCount = chars.length * 2;
            long newPtr = OS.GlobalAlloc(64, byteCount);
            OS.MoveMemory(newPtr, chars, byteCount);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = newPtr;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        } else if (transferData.type == CFSTR_INETURLID) {
            int count = url.length();
            char[] chars = new char[count + 1];
            url.getChars(0, count, chars, 0);
            int codePage = OS.GetACP();
            int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
            if (cchMultiByte == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            long lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
            OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = lpMultiByteStr;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        if (transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject data = new IDataObject(transferData.pIDataObject);
        data.AddRef();
        STGMEDIUM stgmedium = new STGMEDIUM();
        FORMATETC formatetc = transferData.formatetc;
        stgmedium.tymed = 1;
        transferData.result = this.getData(data, formatetc, stgmedium);
        data.Release();
        if (transferData.result != 0) {
            return null;
        }
        long hMem = stgmedium.unionField;
        try {
            if (transferData.type == CFSTR_INETURLIDW) {
                String string;
                int size = OS.GlobalSize(hMem) / 2 * 2;
                if (size == 0) {
                    Object var8_8 = null;
                    Object var18_10 = null;
                    OS.GlobalFree(hMem);
                    return var8_8;
                }
                char[] chars = new char[size / 2];
                long ptr = OS.GlobalLock(hMem);
                if (ptr == 0L) {
                    Object var11_21 = null;
                    Object var18_11 = null;
                    OS.GlobalFree(hMem);
                    return var11_21;
                }
                try {
                    OS.MoveMemory(chars, ptr, size);
                    int length = chars.length;
                    for (int i = 0; i < chars.length; ++i) {
                        if (chars[i] != '\u0000') continue;
                        length = i;
                        break;
                    }
                    string = new String(chars, 0, length);
                    Object var14_28 = null;
                }
                catch (Throwable throwable) {
                    Object var14_29 = null;
                    OS.GlobalUnlock(hMem);
                    throw throwable;
                }
                OS.GlobalUnlock(hMem);
                Object var18_12 = null;
                OS.GlobalFree(hMem);
                return string;
            }
            if (transferData.type == CFSTR_INETURLID) {
                int cchWideChar;
                int codePage;
                long lpMultiByteStr;
                block15: {
                    Object length;
                    lpMultiByteStr = OS.GlobalLock(hMem);
                    if (lpMultiByteStr == 0L) {
                        Object ptr = null;
                        Object var18_13 = null;
                        OS.GlobalFree(hMem);
                        return ptr;
                    }
                    try {
                        codePage = OS.GetACP();
                        cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                        if (cchWideChar != 0) break block15;
                        length = null;
                        Object var16_32 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_34 = null;
                        OS.GlobalUnlock(hMem);
                        throw throwable;
                    }
                    OS.GlobalUnlock(hMem);
                    Object var18_14 = null;
                    OS.GlobalFree(hMem);
                    return length;
                }
                char[] lpWideCharStr = new char[cchWideChar - 1];
                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                String string = new String(lpWideCharStr);
                Object var16_33 = null;
                OS.GlobalUnlock(hMem);
                Object var18_15 = null;
                OS.GlobalFree(hMem);
                return string;
            }
            Object var18_16 = null;
            OS.GlobalFree(hMem);
            return null;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            OS.GlobalFree(hMem);
            throw throwable;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLIDW, CFSTR_INETURLID};
    }

    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURLW, CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

