/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BooleanColorFieldEditor
extends FieldEditor {
    public static final int NUM_COLUMNS = 3;
    private boolean wasSelected;
    private Button checkBox;
    private ColorSelector colorSelector;
    private Combo combo;
    private String comboValue;
    private String[][] comboNamesAndValues;

    protected BooleanColorFieldEditor() {
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    public BooleanColorFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, null);
    }

    public BooleanColorFieldEditor(String name, String labelText, Composite parent, String[][] comboNamesAndValues) {
        this.comboNamesAndValues = comboNamesAndValues;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.checkBox = this.getBooleanChangeControl(parent);
        this.checkBox.setText(this.getLabelText());
        Button colorButton = this.getColorChangeControl(parent);
        GridData colorGd = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels((Control)colorButton, 61);
        colorGd.widthHint = Math.max(widthHint, colorButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        colorGd.horizontalSpan = 2;
        colorButton.setLayoutData((Object)colorGd);
        if (this.comboNamesAndValues != null) {
            colorGd.horizontalSpan = 1;
            Combo combo = this.getComboBoxControl(parent);
            GridData comboGd = new GridData();
            combo.setLayoutData((Object)comboGd);
            combo.setFont(parent.getFont());
        }
    }

    private String getBooleanPreferenceName() {
        return String.valueOf(this.getPreferenceName()) + "_SHOW";
    }

    private String getColorPreferenceName() {
        return String.valueOf(this.getPreferenceName()) + "_COLOR";
    }

    private String getComboPreferenceName() {
        return String.valueOf(this.getPreferenceName()) + "_COMBO";
    }

    protected void doLoad() {
        this.updateCheckBoxForValue(this.getPreferenceStore().getBoolean(this.getBooleanPreferenceName()));
        this.updateColorForValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorPreferenceName()));
        this.updateComboForValue(this.getPreferenceStore().getString(this.getComboPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateCheckBoxForValue(this.getPreferenceStore().getDefaultBoolean(this.getBooleanPreferenceName()));
        this.updateColorForValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorPreferenceName()));
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getComboPreferenceName()));
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getBooleanPreferenceName(), this.checkBox.getSelection());
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorPreferenceName(), (RGB)this.colorSelector.getColorValue());
        if (this.comboNamesAndValues != null) {
            if (this.comboValue == null) {
                this.getPreferenceStore().setToDefault(this.getComboPreferenceName());
            } else {
                this.getPreferenceStore().setValue(this.getComboPreferenceName(), this.comboValue);
            }
        }
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getBooleanChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = BooleanColorFieldEditor.this.checkBox.getSelection();
                    BooleanColorFieldEditor.this.valueChanged(BooleanColorFieldEditor.this.wasSelected, isSelected);
                    BooleanColorFieldEditor.this.wasSelected = isSelected;
                    BooleanColorFieldEditor.this.colorSelector.setEnabled(BooleanColorFieldEditor.this.wasSelected);
                    if (BooleanColorFieldEditor.this.combo != null) {
                        BooleanColorFieldEditor.this.combo.setEnabled(BooleanColorFieldEditor.this.wasSelected);
                    }
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanColorFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    protected Button getColorChangeControl(Composite parent) {
        if (this.colorSelector == null) {
            this.colorSelector = new ColorSelector(parent);
            this.colorSelector.addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    BooleanColorFieldEditor.this.fireValueChanged(event.getProperty(), event.getOldValue(), event.getNewValue());
                    BooleanColorFieldEditor.this.setPresentsDefaultValue(false);
                }
            });
        } else {
            this.checkParent((Control)this.colorSelector.getButton(), parent);
        }
        return this.colorSelector.getButton();
    }

    protected Combo getComboBoxControl(Composite parent) {
        if (this.combo == null) {
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            int i = 0;
            while (i < this.comboNamesAndValues.length) {
                this.combo.add(this.comboNamesAndValues[i][0], i);
                ++i;
            }
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = BooleanColorFieldEditor.this.comboValue;
                    String name = BooleanColorFieldEditor.this.combo.getText();
                    BooleanColorFieldEditor.this.comboValue = BooleanColorFieldEditor.this.getValueForName(name);
                    BooleanColorFieldEditor.this.setPresentsDefaultValue(false);
                    BooleanColorFieldEditor.this.fireValueChanged("field_editor_value", oldValue, BooleanColorFieldEditor.this.comboValue);
                }
            });
        }
        return this.combo;
    }

    private String getValueForName(String name) {
        int i = 0;
        while (i < this.comboNamesAndValues.length) {
            String[] entry = this.comboNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.comboNamesAndValues[0][0];
    }

    private void updateCheckBoxForValue(boolean value) {
        if (this.checkBox != null) {
            this.checkBox.setSelection(value);
            this.wasSelected = value;
            this.colorSelector.setEnabled(this.wasSelected);
            if (this.combo != null) {
                this.combo.setEnabled(this.wasSelected);
            }
        }
    }

    private void updateColorForValue(RGB value) {
        if (this.colorSelector != null) {
            this.colorSelector.setColorValue(value);
        }
    }

    private void updateComboForValue(String value) {
        if (this.comboNamesAndValues != null) {
            this.comboValue = value;
            int i = 0;
            while (i < this.comboNamesAndValues.length) {
                if (value.equals(this.comboNamesAndValues[i][1])) {
                    this.combo.setText(this.comboNamesAndValues[i][0]);
                    return;
                }
                ++i;
            }
            if (this.comboNamesAndValues.length > 0) {
                this.comboValue = this.comboNamesAndValues[0][1];
                this.combo.setText(this.comboNamesAndValues[0][0]);
            }
        }
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getBooleanChangeControl(parent).setEnabled(enabled);
        this.getColorChangeControl(parent).setEnabled(enabled);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }

    public void store() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore != null) {
            this.doStore();
        }
    }
}

