/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */
public class JStylePreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

    /**
     * Creates a new JStylePreferencePage.
     */
	public JStylePreferencePage() {
		super(GRID);
		setPreferenceStore(JStylePlugin.getDefault().getPreferenceStore());
		setDescription(
				"表示する制御文字の設定を行います。" +
				"この設定はエディター、コンソールなど、" +
				"すべてのテキスト・ビューに影響します。");
	}
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		
		createSpacer();
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_LINE_BREAK,
				"改行(&L)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_TAB,
				"タブ(&T)",
				getFieldEditorParent(),
				JStyleConstants.comboNamesAndValues));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_FULL_WIDTH_SPACE,
				"全角スペース(&F)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_HALF_WIDTH_SPACE,
				"半角スペース(&H)",
				getFieldEditorParent()));
		
		createSpacer();
		
		addField(new BooleanFieldEditor(
				JStyleConstants.P_FORCE_MONOSPACE,
				"太字を通常文字と同じ幅で表示する(&M)",
				getFieldEditorParent()));
	}

	/**
	 * Creates a spacer.
	 */
	private void createSpacer() {
		for (int i = 0; i < BooleanColorFieldEditor.NUM_COLUMNS; i++) {
			addField(new SpacerFieldEditor(getFieldEditorParent()));
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
        // do nothing
	}

	/*
	 * (非 Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#performOk()
	 */
    public boolean performOk() {
    	boolean ret = super.performOk();
    	JStylePlugin.getDefault().applySWT();
        return ret;
    }
}
