/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.metasearch.compass.IndexReadFailedException;
import jp.sourceforge.metasearch.compass.IndexReader;
import jp.sourceforge.metasearch.compass.IndexStatisticsInfo;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.ActionSupport;

/**
 * Statistics Information Action
 *
 * @author Yomei Komiya
 *
 * $Id: StatisticsInfoAction.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class StatisticsInfoAction extends ActionSupport {

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		IndexStatisticsInfo statisticsInfo = null;
		try {
			IndexReader indexReader
				= (IndexReader)this.getWebApplicationContext()
					.getBean("indexReader");
			
			statisticsInfo = indexReader.getStatisticsInfo();
		}
		catch (IndexReadFailedException irfe) {
			irfe.printStackTrace();
			request.setAttribute("errorMessage", irfe.getMessage());
			
			return mapping.findForward("failure");
		}
		finally {
			request.setAttribute("statisticsInfo", statisticsInfo);
		}
		
		return mapping.findForward("statisticsInfo");
	}

}
