/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass;

import org.apache.lucene.index.IndexReader.FieldOption;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.CompassTransaction.TransactionIsolation;
import org.compass.core.lucene.util.LuceneHelper;

/**
 * Index Reader
 *
 * @author Yomei Komiya
 *
 * @since 0.9.2
 * @version $Id: IndexReader.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class IndexReader {
	
	/**
	 * Context Object for Compass
	 * injected by Spring
	 */
	private CompassContext context = null;
	

	public IndexReader() {
		super();
	}

	
	public CompassContext getContext() {
		return context;
	}


	public void setContext(CompassContext context) {
		this.context = context;
	}


	/**
	 * Get Index Statistics Information
	 * 
	 * @return IndexStatisticsInfo object
	 * @throws IndexReadFailedException
	 */
	public IndexStatisticsInfo getStatisticsInfo() throws IndexReadFailedException {

		CompassSession session = null;
		CompassTransaction tx = null;
		IndexStatisticsInfo statisticsInfo = new IndexStatisticsInfo();

		try {
			session = this.context.getCompass().openSession();
			tx = session.beginTransaction(
					TransactionIsolation.READ_ONLY_READ_COMMITTED);
			
			org.apache.lucene.index.IndexReader luceneIndexReader
				= LuceneHelper.getLuceneInternalSearch(session).getReader();
			statisticsInfo.setFieldNames(
					luceneIndexReader.getFieldNames(FieldOption.INDEXED));
			statisticsInfo.setNumDocs(luceneIndexReader.numDocs());
			statisticsInfo.setVersion(
					org.apache.lucene.index.IndexReader.getCurrentVersion(
							luceneIndexReader.directory()));
			//statisticsInfo.setVersion(luceneIndexReader.getVersion());
			
			tx.commit();

			return statisticsInfo;
		}
		catch (CompassException ce) {
			if (tx != null) {
				tx.rollback();
			}
			ce.printStackTrace();
			throw new IndexReadFailedException(ce);
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new IndexReadFailedException(e);
		}
		finally {
			if (session != null) {
				session.close();
			}
		}
	}

}
