/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass.entity;

/**
 * SiteBean
 *
 * @author Yomei Komiya
 * @since 0.9.2 
 *
 * @version $Id: SiteBean.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class SiteBean extends SearchableGenericEntity {

	private String url;
	
	private String searchUrlPrefix;
	
	private String searchLabel;
	
	private String keywords;
	
	private String remarks;
	
	
	public void buildIdentifier() {
		this.setIdentifier(this.getUrl());
	}


	public String getUrl() {
		return url;
	}


	public void setUrl(String url) {
		this.url = url;
	}


	public String getSearchUrlPrefix() {
		return searchUrlPrefix;
	}


	public void setSearchUrlPrefix(String searchUrlPrefix) {
		this.searchUrlPrefix = searchUrlPrefix;
	}


	public String getSearchLabel() {
		return searchLabel;
	}


	public void setSearchLabel(String searchLabel) {
		this.searchLabel = searchLabel;
	}


	public String getKeywords() {
		return keywords;
	}


	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}


	public String getRemarks() {
		return remarks;
	}


	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}
	
}
