/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass.entity;

/**
 * TracNodeChangeBean
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: TracNodeChangeBean.java 5 2007-06-28 13:28:30Z whitestar $
 */
public abstract class TracNodeChangeBean extends SearchableGenericEntity {

	private String rev;
	
	private String message;
	
	private String path;
	
	
	public void buildIdentifier() {
		// http://hostname/context/changeset/<revision>
		this.setIdentifier(
				this.getResourceContext() + this.getRev());
	}


	public String getRev() {
		return rev;
	}


	public void setRev(String rev) {
		this.rev = rev;
	}

	
	public String getMessage() {
		return message;
	}


	public void setMessage(String message) {
		this.message = message;
	}


	public String getPath() {
		return path;
	}


	public void setPath(String path) {
		this.path = path;
	}
	
}
