/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass.gps.device.fs;

import java.io.File;
import java.io.FilenameFilter;

import org.apache.oro.io.Perl5FilenameFilter;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractGpsDevice;

/**
 * AbstractFileGpsDevice
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: AbstractFileGpsDevice.java 5 2007-06-28 13:28:30Z whitestar $
 */
abstract public class AbstractFileGpsDevice extends AbstractGpsDevice {
	
	/**
	 * Directory path
	 */
	private String directory;
	
	/**
	 * File name pattern (Perl 5 regular expressions)
	 */
	private String filenamePattern;
	

	public AbstractFileGpsDevice() {
	}

	
	public AbstractFileGpsDevice(
			String deviceName,
			String directory,
			String filenamePattern) {

		setName(deviceName);
		this.directory = directory;
		this.filenamePattern = filenamePattern;
	}

	
	protected void doStart() throws CompassGpsException {
		if (directory == null || directory.equals("")) {
			throw new IllegalArgumentException(buildMessage(
					"Must set directory property"));
		}
		if (filenamePattern == null || filenamePattern.equals("")) {
			throw new IllegalArgumentException(buildMessage(
					"Must set filenamePattern property"));
		}
	}


	/**
	 * Get matched files
	 * 
	 * @return Matched file list
	 */
	protected File[] getFiles() {
		File dir = new File(this.getDirectory());
		FilenameFilter filenameFilter
			= new Perl5FilenameFilter(this.getFilenamePattern());
		
		return dir.listFiles(filenameFilter);
	}
	
	
	public String getDirectory() {
		return directory;
	}


	public void setDirectory(String directory) {
		this.directory = directory;
	}


	public String getFilenamePattern() {
		return filenamePattern;
	}


	public void setFilenamePattern(String filenamePattern) {
		this.filenamePattern = filenamePattern;
	}

}
