/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass.gps.device.ibatis;

import java.sql.SQLException;
import java.util.Iterator;

import org.compass.core.CompassSession;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.ibatis.SqlMapClientGpsDevice;
import org.compass.gps.device.ibatis.SqlMapGpsDeviceException;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapSession;

/**
 * ExtendedSqlMapClientGpsDevice
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: ExtendedSqlMapClientGpsDevice.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class ExtendedSqlMapClientGpsDevice extends SqlMapClientGpsDevice {

	protected void doIndex(CompassSession session) throws CompassGpsException {
		int pageSize = this.getPageSize();
		String[] selectStatementsIds = this.getSelectStatementsIds();
		SqlMapClient sqlMapClient = this.getSqlMapClient();
		Object[] statementsParameterObjects = this.getStatementsParameterObjects();
		
		if (log.isInfoEnabled()) {
			log.info(buildMessage(
					"Indexing the database with page size [" + pageSize + "] ..."));
		}

		for (int i = 0; i < selectStatementsIds.length; i++) {
			SqlMapSession sqlMapSession = sqlMapClient.openSession();
			try {
				sqlMapSession.startTransaction();
				Object parameterObject = null;
				if (statementsParameterObjects != null) {
					parameterObject = statementsParameterObjects[i];
				}
				
				PaginatedList paginatedList
					= sqlMapSession.queryForPaginatedList(
							selectStatementsIds[i], parameterObject, pageSize);
				
				log.info(buildMessage(
						"Indexing select statement id [" + selectStatementsIds[i] + "] ..."));
				int pageIndex = 0;
				int docCount = 0;
				paginatedList.gotoPage(pageIndex);
				while (true) {
					if (log.isDebugEnabled()) {
						log.debug(buildMessage(
								"Indexing select statement id [" + selectStatementsIds[i]
								+ "] page [" + pageIndex + "]"));
					}
					
					for (Iterator it = paginatedList.iterator(); it.hasNext();) {
						session.create(it.next());
						docCount++;
					}
					session.evictAll();
					
					if (paginatedList.isNextPageAvailable()) {
						pageIndex++;
						paginatedList.gotoPage(pageIndex);
					}
					else {
						log.info(buildMessage(
								docCount + " documents indexed by select statement id ["
								+ selectStatementsIds[i] + "]"));
						
						break;
					}
				}
/*
				do {
					if (log.isDebugEnabled()) {
						log.debug(buildMessage(
								"Indexing select statement id [" + selectStatementsIds[i]
								+ "] page [" + paginatedList.getPageIndex() + "]"));
					}
					for (Iterator it = paginatedList.iterator(); it.hasNext();) {
						session.create(it.next());
					}
					session.evictAll();
				} while (paginatedList.nextPage());
*/				
				sqlMapSession.commitTransaction();
			}
			catch (SQLException e) {
				throw new SqlMapGpsDeviceException(
						"Failed to fetch paginated list for statement ["
						+ selectStatementsIds[i] + "]", e);
			}
			finally {
				try {
					try {
						sqlMapSession.endTransaction();
					}
					catch (Exception e) {
						log.warn(buildMessage("Failed to close sqlMap session, ignoring"), e);
					}
				}
				finally {
					sqlMapSession.close();
				}
			}
		}

		if (log.isInfoEnabled()) {
			log.info(buildMessage("Finished indexing the database"));
		}
	}
	
}
