/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass.util;

import java.util.Comparator;

import jp.sourceforge.metasearch.compass.entity.Searchable;

/**
 * ResultListDefaultComparator
 * Comparator by Score
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: ResultListDefaultComparator.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class ResultListDefaultComparator implements Comparator {

	public ResultListDefaultComparator() {
		super();
	}

	
	public int compare(Object arg0, Object arg1) {
		try {
			if (arg0 == null && arg1 != null) {
				return -1;
			}
			else if (arg0 != null && arg1 == null) {
				return 1;
			}
			else if (arg0 == null && arg1 == null) {
				return 0;
			}
			
			float score0 = ((Searchable)arg0).getScore();
			float score1 = ((Searchable)arg1).getScore();

			if (score0 < score1) {
				return -1;
			}
			else if (score0 > score1) {
				return 1;
			}
			else {
				return 0;
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}

}
