/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.form;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class SearchActionForm extends ActionForm {

	/**
	 * Serial Version UID
	 */
	private static final long serialVersionUID = 3796116849744369372L;

	/**
	 * Query String
	 */
	private String query = "";
	
	/**
	 * Current Query String
	 */
	private String currentQuery = "";
	
	/**
	 * Display Number
	 */
	private int num = 10;
	
	/**
	 * Display Start Position
	 */
	private int start = 0;
	
	
	public int getNum() {
		return num;
	}

	
	public void setNum(int num) {
		this.num = num;
	}

	
	public String getQuery() {
		return query;
	}

	
	public void setQuery(String query) {
		this.query = query;
	}

	
	public final String getCurrentQuery() {
		return currentQuery;
	}


	public final void setCurrentQuery(String currentQuery) {
		this.currentQuery = currentQuery;
	}


	public int getStart() {
		return start;
	}

	
	public void setStart(int start) {
		this.start = start;
	}

	
	public SearchActionForm() {
		super();
	}

	
	public ActionErrors validate(
			ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = super.validate(mapping, request);
		if (errors == null){
			errors = new ActionErrors();
		}
		
		if (this.query == null || this.query.equals("")) {
			errors.add("query", new ActionMessage("error.query.required"));
		}
		
		if (this.num < 10) {
			errors.add("query", new ActionMessage("error.query.required"));
		}
		
		if (this.start < 0) {
			errors.add("query", new ActionMessage("error.query.required"));
		}
		
		if (errors.isEmpty()){
			return null;
		}
		else{
			return errors;
		}
	}

}
