/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.ws;

import java.rmi.RemoteException;

import jp.sourceforge.metasearch.compass.IndexSearcher;
import jp.sourceforge.metasearch.compass.SearchFailedException;
import jp.sourceforge.metasearch.compass.SearchResult;

import org.springframework.remoting.jaxrpc.ServletEndpointSupport;

/**
 * SearchServiceEndpoint
 *
 * @author Yomei Komiya
 *
 * @since 0.9.2
 * @version $Id: SearchServiceEndpoint.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class SearchServiceEndpoint extends ServletEndpointSupport
	implements	SearchWebService {
	
	/**
	 * Index Searcher Object
	 */
	private IndexSearcher indexSearcher = null;

	
	protected void onInit() {
		this.indexSearcher
			= (IndexSearcher)getWebApplicationContext()
				.getBean("indexSearcher");
	}

	
	public String getVersion() throws RemoteException {
		return "0.9.0";
	}


	/*
	 * @see jp.sourceforge.webframe.blankapp.ws.search.SearchWebService#find(java.lang.String)
	 */
	public Result find(String query)
		throws SearchFailedException, RemoteException {

		return this.seek(query, 10, 0);
	}
	
	
	/*
	 * @see jp.sourceforge.webframe.blankapp.ws.search.SearchWebService#seek(java.lang.String, int, int)
	 */
	public Result seek(String query, int num, int start)
		throws SearchFailedException, RemoteException {

		return this.refineSearch(query, null, num, start);
	}

	
	/*
	 * @see jp.sourceforge.webframe.blankapp.ws.search.SearchWebService#refineSearch(java.lang.String, java.lang.String, int, int)
	 */
	public Result refineSearch(
			String query,
			String currentQuery,
			int num,
			int start)
		throws SearchFailedException, RemoteException {
	
		try {
			SearchResult searchResult
				= this.indexSearcher.find(query, currentQuery, num, start);
		
			return new Result(searchResult);
		}
		catch (SearchFailedException sfe) {
			throw sfe;
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new RemoteException(e.getMessage());
		}
	}

}
