#include "common.h"

extern "C" {
#include <libgen.h>
#include <signal.h>
}

VALUE mf_keycommand(VALUE self, VALUE rmeta, VALUE rkeycode, VALUE rextension, VALUE rcommand)
{
TBEGIN();

    Check_Type(rmeta, T_FIXNUM);
    Check_Type(rkeycode, T_FIXNUM);
    Check_Type(rextension, T_STRING);
    Check_Type(rcommand, T_STRING);

    int meta = NUM2INT(rmeta);
    int keycode = NUM2INT(rkeycode);
    char* extension = RSTRING(rextension)->ptr;
    char* command = RSTRING(rcommand)->ptr;

    gKeyCommand[meta][keycode][string(extension)] = rb_str_new2(command);
    rb_global_variable(&gKeyCommand[meta][keycode][string(extension)]);

//M(("%d %d %s %s (%s)\n", meta, keycode, extension, command, RSTRING(gKeyCommand[meta][keycode][extension])->ptr));


TEND();                 
    return Qnil;
}

VALUE mf_exit(VALUE self)
{
TBEGIN();
    if(gCheckExit) {
        const char* str[] = {
            "Yes", "No"
        };

        int ret = select_str("exit ok?", (char**)str, 2, 1);

        if(ret == 1) return Qnil;
    }

    gMainLoop = false;

TEND();    
    return Qnil;
}

VALUE mf_cursor_move(VALUE self, VALUE rvalue)
{
TBEGIN();

    Check_Type(rvalue, T_FIXNUM);
    
    ActiveDir()->MoveCursor(NUM2INT(rvalue));

TEND();
    
    return Qnil;
}

VALUE mf_cursor_left(VALUE self)
{
TBEGIN();

    if(gRDir->mActive)
        gLDir->Activate(gRDir);
/*        
    else {
        gLDir->PushBackDir();
        gLDir->PopDir();
    }
*/
TEND();
    
    return Qnil;
}

VALUE mf_cursor_right(VALUE self)
{
TBEGIN();

    if(gLDir->mActive)
        gRDir->Activate(gLDir);
/*        
    else {
        gRDir->PushBackDir();
        gRDir->PopDir();
    }
*/

TEND();
    
    return Qnil;
}

VALUE mf_dir_move(VALUE self, VALUE rdir)
{
TBEGIN();

    Check_Type(rdir, T_STRING);
    
    ActiveDir()->Move(RSTRING(rdir)->ptr);

TEND();    

    return Qnil;
}

VALUE mf_view_nameonly(VALUE self)
{
TBEGIN();

    cDirWnd::gViewOption = cDirWnd::kNameOnly;

TEND();

    return Qnil;
}

VALUE mf_view_all(VALUE self)
{
TBEGIN();

    cDirWnd::gViewOption = cDirWnd::kAll;

TEND();

    return Qnil;
}

VALUE mf_view_onedir(VALUE self)
{
TBEGIN();

    cDirWnd::gViewOption = cDirWnd::kOneDir;

TEND();

    return Qnil;
}

VALUE mf_isearch(VALUE self)
{
TBEGIN();

    gISearch = !gISearch;
    
TEND();

    return Qnil;
}

VALUE mf_option_color(VALUE self, VALUE boolean)
{
TBEGIN();

    gColor = (boolean == Qtrue);

TEND();

    return Qnil;
}

VALUE mf_option_individual_cursor(VALUE self, VALUE boolean)
{
TBEGIN();

    gIndividualCursor = (boolean == Qtrue);

TEND();

    return Qnil;
}

VALUE mf_option_shift_isearch(VALUE self, VALUE boolean)
{
TBEGIN();

    gShiftISearch = (boolean == Qtrue);

TEND();

    return Qnil;
}

VALUE mf_option_check_delete_file(VALUE self, VALUE boolean)
{
TBEGIN();

    gCheckDeleteFile = (boolean == Qtrue);

TEND();

    return Qnil;
}

VALUE mf_option_check_copy_file(VALUE self, VALUE boolean)
{
TBEGIN();

    gCheckCopyFile = (boolean == Qtrue);

TEND();

    return Qnil;
}

VALUE mf_option_check_exit(VALUE self, VALUE boolean)
{
TBEGIN();

    gCheckExit = (boolean == Qtrue);

TEND();

    return Qnil;
}

VALUE mf_option_trashbox_name(VALUE self, VALUE name)
{
TBEGIN();

    Check_Type(name, T_STRING);

    strcpy(gTrashBoxName, RSTRING(name)->ptr);

TEND();

    return Qnil;
}

VALUE mf_sort_name(VALUE self)
{
TBEGIN();

    cDirWnd::gSortKind = cDirWnd::kName;

    gLDir->Sort();
    gRDir->Sort();

TEND();    

    return Qnil;
}

VALUE mf_sort_ext(VALUE self)
{
TBEGIN();

    cDirWnd::gSortKind = cDirWnd::kExt;

    gLDir->Sort();
    gRDir->Sort();

TEND();
    
    return Qnil;
}

VALUE mf_sort_size(VALUE self)
{
TBEGIN();

    cDirWnd::gSortKind = cDirWnd::kSize;

    gLDir->Sort();
    gRDir->Sort();

TEND();    

    return Qnil;
}

VALUE mf_sort_time(VALUE self)
{
TBEGIN();

    cDirWnd::gSortKind = cDirWnd::kTime;

    gLDir->Sort();
    gRDir->Sort();

TEND();    

    return Qnil;
}

VALUE mf_mark_all(VALUE self)
{
TBEGIN();

    ActiveDir()->MarkAll();

TEND();    

    return Qnil;
}

VALUE mf_mark_all_files(VALUE self)
{
TBEGIN();

    ActiveDir()->MarkAllFiles();

TEND();    

    return Qnil;
}

VALUE mf_mark(VALUE self)
{
TBEGIN();

    ActiveDir()->Mark();
    ActiveDir()->MoveCursor(1);

TEND();    
    
    return Qnil;
}

VALUE mf_cmdline(VALUE self, VALUE command, VALUE position)
{
TBEGIN();

    Check_Type(command, T_STRING);
    Check_Type(position, T_FIXNUM);
    
    cmdline_start(RSTRING(command)->ptr, NUM2INT(position));

TEND();    
    
    return Qnil;
}

VALUE mf_shell(VALUE self, VALUE cmd, VALUE title)
{
TBEGIN();

    Check_Type(cmd, T_STRING);
    Check_Type(title, T_STRING);
    
    cmdline_run(RSTRING(cmd)->ptr, RSTRING(title)->ptr);

TEND();    

    return Qnil;
}

VALUE mf_defmenu(int argc, VALUE* argv, VALUE self)
{
TBEGIN();

    /// check arguments ///
    if(argc%3 != 1) {
        rb_raise(rb_eArgError, "wrong argument in mf_menu");
    }

    /// entry menu ///
    const char* menu_name = RSTRING(argv[0])->ptr;
    
    if(gMenu.find(menu_name) != gMenu.end()) {
        rb_raise(rb_eArgError, "already entried menu \"%s\"", menu_name);
    }

    cMenu* new_menu = new cMenu((char*)menu_name);

    for(int i=1; i<argc; i+=3) {
        Check_Type(argv[i], T_STRING);
        Check_Type(argv[i+1], T_FIXNUM);
        Check_Type(argv[i+2], T_STRING);

        new_menu->Append(RSTRING(argv[i])->ptr, NUM2INT(argv[i+1]), RSTRING(argv[i+2])->ptr);
    }
    
    gMenu[RSTRING(argv[0])->ptr] = new_menu;

TEND();

    return Qnil;
}

VALUE mf_menu(VALUE self, VALUE menu_name)
{
TBEGIN();

    Check_Type(menu_name, T_STRING);

    gActiveMenu = gMenu[RSTRING(menu_name)->ptr];
    if(gActiveMenu == NULL) {
        err_msg("not found menu name(%s)", RSTRING(menu_name)->ptr);
        gActiveMenu = NULL;
        return Qnil;
    }
    gActiveMenu->Show();

TEND();    

    return Qnil;
}

VALUE mf_dir_copy(VALUE self)
{
TBEGIN();

    ActiveDir()->Move(SleepDir()->Path());

TEND();    
    
    return Qnil;
}

VALUE mf_dir_exchange(VALUE self)
{
TBEGIN();

    cDirWnd* wnd = gLDir;
    gLDir = gRDir;
    gRDir = wnd;

TEND();    
    
    return Qnil;
}

VALUE mf_refresh(VALUE self)
{
TBEGIN();

    gLDir->Reread();
    gRDir->Reread();
    
    clear();

TEND();
    
    return Qnil;
}

VALUE mf_reread(VALUE self)
{
TBEGIN();

    gLDir->Reread();
    gRDir->Reread();

TEND();
    
    return Qnil;
}

VALUE mf_dir_back(VALUE self)
{
TBEGIN();

    ActiveDir()->MoveBack();

TEND();    

    return Qnil;
}

VALUE mf_cursor_name(VALUE self)
{
    return rb_str_new2(ActiveDir()->CursorFile().mName);
}

VALUE mf_cursor_path(VALUE self)
{
    char buf[512];
    sprintf(buf, "%s%s", ActiveDir()->Path(), ActiveDir()->CursorFile().mName);
    
    return rb_str_new2(buf);
}

VALUE mf_cursor_ext(VALUE self)
{
TBEGIN();
    char* tmp = extname(ActiveDir()->CursorFile().mName);
    VALUE result = rb_str_new2(tmp);
    FREE(tmp);
TEND();    

    return result;
}

VALUE mf_cursor_noext(VALUE self)
{
TBEGIN();

    char* tmp = noextname(ActiveDir()->CursorFile().mName);
    VALUE result = rb_str_new2(tmp);
    FREE(tmp);

TEND();    

    return result;
}

VALUE mf_active_dir(VALUE self)
{
    char* tmp = STRDUP(ActiveDir()->Path());
    char* tmp2 = basename(tmp);
    FREE(tmp);
    return rb_str_new2(tmp2);
}

VALUE mf_sleep_dir(VALUE self)
{
    char* tmp = STRDUP(SleepDir()->Path());
    char* tmp2 = basename(tmp);
    FREE(tmp);
    return rb_str_new2(tmp2);
}

VALUE mf_adir_path(VALUE self)
{
    char buf[1024];
    strcpy(buf, ActiveDir()->Path());
    buf[strlen(buf)-1] = 0;

    return rb_str_new2(buf);
}

VALUE mf_sdir_path(VALUE self)
{
    char buf[1024];
    strcpy(buf, SleepDir()->Path());
    buf[strlen(buf)-1] = 0;

    return rb_str_new2(buf);
}

VALUE mf_adir_mark(VALUE self)
{
    return ActiveDir()->MarkFiles();
}

VALUE mf_sdir_mark(VALUE self)
{
    return SleepDir()->MarkFiles();
}

VALUE mf_dir_new(VALUE self)
{
    ActiveDir()->PushFrontDir();

    return Qnil;
}

VALUE mf_dir_close(VALUE self)
{
    ActiveDir()->PopDir();
    
    return Qnil;
}

VALUE mf_dir_up(VALUE self)
{
    ActiveDir()->PushBackDir();
    ActiveDir()->PopDir();

    return Qnil;
}

VALUE mf_copy(VALUE self, VALUE sdir, VALUE files, VALUE ddir)
{
TBEGIN();
    if(gCheckCopyFile) {
        const char* str[] = {
            "Yes", "No"
        };

        int ret = select_str("copy ok?", (char**)str, 2, 1);

        if(ret == 1) return Qnil;
    }

    int i = 0;

    gCopyOverride = kNone;

    Check_Type(sdir, T_STRING);
    Check_Type(files, T_ARRAY);
    Check_Type(ddir, T_STRING);

    /// check argument ///
    if(RSTRING(ddir)->ptr[strlen(RSTRING(ddir)->ptr)-1] != '/') {
        char tmp[1024];
        strcpy(tmp, RSTRING(ddir)->ptr);
        strcat(tmp, "/");

        ddir = rb_str_new2(tmp);
    }

    for(int i=0; i < RARRAY(files)->len; i++) {
        VALUE item = rb_ary_entry(files, i);
        Check_Type(item, T_STRING);

        if(strcmp(RSTRING(item)->ptr, ".") != 0
            && strcmp(RSTRING(item)->ptr, "..") != 0)
        {
            char spath[PATH_MAX];
            strcpy(spath, RSTRING(sdir)->ptr);
            strcat(spath, "/");
            strcat(spath, RSTRING(item)->ptr);
    
            char dpath[PATH_MAX];
            strcpy(dpath, RSTRING(ddir)->ptr);

            file_copy(spath, dpath, false);
        }
    }

    gLDir->Reread();
    gRDir->Reread();
    
TEND();    

    return Qnil;
}

VALUE mf_move(VALUE self, VALUE sdir, VALUE files, VALUE ddir)
{
TBEGIN();
    if(gCheckCopyFile) {
        const char* str[] = {
            "Yes", "No"
        };

        int ret = select_str("move ok?", (char**)str, 2, 1);

        if(ret == 1) return Qnil;
    }

    int i = 0;

    gCopyOverride = kNone;

    Check_Type(sdir, T_STRING);
    Check_Type(files, T_ARRAY);
    Check_Type(ddir, T_STRING);

    /// check argument ///
    if(RSTRING(ddir)->ptr[strlen(RSTRING(ddir)->ptr)-1] != '/') {
        char tmp[1024];
        strcpy(tmp, RSTRING(ddir)->ptr);
        strcat(tmp, "/");

        ddir = rb_str_new2(tmp);
    }

    for(int i=0; i < RARRAY(files)->len; i++) {
        VALUE item = rb_ary_entry(files, i);

        Check_Type(item, T_STRING);

        if(strcmp(RSTRING(item)->ptr, ".") != 0
            && strcmp(RSTRING(item)->ptr, "..") != 0)
        {
            char spath[PATH_MAX];
            strcpy(spath, RSTRING(sdir)->ptr);
            strcat(spath, "/");
            strcat(spath, RSTRING(item)->ptr);

            char dpath[PATH_MAX];
            strcpy(dpath, RSTRING(ddir)->ptr);

            file_copy(spath, dpath, true);
        }
    }

    gLDir->Reread();
    gRDir->Reread();
    
TEND();    

    return Qnil;
}

VALUE mf_remove(VALUE self, VALUE sdir, VALUE files)
{
TBEGIN();

    gCopyOverride = kNone;

    if(gCheckDeleteFile) {
        const char* str[] = {
            "Yes", "No"
        };

        int ret = select_str("delete ok?", (char**)str, 2, 1);

        if(ret == 1) return Qnil;
    }

    Check_Type(sdir, T_STRING);
    Check_Type(files, T_ARRAY);
    
    for(int i= 0; i < RARRAY(files)->len; i++) {
        VALUE item = rb_ary_entry(files, i);
        Check_Type(item, T_STRING);

        if(strcmp(RSTRING(item)->ptr, ".") != 0
            && strcmp(RSTRING(item)->ptr, "..") != 0)
        {
            char spath[PATH_MAX];
            strcpy(spath, RSTRING(sdir)->ptr);
            strcat(spath, "/");
            strcat(spath, RSTRING(item)->ptr);

            file_remove(spath);
        }
    }

    gLDir->Reread();
    gRDir->Reread();

TEND();

    return Qnil;
}

VALUE mf_select_pty(VALUE self, VALUE title)
{
    Check_Type(title, T_STRING);

    return INT2FIX(cmdline_select_pty(RSTRING(title)->ptr) + 1);
}

VALUE mf_kill_pty(VALUE self, VALUE n)
{
TBEGIN();

    Check_Type(n, T_FIXNUM);

    const int m = NUM2INT(n);
    if(m >= 1 && m <= gTty.size()) {
        kill(gTty[m-1]->mPID, SIGKILL);

        int j=0;
        for(vector<sMasterTty*>::iterator i=gTty.begin();
            i!=gTty.end();
            i++)
        {
            if(j == m-1) {
                FREE(*i);
                gTty.erase(i);
                break;
            }

            j++;
        }
    }

TEND();

    return Qnil;
}

VALUE mf_restore_pty(VALUE self, VALUE n)
{
TBEGIN();

    Check_Type(n, T_FIXNUM);
    
    cmdline_restore_pty(NUM2INT(n)-1);

TEND();

    return Qnil;
}

VALUE mf_trashbox(VALUE self, VALUE sdir, VALUE files)
{
TBEGIN();

    char* home = getenv("HOME");
    if(home == NULL) {
        err_msg("trashbox: $HOME is NULL");
        return Qnil;
    }

    char tbpath[PATH_MAX];
    strcpy(tbpath, home);
    strcat(tbpath, "/");
    strcat(tbpath, gTrashBoxName);

    if(gCheckDeleteFile) {
        const char* str[] = {
            "Yes", "No"
        };

        int ret;
        if(strcmp(RSTRING(sdir)->ptr, tbpath) == 0) {
            ret = select_str("delete ok?", (char**)str, 2, 1);
        }
        else {
            ret = select_str("move to the trashbox ok?", (char**)str, 2, 1);
        }

        if(ret == 1) return Qnil;
    }

    Check_Type(sdir, T_STRING);
    Check_Type(files, T_ARRAY);

    gCopyOverride = kYesAll;

    /// make mtrashbox ///
    if(access(tbpath, F_OK) == 0) {
        struct stat tbstat;
        if(stat(tbpath, &tbstat) < 0) {
            err_msg("trashbox: stat err(%s)", tbpath);
            return Qnil;
        }
        if(!S_ISDIR(tbstat.st_mode)) {
            char buf[256];
            sprintf(buf, "trashbox: $HOME/%s is not directory", gTrashBoxName);
            err_msg(buf);
            return Qnil;
        }
    }
    else {
        if(mkdir(tbpath, 0755) < 0) {
            char buf[256];
            sprintf(buf, "trashbox: can't make $HOME/%s", gTrashBoxName);
            err_msg(buf);
            return Qnil;
        }
    }

    /// go ///    
    if(strcmp(RSTRING(sdir)->ptr, tbpath) == 0) {
        for(int i= 0; i < RARRAY(files)->len; i++) {
            VALUE item = rb_ary_entry(files, i);
            Check_Type(item, T_STRING);
    
            if(strcmp(RSTRING(item)->ptr, ".") != 0
                && strcmp(RSTRING(item)->ptr, "..") != 0)
            {
                char spath[PATH_MAX];
                strcpy(spath, RSTRING(sdir)->ptr);
                strcat(spath, "/");
                strcat(spath, RSTRING(item)->ptr);

                file_remove(spath);
            }
        }
    }
    else {
        for(int i=0; i < RARRAY(files)->len; i++) {
            VALUE item = rb_ary_entry(files, i);
    
            Check_Type(item, T_STRING);
    
            if(strcmp(RSTRING(item)->ptr, ".") != 0
                && strcmp(RSTRING(item)->ptr, "..") != 0)
            {
                char spath[PATH_MAX];
                strcpy(spath, RSTRING(sdir)->ptr);
                strcat(spath, "/");
                strcat(spath, RSTRING(item)->ptr);

                strcat(tbpath, "/");
                
                file_copy(spath, tbpath, true);
            }
        }
    }

    gLDir->Reread();
    gRDir->Reread();
    
TEND();

    return Qnil;
}

void command_init()
{
TBEGIN();

    rb_define_global_function("mf_exit", RUBY_METHOD_FUNC(mf_exit), 0);
    rb_define_global_function("keycommand", RUBY_METHOD_FUNC(mf_keycommand), 4);
    rb_define_global_function("cursor_move", RUBY_METHOD_FUNC(mf_cursor_move), 1);
    rb_define_global_function("cursor_left", RUBY_METHOD_FUNC(mf_cursor_left), 0);
    rb_define_global_function("cursor_right", RUBY_METHOD_FUNC(mf_cursor_right), 0);
    rb_define_global_function("dir_move", RUBY_METHOD_FUNC(mf_dir_move), 1);
    
    rb_define_global_function("sort_name", RUBY_METHOD_FUNC(mf_sort_name), 0);
    rb_define_global_function("sort_ext", RUBY_METHOD_FUNC(mf_sort_ext), 0);
    rb_define_global_function("sort_size", RUBY_METHOD_FUNC(mf_sort_size), 0);
    rb_define_global_function("sort_time", RUBY_METHOD_FUNC(mf_sort_time), 0);

    rb_define_global_function("view_all", RUBY_METHOD_FUNC(mf_view_all), 0);
    rb_define_global_function("view_nameonly", RUBY_METHOD_FUNC(mf_view_nameonly), 0);
    rb_define_global_function("view_onedir", RUBY_METHOD_FUNC(mf_view_onedir), 0);

    rb_define_global_function("isearch", RUBY_METHOD_FUNC(mf_isearch), 0);

    rb_define_global_function("option_individual_cursor", RUBY_METHOD_FUNC(mf_option_individual_cursor), 1);

    rb_define_global_function("option_color", RUBY_METHOD_FUNC(mf_option_color), 1);
    rb_define_global_function("option_check_delete_file", RUBY_METHOD_FUNC(mf_option_check_delete_file), 1);
    rb_define_global_function("option_check_copy_file", RUBY_METHOD_FUNC(mf_option_check_delete_file), 1);
    rb_define_global_function("option_check_exit", RUBY_METHOD_FUNC(mf_option_check_exit), 1);
    rb_define_global_function("option_shift_isearch", RUBY_METHOD_FUNC(mf_option_shift_isearch), 1);
    rb_define_global_function("option_trashbox_name", RUBY_METHOD_FUNC(mf_option_trashbox_name), 1);

    rb_define_global_function("mark_all", RUBY_METHOD_FUNC(mf_mark_all), 0);
    rb_define_global_function("mark_all_files", RUBY_METHOD_FUNC(mf_mark_all_files), 0);
    rb_define_global_function("mark", RUBY_METHOD_FUNC(mf_mark), 0);
    rb_define_global_function("cmdline", RUBY_METHOD_FUNC(mf_cmdline), 2);
    rb_define_global_function("shell", RUBY_METHOD_FUNC(mf_shell), 2);
    rb_define_global_function("menu", RUBY_METHOD_FUNC(mf_menu), 1);
    rb_define_global_function("defmenu", RUBY_METHOD_FUNC(mf_defmenu), -1);
    
    rb_define_global_function("dir_exchange", RUBY_METHOD_FUNC(mf_dir_exchange), 0);
    rb_define_global_function("dir_copy", RUBY_METHOD_FUNC(mf_dir_copy), 0);
    rb_define_global_function("refresh", RUBY_METHOD_FUNC(mf_refresh), 0);
    rb_define_global_function("reread", RUBY_METHOD_FUNC(mf_reread), 0);
    rb_define_global_function("dir_back", RUBY_METHOD_FUNC(mf_dir_back), 0);

    rb_define_global_function("dir_new", RUBY_METHOD_FUNC(mf_dir_new), 0);
    rb_define_global_function("dir_close", RUBY_METHOD_FUNC(mf_dir_close), 0);
    rb_define_global_function("dir_up", RUBY_METHOD_FUNC(mf_dir_up), 0);

    rb_define_global_function("cursor_name", RUBY_METHOD_FUNC(mf_cursor_name), 0);
    rb_define_global_function("cursor_path", RUBY_METHOD_FUNC(mf_cursor_path), 0);
    rb_define_global_function("cursor_ext", RUBY_METHOD_FUNC(mf_cursor_ext), 0);
    rb_define_global_function("cursor_noext", RUBY_METHOD_FUNC(mf_cursor_noext), 0);
    rb_define_global_function("active_dir", RUBY_METHOD_FUNC(mf_active_dir), 0);
    rb_define_global_function("sleep_dir", RUBY_METHOD_FUNC(mf_sleep_dir), 0);
    rb_define_global_function("adir_path", RUBY_METHOD_FUNC(mf_adir_path), 0);
    rb_define_global_function("sdir_path", RUBY_METHOD_FUNC(mf_sdir_path), 0);
    rb_define_global_function("adir_mark", RUBY_METHOD_FUNC(mf_adir_mark), 0);
    rb_define_global_function("sdir_mark", RUBY_METHOD_FUNC(mf_sdir_mark), 0);
    
    rb_define_global_function("copy", RUBY_METHOD_FUNC(mf_copy), 3);
    rb_define_global_function("remove", RUBY_METHOD_FUNC(mf_remove), 2);
    rb_define_global_function("move", RUBY_METHOD_FUNC(mf_move), 3);
    rb_define_global_function("trashbox", RUBY_METHOD_FUNC(mf_trashbox), 2);
    
    rb_define_global_function("select_pty", RUBY_METHOD_FUNC(mf_select_pty), 1);
    rb_define_global_function("kill_pty", RUBY_METHOD_FUNC(mf_kill_pty), 1);
    rb_define_global_function("restore_pty", RUBY_METHOD_FUNC(mf_restore_pty), 1);

TEND();    
}

void command_final()
{
TBEGIN();

TEND();
}
