#ifndef MFILER2_DIRWND
#define MFILER2_DIRWND

#include <vector>

extern "C" {
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
}

struct sFile{
    char mName[PATH_MAX];
    struct stat mStat;
    struct stat mLStat;
    bool mMark;

    sFile(char* name, struct stat* stat_, struct stat* lstat_, bool mark)
    {
        strcpy(mName, name);
        mStat = *stat_;
        mLStat = *lstat_;
        mMark = mark;
    }
};

class cDirWnd {
    char mPath[PATH_MAX];    // last char is '/'

    vector<sFile> mFiles;
    
    int mScrollTop;
    int mCursor;

    list<string> mDirStack;
   
    static bool sort_name(sFile left, sFile right);
    static bool sort_ext(sFile left, sFile right);
    static bool sort_size(sFile left, sFile right);
    static bool sort_time(sFile left, sFile right);

    static const int kMaxYMinus = 4;

    void read();
    bool check_path(char* new_path);
public:
    cDirWnd(char* path, bool active);
    ~cDirWnd();

    static void* operator new(size_t size) { return MALLOC(size); }
    static void operator delete(void* p) { FREE(p); }

    static const int kDirStackSize = 500;

    /// properties ///
    bool mActive;
   
    enum eSortKind { kName, kExt, kSize, kTime };
    static eSortKind gSortKind;

    enum eViewOption { kNameOnly, kAll, kOneDir };
    static eViewOption gViewOption;

    vector<sFile>* Files() { return &mFiles; }
    sFile CursorFile();
    char* Path() { return mPath; }
    VALUE MarkFiles();
    void MarkFilesSQuote(RESULT char* result);

    bool Marking();

    /// methods ///
    void Mark();
    void MarkAll();
    void MarkAllFiles();
   
    void MoveCursor(int value);
    void MoveCursorIndex(int index);
    void Activate(cDirWnd* current);

    void Move(char* path);        // last char don't have to be '/'
    void MoveBack();

    void PushFrontDir();
    void PushBackDir();
    void PopDir();
   
    void Sort();
    void View();

    void Reread();
};

extern cDirWnd* ActiveDir();
extern cDirWnd* SleepDir();

#endif
