#ifndef MINATO__MVECTOR_H
#define MINATO__MVECTOR_H

#define BOOL int
#define TRUE 1
#define FALSE 0

typedef struct {
   void** mTable;
   int mTableSize;
   
   int mCount;
} vector_obj;

vector_obj* vector_new(int first_size);
void vector_delete(vector_obj* self);

void* vector_item(vector_obj* self, int index);
int vector_size(vector_obj* self);
int vector_index(vector_obj* self, void* item);

void vector_exchange(vector_obj* self, int n, void* item);
void vector_add(vector_obj* self, void* item);
void vector_insert(vector_obj* self, int n, void* item);
void vector_erase(vector_obj* self, int n);
void vector_pop_back(vector_obj* self);
void vector_clear(vector_obj* self);

typedef BOOL (*sort_if)(void* left, void* right);
void vector_sort(vector_obj* self, sort_if fun);

#endif
