#include "common.h"

bool gViewHelp = false;
   
static int gScrollTop = 0;

const int kMaxMessage = 48;

void help_start()
{
    gViewHelp = true;
    gScrollTop = 0;
}

void help_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    mclear();

    mmove(0,0);

    char buf[kMaxMessage][80];

    strcpy(buf[0], "UP, CTRL-P                        move cursor up");
    strcpy(buf[1], "DOWN, CTRL-N                      move cursor down");
    strcpy(buf[2], "LEFT, CTRL-B                      move cursor left");
    strcpy(buf[3], "RIGHT, CTRL-F                     move cursor right");
    strcpy(buf[4], "<, CTRL-A                         move cursor top");
    strcpy(buf[5], ">, CTRL-E                         move cursor bottom");
    strcpy(buf[6], "PAGEUP, CTRL-U                    move cursor 5 up");
    strcpy(buf[7], "PAGEDOWN, CTRL-D                  move cursor 5 down");
    strcpy(buf[8], "BACKSPACE, CTRL-H                 move to parent direcotry");
    strcpy(buf[9], "Meta + Left                       move to previous directory");
    strcpy(buf[10], "\\                                 move to root directory");
    strcpy(buf[11], "~                                 move to home directory"); 
    strcpy(buf[12], "ENTER                             run cursor file(insert directory)");
    strcpy(buf[13], "q                                 quit the Minnu's Filer");
    strcpy(buf[14], "CTRL+L                            redraw the screen");
    strcpy(buf[15], "c                                 copy file");
    strcpy(buf[16], "d                                 move file to $HOME/mtrashbox");
    strcpy(buf[17], "e                                 edit file(run $EDITOR)");
    strcpy(buf[18], "v                                 view file(run $PAGER)");
    strcpy(buf[19], "r                                 rename");
    strcpy(buf[20], "a                                 open attribute menu");
    strcpy(buf[21], "n                                 make new file");
    strcpy(buf[22], "k                                 make new direcotry");
    strcpy(buf[23], "p                                 compression");
    strcpy(buf[24], "b                                 backup");
    strcpy(buf[25], "i                                 info");
    strcpy(buf[26], "g                                 grep");
    strcpy(buf[27], "f                                 file mask settings");
    strcpy(buf[28], "s                                 open sort and view menu");
    strcpy(buf[29], "w                                 copy direcotry path");
    strcpy(buf[30], "o                                 exchange two directories");
    strcpy(buf[31], "j                                 jump directory");
    strcpy(buf[32], "l                                 change directory with cmdline");
    strcpy(buf[33], "@                                 extra file menu");
    strcpy(buf[34], "CTRL-C                            copy a file under cursor or mark files");
    strcpy(buf[35], "CTRL-X                            cut a file under cursor or mark files");
    strcpy(buf[36], "CTRL-V                            past files");
    strcpy(buf[37], "/                                 toggle incremental search");
    strcpy(buf[38], "h                                 switch command line mode");
    strcpy(buf[39], "x                                 run a command with file under cursor");
    strcpy(buf[40], ":                                 run shell($SHELL)");
    strcpy(buf[41], "z                                 next command will be runned with xterminal");
    strcpy(buf[42], "SPACE                             mark file under cursor"); 
    strcpy(buf[43], "HOME                              mark all files");
    strcpy(buf[44], "END                               mark all files without directory");
    strcpy(buf[45], "CTRL + T                          clone new tab");
    strcpy(buf[46], "CTRL + W                          remove current tab");
    strcpy(buf[47], "CTRL + I (tab)                    change current tab");

    for(int i=gScrollTop; i<gScrollTop+maxy; i++) {
        if(i < kMaxMessage) {
            mmvprintw(i-gScrollTop, 0, buf[i]);
        }   
    }

    mmove_immediately(maxy-1, maxx-1);
    mrefresh();
}

void help_input(int meta, int key)
{
    const int maxy = mgetmaxy();

    // 'q' CTRL-C CTRL-G Escape
    if(key == 'q' || key == 3 || key == 7||key == 27) { 
        gViewHelp = false;
    }
    // space f CTRL-D PAGE DOWN
    else if(key == ' '|| key == 'f' || key == 4||key == KEY_NPAGE) {
        if(kMaxMessage >= maxy) {
            gScrollTop += 10;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    // b CTRL-U PAGE UP
    else if(key == 'b' || key ==21 || key == KEY_PPAGE) {
        gScrollTop -= 10;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
    // CTRL-N DOWN CTRL-M CTRL-J
    else if(key == 14 || key == 10 || key == 13 || key == KEY_DOWN) {
        if(kMaxMessage >= maxy) {
            gScrollTop ++;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    else if(key == 16 || key == KEY_UP) {    /// CTRL-P UP
        gScrollTop--;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
}
