#include "common.h"

extern "C"
{
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <termios.h>
#include <ctype.h>
#include <stdarg.h>
#include <time.h>
#include <pwd.h>
}

const int kKeyMetaFirst = 128;
const int kKeyEsc = 27;

cDirWnd* gLDir;
cDirWnd* gRDir;
bool gMainLoop;
hash_obj* gKeyCommand[2][KEY_MAX];

bool gISearch = false;
bool gColor = false;
bool gIndividualCursor = false;
bool gCheckDeleteFile = true;
bool gCheckCopyFile = true;
bool gCheckExit = true;
bool gProcessLine = true;
bool gShiftISearch = false;
bool gGnuScreen = false;
bool gPty = false;
bool gAutoRehash = false;

bool gBoldExe = true;
bool gBoldDir = true;
int gColorMark = kCARed;
int gColorDir = kCABlue;
int gColorExe = kCAGreen;
int gColorLink = kCACyan;
bool gISearchEnterDecision = false;
bool gRemainCursor = true;

char gTrashBoxName[256];

static string_obj* gInputFileName;

static void read_rc_file(bool read_etc);
static void input(int meta, int key);

void atexit_fun()
{
    tcsetattr(STDIN_FILENO, TCSANOW, &gTtySave);
}

void sig_exit(int signal)
{
M(("signal %d", signal));
//    gMainLoop = false;

tcsetattr(STDIN_FILENO, TCSANOW, &gTtySave);

exit(1);        
}

void sig_child(int siganl)
{
M(("sig_child"));
    int status;
    waitpid(-1, &status, WNOHANG);
}

void sig_winch(int signal)
{
    gLDir->Reread();
    gRDir->Reread(); 
   
    mclear_immediately();
    mclear();
    view();
    mrefresh();
}

#if defined(__SOLARIS__)
char** environ;
int main(int argc, char* argv[], char** envp)
{
    environ = envp;
#else
int main(int argc, char* argv[])
{
#endif
CHECKML_BEGIN();
LOG_BEGIN();

    /// is terminal ///
    if(!isatty(0) || !isatty(1)) {
        fprintf(stderr, "standard input is not a tty\n");
        return 1;
    }

    /// option ///
    bool read_etc = false;
    bool screen_mode = false;
    bool xterm_mode = false;
    int pid = 0;
    
    char init_path[512];
    strcpy(init_path, "");
    
    int opt;
    while((opt = getopt(argc, argv, "r:d:tsx")) != -1) {
        switch(opt) {
        case 'r':
            pid = atoi(optarg);
            break;

        case 'd':
            if(optarg[0] == '/') {
                strcpy(init_path, optarg);
            }
            else {
                char* cwd = mygetcwd();

                strcpy(init_path, cwd);
                strcat(init_path, "/");
                strcat(init_path, optarg);
            }
            break;
            
        case 't':
            read_etc = true;
            break;

        case 's':
            screen_mode = true;
            break;

        case 'x':
            xterm_mode = true;
            break;

        case ':':
            printf("option needs a value\n");
            exit(1);
            break;

        case '?':
            printf("usage mfiler [tsh] [-r pid] \n\n");
            printf("-t : read /etc/mfiler instead of $HOME/.mfiler\n");
            printf("-s : run with GNU screen mode\n");
            printf("-x : run with X terminal mode\n");
            printf("\n");
            printf("-r pid : send a command to a running mfiler which has the pid. the command is to reread disk and refresh screen\n");
            printf("-d directory : set the direcotry as initial current working directory\n");
            exit(1);
            break;
        }
    }

    /// send socket message ///
    if(pid != 0) {
        char soc_name[256];
        sprintf(soc_name, "/tmp/mfiler%d", pid);

        if(access(soc_name, F_OK) != 0) {
            fprintf(stderr, "illegal pid.");
            return 1;
        }

        int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
        if(soc < 0) {
            perror("socket");
            return 1;
        }

        struct sockaddr_un addr;
        addr.sun_family = AF_UNIX;
        strcpy(addr.sun_path, soc_name);
        if(connect(soc, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
            perror("bind");
            return 1;
        }

        write(soc, "refresh", 8);
        close(soc);
    
        return 0;
    }

    /// init global var ///
    strcpy(gTrashBoxName, "mtrashbox");
    
    for(int i=0; i<2; i++) {
        for(int j=0; j<KEY_MAX; j++) {
            gKeyCommand[i][j] = hash_new(10);
         }
    }

    /// signal ///
    signal(SIGINT, sig_exit);
    signal(SIGQUIT, sig_exit);
    signal(SIGABRT, sig_exit);
    signal(SIGKILL, sig_exit);
    signal(SIGPIPE, sig_exit);
    signal(SIGALRM, sig_exit);
    signal(SIGTERM, sig_exit);
    signal(SIGHUP, sig_exit);
    signal(SIGTSTP, SIG_IGN);
    signal(SIGTTOU, SIG_DFL);
    signal(SIGCONT, SIG_DFL);
    signal(SIGWINCH, sig_winch);

//    signal(SIGCHLD, SIG_IGN);
//    signal(SIGCHLD, sig_child);
    
    /// init ruby interpreter ///
M(("init ruby itepreter"));
    
    ruby_init();
    
    rb_define_global_const("KEY_UP", INT2NUM(KEY_UP));
    rb_define_global_const("KEY_RIGHT", INT2NUM(KEY_RIGHT));
    rb_define_global_const("KEY_DOWN", INT2NUM(KEY_DOWN));
    rb_define_global_const("KEY_LEFT", INT2NUM(KEY_LEFT));
    rb_define_global_const("KEY_INSERT", INT2NUM(KEY_IC));
    rb_define_global_const("KEY_DELETE", INT2NUM(KEY_DC));
    rb_define_global_const("KEY_HOME", INT2NUM(KEY_HOME));
    rb_define_global_const("KEY_END", INT2NUM(KEY_END));
    rb_define_global_const("KEY_PAGEUP", INT2NUM(KEY_PPAGE));
    rb_define_global_const("KEY_PAGEDOWN", INT2NUM(KEY_NPAGE));
    
    rb_define_global_const("KEY_ENTER", INT2NUM(10));
    rb_define_global_const("KEY_BACKSPACE", INT2NUM(KEY_BACKSPACE));
    rb_define_global_const("KEY_SPACE", INT2NUM(32));
    
    rb_define_global_const("KEY_F1", INT2NUM(KEY_F(1)));
    rb_define_global_const("KEY_F2", INT2NUM(KEY_F(2)));
    rb_define_global_const("KEY_F3", INT2NUM(KEY_F(3)));
    rb_define_global_const("KEY_F4", INT2NUM(KEY_F(4)));
    rb_define_global_const("KEY_F5", INT2NUM(KEY_F(5)));
    rb_define_global_const("KEY_F6", INT2NUM(KEY_F(6)));
    rb_define_global_const("KEY_F7", INT2NUM(KEY_F(7)));
    rb_define_global_const("KEY_F8", INT2NUM(KEY_F(8)));
    rb_define_global_const("KEY_F9", INT2NUM(KEY_F(9)));
    rb_define_global_const("KEY_F10", INT2NUM(KEY_F(10)));
    rb_define_global_const("KEY_F11", INT2NUM(KEY_F(11)));
    rb_define_global_const("KEY_F12", INT2NUM(KEY_F(12)));
    
    rb_define_global_const("KEY_a", INT2NUM('a'));
    rb_define_global_const("KEY_b", INT2NUM('b'));
    rb_define_global_const("KEY_c", INT2NUM('c'));
    rb_define_global_const("KEY_d", INT2NUM('d'));
    rb_define_global_const("KEY_e", INT2NUM('e'));
    rb_define_global_const("KEY_f", INT2NUM('f'));
    rb_define_global_const("KEY_g", INT2NUM('g'));
    rb_define_global_const("KEY_h", INT2NUM('h'));
    rb_define_global_const("KEY_i", INT2NUM('i'));
    rb_define_global_const("KEY_j", INT2NUM('j'));
    rb_define_global_const("KEY_k", INT2NUM('k'));
    rb_define_global_const("KEY_l", INT2NUM('l'));
    rb_define_global_const("KEY_m", INT2NUM('m'));
    rb_define_global_const("KEY_n", INT2NUM('n'));
    rb_define_global_const("KEY_o", INT2NUM('o'));
    rb_define_global_const("KEY_p", INT2NUM('p'));
    rb_define_global_const("KEY_q", INT2NUM('q'));
    rb_define_global_const("KEY_r", INT2NUM('r'));
    rb_define_global_const("KEY_s", INT2NUM('s'));
    rb_define_global_const("KEY_t", INT2NUM('t'));
    rb_define_global_const("KEY_u", INT2NUM('u'));
    rb_define_global_const("KEY_v", INT2NUM('v'));
    rb_define_global_const("KEY_w", INT2NUM('w'));
    rb_define_global_const("KEY_x", INT2NUM('x'));
    rb_define_global_const("KEY_y", INT2NUM('y'));
    rb_define_global_const("KEY_z", INT2NUM('z'));
    
    rb_define_global_const("KEY_CTRL_SPACE", INT2NUM(0));
    rb_define_global_const("KEY_CTRL_A", INT2NUM(1));
    rb_define_global_const("KEY_CTRL_B", INT2NUM(2));
    rb_define_global_const("KEY_CTRL_C", INT2NUM(3));
    rb_define_global_const("KEY_CTRL_D", INT2NUM(4));
    rb_define_global_const("KEY_CTRL_E", INT2NUM(5));
    rb_define_global_const("KEY_CTRL_F", INT2NUM(6));
    rb_define_global_const("KEY_CTRL_G", INT2NUM(7));
    rb_define_global_const("KEY_CTRL_H", INT2NUM(8));
    rb_define_global_const("KEY_CTRL_I", INT2NUM(9));
    rb_define_global_const("KEY_CTRL_J", INT2NUM(10));
    rb_define_global_const("KEY_CTRL_K", INT2NUM(11));
    rb_define_global_const("KEY_CTRL_L", INT2NUM(12));
    rb_define_global_const("KEY_CTRL_M", INT2NUM(13));
    rb_define_global_const("KEY_CTRL_N", INT2NUM(14));
    rb_define_global_const("KEY_CTRL_O", INT2NUM(15));
    rb_define_global_const("KEY_CTRL_P", INT2NUM(16));
    rb_define_global_const("KEY_CTRL_Q", INT2NUM(17));
    rb_define_global_const("KEY_CTRL_R", INT2NUM(18));
    rb_define_global_const("KEY_CTRL_S", INT2NUM(19));
    rb_define_global_const("KEY_CTRL_T", INT2NUM(20));
    rb_define_global_const("KEY_CTRL_U", INT2NUM(21));
    rb_define_global_const("KEY_CTRL_V", INT2NUM(22));
    rb_define_global_const("KEY_CTRL_W", INT2NUM(23));
    rb_define_global_const("KEY_CTRL_X", INT2NUM(24));
    rb_define_global_const("KEY_CTRL_Y", INT2NUM(25));
    rb_define_global_const("KEY_CTRL_Z", INT2NUM(26));
    rb_define_global_const("KEY_ESCAPE", INT2NUM(27));
    
    rb_define_global_const("KEY_A", INT2NUM('A'));
    rb_define_global_const("KEY_B", INT2NUM('B'));
    rb_define_global_const("KEY_C", INT2NUM('C'));
    rb_define_global_const("KEY_D", INT2NUM('D'));
    rb_define_global_const("KEY_E", INT2NUM('E'));
    rb_define_global_const("KEY_F", INT2NUM('F'));
    rb_define_global_const("KEY_G", INT2NUM('G'));
    rb_define_global_const("KEY_H", INT2NUM('H'));
    rb_define_global_const("KEY_I", INT2NUM('I'));
    rb_define_global_const("KEY_J", INT2NUM('J'));
    rb_define_global_const("KEY_K", INT2NUM('K'));
    rb_define_global_const("KEY_L", INT2NUM('L'));
    rb_define_global_const("KEY_M", INT2NUM('M'));
    rb_define_global_const("KEY_N", INT2NUM('N'));
    rb_define_global_const("KEY_O", INT2NUM('O'));
    rb_define_global_const("KEY_P", INT2NUM('P'));
    rb_define_global_const("KEY_Q", INT2NUM('Q'));
    rb_define_global_const("KEY_R", INT2NUM('R'));
    rb_define_global_const("KEY_S", INT2NUM('S'));
    rb_define_global_const("KEY_T", INT2NUM('T'));
    rb_define_global_const("KEY_U", INT2NUM('U'));
    rb_define_global_const("KEY_V", INT2NUM('V'));
    rb_define_global_const("KEY_W", INT2NUM('W'));
    rb_define_global_const("KEY_X", INT2NUM('X'));
    rb_define_global_const("KEY_Y", INT2NUM('Y'));
    rb_define_global_const("KEY_Z", INT2NUM('Z'));

    rb_define_global_const("KEY_0", INT2NUM('0'));
    rb_define_global_const("KEY_1", INT2NUM('1'));
    rb_define_global_const("KEY_2", INT2NUM('2'));
    rb_define_global_const("KEY_3", INT2NUM('3'));
    rb_define_global_const("KEY_4", INT2NUM('4'));
    rb_define_global_const("KEY_5", INT2NUM('5'));
    rb_define_global_const("KEY_6", INT2NUM('6'));
    rb_define_global_const("KEY_7", INT2NUM('7'));
    rb_define_global_const("KEY_8", INT2NUM('8'));
    rb_define_global_const("KEY_9", INT2NUM('9'));
        
    rb_define_global_const("KEY_EXCLAM", INT2NUM('!'));
    rb_define_global_const("KEY_DQUOTE", INT2NUM('"'));
    rb_define_global_const("KEY_SHARP", INT2NUM('#'));
    rb_define_global_const("KEY_DOLLAR", INT2NUM('$'));
    rb_define_global_const("KEY_PERCENT", INT2NUM('%'));
    rb_define_global_const("KEY_AND", INT2NUM('&'));
    rb_define_global_const("KEY_SQUOTE", INT2NUM('\''));
    rb_define_global_const("KEY_LPAREN", INT2NUM('('));
    rb_define_global_const("KEY_RPAREN", INT2NUM(')'));
    rb_define_global_const("KEY_TILDA", INT2NUM('~'));
    rb_define_global_const("KEY_EQUAL", INT2NUM('='));
    rb_define_global_const("KEY_MINUS", INT2NUM('-'));
    rb_define_global_const("KEY_CUP", INT2NUM('^'));
    rb_define_global_const("KEY_VBAR", INT2NUM('|'));
    rb_define_global_const("KEY_BACKSLASH", INT2NUM('\\'));
    rb_define_global_const("KEY_ATMARK", INT2NUM('@'));
    rb_define_global_const("KEY_BAPOSTROPHE", INT2NUM('`'));
    rb_define_global_const("KEY_LCURLY", INT2NUM('{'));
    rb_define_global_const("KEY_LBRACK", INT2NUM('['));
    rb_define_global_const("KEY_PLUS", INT2NUM('+'));
    rb_define_global_const("KEY_SEMICOLON", INT2NUM(';'));
    rb_define_global_const("KEY_STAR", INT2NUM('*'));
    rb_define_global_const("KEY_COLON", INT2NUM(':'));
    rb_define_global_const("KEY_RCURLY", INT2NUM('}'));
    rb_define_global_const("KEY_RBRACK", INT2NUM(']'));
    rb_define_global_const("KEY_LSS", INT2NUM('<'));
    rb_define_global_const("KEY_COMMA", INT2NUM(','));
    rb_define_global_const("KEY_GTR", INT2NUM('>'));
    rb_define_global_const("KEY_DOT", INT2NUM('.'));
    rb_define_global_const("KEY_SLASH", INT2NUM('/'));
    rb_define_global_const("KEY_QMARK", INT2NUM('?'));
    rb_define_global_const("KEY_UNDERBAR", INT2NUM('_'));
    
    rb_define_global_const("NOMETA", INT2NUM(0));
    rb_define_global_const("META", INT2NUM(1));

    rb_define_global_const("WHITE", INT2NUM(kCAWhite));
    rb_define_global_const("BLUE", INT2NUM(kCABlue));
    rb_define_global_const("CYAN", INT2NUM(kCACyan));
    rb_define_global_const("GREEN", INT2NUM(kCAGreen));
    rb_define_global_const("YELLOW", INT2NUM(kCAYellow));
    rb_define_global_const("MAGENTA", INT2NUM(kCAMagenta));
    rb_define_global_const("RED", INT2NUM(kCARed));
        
    /// init global var ///
M(("init global var"));
    if(strcmp(init_path, "") == 0) {  
        char* cwd = mygetcwd();

        char tmp[PATH_MAX];
        strcpy(tmp, cwd);
        if(strcmp(tmp, "/") != 0) strcat(tmp,"/");
        
        gLDir = new cDirWnd(tmp, true);
        gRDir = new cDirWnd(tmp, false);

        FREE(cwd);
    }
    else {
        struct stat _stat;
        if(stat(init_path, &_stat) < 0) {
            fprintf(stderr, "%s don't exist\n", init_path);
            exit(1);
        }
        if(!S_ISDIR(_stat.st_mode)) {
            fprintf(stderr, "%s is not directory\n", init_path);
            exit(1);
        }
    
        gLDir = new cDirWnd(init_path, true);
        gRDir = new cDirWnd(init_path, false);
    }

//    hash_put(gKeyCommand[0]['q'], "*", STRDUP("mf_exit();"));

    gInputFileName = string_new("");
    
    /// init modules ///
M(("init modules"));
    
    command_init();
    cmdline_init();
    cMenu::Init();
    cDirWnd::Init();

    /// init socket ///
M(("init socket"));
    char soc_name[256];
    sprintf(soc_name, "/tmp/mfiler%d", getpid());

    if(access(soc_name, F_OK) == 0) {
        unlink(soc_name);
    }
    
    int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
    if(soc < 0) {
        perror("socket");
        return 1;
    }
    
    struct sockaddr_un addr;
    addr.sun_family = AF_UNIX;
    strcpy(addr.sun_path, soc_name);
    if(bind(soc, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        perror("bind");
        return 1;
    }
    
    /// read rc file ///
M(("read rc file"));
    
    read_rc_file(read_etc);
    
    cmdline_init_after_rc_file();

    if(screen_mode) {
        gGnuScreen = true;
    }
    if(xterm_mode) {
        gXterm = true;
    }

    /// sig child ///
    char* term = getenv("TERM");
    if(term == NULL) {
        fprintf(stderr, "$TERM is null");
        exit(1);
    }
    
    if(!(strstr(term, "screen") == term || gGnuScreen)) {
        signal(SIGCHLD, sig_child);
    }
    
    /// start curses ///
    minitscr();

    mclear_immediately();
    mclear();
    mrefresh();

    /// atexit ///
    atexit(atexit_fun);
    
    /// main loop ///
M(("main loop start"));

    gMainLoop = true;

    fd_set mask;
    fd_set read_ok;

    FD_ZERO(&mask);
    FD_SET(0, &mask);
    FD_SET(soc, &mask);

    while(gMainLoop) {
M(("Main Loop"));    
        /// view ///
        view();

        /// get event ///
M(("select"));

        read_ok = mask;

        if(!mkbuf_exist())
            select(soc + 1, &read_ok, NULL, NULL, NULL);
/*        
        struct timeval tv;
        tv.tv_sec = 0;
        tv.tv_usec = 0;
        select(soc + 1, &read_ok, NULL, NULL, &tv);
*/
M(("select end"));
M(("socket %d %d", soc, FD_SETSIZE));        

        /// key event ///
        if(FD_ISSET(0, &read_ok) || mkbuf_exist()) {
M(("key event"));
            int meta;
            int key = mgetch(&meta);
M(("key %d(%d)", key,meta));
           
            /// esc ///
            if(key == -1) {
            }
//            else if(key == KEY_RESIZE) {
//            }
            else if(meta) {
M(("meta - key %d", key));
                
                input(1, key);
            }
            
            /// meta key || kanji ///
            else if(key >= kKeyMetaFirst && key <= kKeyMetaFirst+127) {
                if(gCmdLineActive) {    // for Kanji input
                    input(0, key);
                }
                else {
                    input(1, key - kKeyMetaFirst);
                }
            }

            /// normal key ///
            else {
               input(0, key);
            }
        }

        /// socket event ///
        else if(FD_ISSET(soc, &read_ok)) {
M(("socket event"));

            char buf[256];
            
            struct sockaddr_un caddr;
            socklen_t caddr_len;
            int len = recvfrom(soc, buf, 256, 0, (struct sockaddr *)&caddr, &caddr_len);
M(("buf (%s)", buf));
            rb_eval_string("reread");
            //rb_eval_string(buf);
            
            sleep(1);
        }
M(("Main Loop end"));        
    }

    /// finish curses ///
M(("finish curses"));
    mclear_immediately();
    mclear();
    mrefresh();
    mendwin();
    
    /// finalize modules ///
M(("finalize modules"));
    cmdline_final();
    command_final();
    cMenu::Final();
    cDirWnd::Final();
    
    /// release global var ///    
M(("release global var"));
    string_delete(gInputFileName);
    unlink(soc_name);

    delete gLDir;
    delete gRDir;

    for(int i=0; i<2; i++) {
        for(int j=0; j<KEY_MAX; j++) {
            for(hash_it* it = gKeyCommand[i][j]->mEntryIt;
                it;
                it = it->mNextIt)
            {
                FREE(it->mItem);
            }
            hash_delete(gKeyCommand[i][j]);
         }
    }
    
CHECKML_END();
LOG_END();

    return 0;
}

static void read_rc_file(bool read_etc)
{
    char* home = getenv("HOME");
    if(home == NULL) {
        fprintf(stderr, "$HOME is NULL");
        exit(1);
    }

    char rc_fname[256];
    sprintf(rc_fname, "%s/.mfiler", home);
    
    /* if not exist ~/.mfiler,read from /etc/mfiler */
    FILE *rctest=NULL;
    if(!(rctest=fopen(rc_fname,"r"))){
        sprintf(rc_fname,"/etc/mfiler");
    }
    else {
        fclose(rctest);
    }

    if(read_etc) {
        sprintf(rc_fname, "/etc/mfiler");
    }
    
    if(access(rc_fname, F_OK) == 0) {
        /// get file size ///
        struct stat sbuf;
        stat(rc_fname, &sbuf);
        const int size = sbuf.st_size;

        /// read to buffer ///
        char* buf = (char*)MALLOC(size + 1);
        
        FILE* rcfile = fopen(rc_fname, "r");
        fread(buf, sizeof(char), size, rcfile);
        buf[size] = 0;
        fclose(rcfile);

        /// eval ///
        rb_eval_string(buf);
        
        FREE(buf);
    }
    else {
        fprintf(stderr, "can't find $HOME/.mfiler and /etc/mfiler file. pleas copy it to home directory\n");
        exit(1);
    }
}

static bool match()
{
    bool same = true;
    if(string_length(gInputFileName) > 1) {
        for(int i=1; i<string_length(gInputFileName); i++)
            if(string_c_str(gInputFileName)[i]
                != string_c_str(gInputFileName)[i-1])
            {
                same = false;
            }
    }

    if(same) {
        int mfiles[2096];
        int n = 0;
        
        for(int i=0; i<vector_size(ActiveDir()->Files()); i++) {
            sFile* file = (sFile*)vector_item(ActiveDir()->Files(), i);
            if(tolower(file->mName[0])
                == tolower(string_c_str(gInputFileName)[0]))
            {
                mfiles[n++] = i;
            }
        }

        if(n > 0) {
            ActiveDir()->MoveCursorIndex(
                            mfiles[(string_length(gInputFileName)-1) % n]);
            return true;
        }
    }
    else {
        for(int i=0; i<vector_size(ActiveDir()->Files()); i++) {
            sFile* file = (sFile*)vector_item(ActiveDir()->Files(), i);

/*            
            if(strstr(file.mName, (char*)gInputFileName.c_str()) == file.mName) {
                ActiveDir()->MoveCursorIndex(i);

                return true;
            }
*/            

            bool equal = true;
            const int len = string_length(gInputFileName);
            for(int j=0; j<len; j++) {
                if(tolower(string_c_str(gInputFileName)[j])
                    != tolower(file->mName[j]))
                {
                    equal = false;
                }
            }

            if(equal) {
                ActiveDir()->MoveCursorIndex(i);
                
                return true;
            }
        }
    }

    return false;
}

static void input(int meta, int key)
{
TBEGIN();

    if(gViewHelp) {
        help_input(meta, key);
    }
    else if(gCmdLineActive) {
        cmdline_input(meta, key);
    }
    else if(gActiveMenu) {
        gActiveMenu->Input(meta, key);
    }
    else {
M(("main input"));    
        sFile* cursor = ActiveDir()->CursorFile();
        const char* name = cursor->mName;

        char extension[256];
        char* tmp = extname(cursor->mName);
        sprintf(extension, ".%s", tmp);
        FREE(tmp);
    
        char* command;

        if(gShiftISearch && meta == 0 && (key >= 'A' && key <= 'Z'))
        {
            string_push_back(gInputFileName, key);

            if(!match()) {
                string_put(gInputFileName, "");
                string_push_back(gInputFileName, (char)key);

                if(!match()) {
                    string_put(gInputFileName, "");
                }
            }
        }
        else if(gISearchEnterDecision && gISearch && (key == 10 ||key==13)) {
            gISearch = false;
            string_put(gInputFileName, "");
        }
        else if(gISearch && meta == 0
            && ((key == '.' || key == '-' || key == '_' || key == '+')
            || (key >= '0' && key <= '9')
            || (key >= 'A' && key <= 'Z')
            || (key >= 'a' && key <= 'z'))
            )
        {
M(("key incremental search"));
            string_push_back(gInputFileName, (char)key);

            if(!match()) {
                string_put(gInputFileName, "");
                string_push_back(gInputFileName, (char)key);

                if(!match()) {
                    string_put(gInputFileName, "");
                }
            }
        }
        else if(ActiveDir()->Marking()
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".mark"))
        {
M(("key mark eval"));
            rb_eval_string((char*)hash_item(gKeyCommand[meta][key],".mark"));
            
            string_put(gInputFileName, "");
        }
        else if(S_ISDIR(cursor->mStat.st_mode)
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".dir"))
        {
M(("key dir eval"));
            rb_eval_string((char*)hash_item(gKeyCommand[meta][key], ".dir"));
            
            string_put(gInputFileName, "");
        }
        else if(key >= 0 && key < KEY_MAX  
              && hash_item(gKeyCommand[meta][key], (char*)name))
        {
M(("key name eval"));
           rb_eval_string(
               (char*)hash_item(gKeyCommand[meta][key], (char*)name));

            string_put(gInputFileName, "");
        }
        else if(key >= 0 && key < KEY_MAX 
               && hash_item(gKeyCommand[meta][key], extension))
        {
M(("key extension eval"));
            rb_eval_string(
                (char*)hash_item(gKeyCommand[meta][key], extension));

            string_put(gInputFileName, "");
        }
        else if((cursor->mStat.st_mode&S_IXUSR
             || cursor->mStat.st_mode&S_IXGRP || cursor->mStat.st_mode&S_IXOTH)
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".execute"))
        {
M(("key exe eval"));
            rb_eval_string((char*)hash_item(gKeyCommand[meta][key],".execute"));
            
            string_put(gInputFileName, "");
        }
        else if(key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], "*")) 
        {
M(("key file * eval"));
            rb_eval_string((char*)hash_item(gKeyCommand[meta][key], "*"));
            
            string_put(gInputFileName, "");
        }
        else {
            string_put(gInputFileName, "");
        }
    }

TEND();    
}

void view()
{
TBEGIN();

    if(gViewHelp) {
        help_view();
    }
    else if(gActiveMenu)
        gActiveMenu->View();
    else {
        const int maxx = mgetmaxx();
        const int maxy = mgetmaxy();
        
        mclear();
        
        if(vector_size(gCCandidate)) {
            cmdline_completion_view();
        }
        else {
            gLDir->View();
            gRDir->View();
        }

        /// draw ptty ///
M(("draw ptty"));        
        for(int i=0;
            i<(vector_size(gTty) > 5 ? 5: vector_size(gTty));
            i++)
        {
            const int max_width = maxx / 5;

            char buf[1024];
            sMasterTty* tty = (sMasterTty*)vector_item(gTty, i);
            sprintf(buf, "<%d>%s", i+1, tty->mName);
            
            bool kanji = false;
            int j;
            for(j=0; j<max_width; j++) {
                if(kanji)
                    kanji = false;
                else if(is_kanji(buf[j]))
                    kanji = true;
            }
            if(kanji)
                buf[j-1] = 0;
            else 
                buf[j] = 0;

            mmvprintw(maxy-3, max_width*i, buf);
        }
        
        /// draw cursor file stat ///
M(("draw cursor file stat"));        
        if(gCmdLineActive)
            cmdline_view();
        else {
            char title[256];

            sprintf(title, "the Minnu's Filer2 1.75d ");
            
            if((gXterm && !gXtermNext) || (!gXterm && gXtermNext)) 
                strcat(title, "x");
            if(gISearch) strcat(title, "/");

            mmvprintw(maxy -2, 0, title);
            
            char buf[1024];
            char* str = string_c_str(gInputFileName);
            const int len = strlen(str);
            int i;
            for(i=0; i<maxx-35; i++) {
                if(i<len) {
                    buf[i] = str[i];
                }
                else {
                    buf[i] = ' ';
                }
            }
            buf[i] = 0;
            mprintw(buf);
            //mmvprintw(maxy-2, 34, buf);

            char hname[256];
            gethostname(hname, 256);

            struct passwd* uname = getpwuid(getuid());

            char uhname[256];
            sprintf(uhname, " %s@%s", uname->pw_name, hname);
            mmvprintw(maxy-2, maxx-strlen(uhname)-1, "%s", uhname);
    
            sFile* file = ActiveDir()->CursorFile();
        
            char permission[12];
            strcpy(permission, "----------");
            if(S_ISDIR(file->mStat.st_mode)) permission[0] = 'd';
            if(S_ISLNK(file->mStat.st_mode)) permission[0] = 'l';
            
            mode_t smode = file->mStat.st_mode;
            if(smode & S_IRUSR) permission[1] = 'r';
            if(smode & S_IWUSR) permission[2] = 'w';
            if(smode & S_IXUSR) permission[3] = 'x';
            if(smode & S_IRGRP) permission[4] = 'r';
            if(smode & S_IWGRP) permission[5] = 'w';
            if(smode & S_IXGRP) permission[6] = 'x';
            if(smode & S_IROTH) permission[7] = 'r';
            if(smode & S_IWOTH) permission[8] = 'w';
            if(smode & S_IXOTH) permission[9] = 'x';
            if(smode & S_ISUID) permission[3] = 's';
            if(smode & S_ISGID) permission[6] = 's';
#if defined(S_ISTXT)
            if(smode & S_ISTXT) permission[9] = 't';
#endif
#if defined(S_ISVTX)
            if(smode & S_ISVTX) permission[9] = 't';
#endif
            
            permission[10] = 0;
        
            time_t t = file->mStat.st_mtime;
            struct tm* tm_ = (struct tm*)localtime(&t);
             
            char buf2[1024];

            char owner[256];
            char* tmp = mygetpwuid(&file->mStat);
            if(tmp)
                cut(tmp, owner, 8);
            else
                sprintf(owner, "%d", file->mStat.st_uid);

            char group[256];
            tmp = mygetgrgid(&file->mStat);
            if(tmp)
                cut(tmp, group, 7);
            else
                sprintf(group, "%d", file->mStat.st_gid);

            if(!S_ISLNK(file->mLStat.st_mode)) {
                int year = tm_->tm_year-100;
                if(year < 0) year+=100;
                while(year > 100) year-=100;
                
                sprintf(buf2
                    , "%s %3d %-8s %-7s%10lld %02d-%02d-%02d %02d:%02d %s"
                    , permission, file->mStat.st_nlink
                    , owner, group
                                        
                    , file->mStat.st_size
                    
                    , year, tm_->tm_mon+1, tm_->tm_mday
                    , tm_->tm_hour, tm_->tm_min
                    , file->mName);
                    
                char buf3[1024];
                cut(buf2, buf3, maxx-1);
                                    
                mmvprintw(maxy-1, 0, buf3);
            }
            else {
                char link[PATH_MAX + 1];
                char path[PATH_MAX];
                strcpy(path, ActiveDir()->Path());
                strcat(path, file->mName);                 
                 
                int bytes = readlink(path, link, PATH_MAX);
                link[bytes] = 0;
                 
                sprintf(buf
                   , "%s %3d %s%s%10lld %02d-%02d-%02d %02d:%02d %s -> %s"
                   , permission, file->mStat.st_nlink
                   , owner, group
                                        
                   , file->mStat.st_size

                   , tm_->tm_year-100, tm_->tm_mon+1, tm_->tm_mday
                   , tm_->tm_hour, tm_->tm_min
                   , file->mName
                   , link);
                   
                char buf2[1024];
                cut(buf, buf2, maxx-1);
                           
                mmvprintw(maxy-1, 0, buf2);
            }

            mmove_immediately(maxy-1, maxx-1);
        }
    
        mrefresh();
    }

TEND();    
}

void cut(char* src, char* dest, int len)
{
    int n;
    bool tmpend = false;
    bool kanji = false;
    for(n=0; n<len; n++) {
        if(kanji)
            kanji = false;
        else if(is_kanji(src[n])) {
            kanji = true;
        }

        if(src[n] == 0) tmpend = true;
                    
        if(tmpend)
            dest[n] = ' ';
        else
            dest[n] = src[n];
    }
    
    if(kanji) dest[n-1] = ' ';
    dest[n] = 0;
}

bool gErrMsgCancel = false;

void err_msg(char* msg, ...)
{
    char buf[BUFSIZ];

    va_list args;
    va_start(args, msg);
    vsprintf(buf, msg, args);
    va_end(args);

    const int maxy = getmaxy(stdscr);
    
    mclear_online(maxy-2, false);
    mclear_online(maxy-1, true);
    mmvprintw(maxy-2, 0, buf);
    mrefresh();

    int meta;
    int key;
    if(!gErrMsgCancel) {
        key = mgetch(&meta);
    }
    
    if(key == 3 || key == 7 || key == 27) {
        gErrMsgCancel = true;
    }
}

void msg(char* msg)
{
    const int maxy = mgetmaxy();

    mclear_online(maxy-2, false);
    mclear_online(maxy-1, true);
    mmvprintw(maxy-2, 0, msg);
    mrefresh();
}

int select_str(char* msg, char* str[], int len, int cancel)
{
    int cursor = 0;

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    while(1) {
        /// viwe ///
        mclear_online(maxy-2, false);
        mclear_online(maxy-1, true);

        mmove(maxy-2, 0);
        mprintw(msg);
        
//        mmove(maxy-1, 0);
        mprintw(" ");
        for(int i=0; i< len; i++) {
            if(cursor == i) {
                mattron(kCAReverse);
                mprintw("%s", str[i]);
                mattroff();
                mprintw(" ");
            }
            else {
                mprintw("%s ", str[i]);
            }
        }

        mmove_immediately(maxy-1, maxx-1);
        mrefresh();

        /// input ///
        int meta;
        int key = mgetch(&meta);
        if(key == 10 || key == 13) {
            break;
        }
        else if(key == 6 || key == KEY_RIGHT) {
            cursor++;

            if(cursor >= len) cursor = len-1;
        }
        else if(key == 2 || key == KEY_LEFT) {
            cursor--;

            if(cursor < 0) cursor = 0;
        }
        else if(key == 3 || key == 7 || key == 27) {    // CTRL-C -G Escape
            cursor = cancel;
            break;
        }
    }

    return cursor;
}
