#ifndef MCURSES_H
#define MCURSES_H

#include <curses.h>
#include <stdarg.h>

#define kKeyMapMax 22

const int kKeyMapUp = 0;
const int kKeyMapDown = 1;
const int kKeyMapRight = 2;
const int kKeyMapLeft = 3;
const int kKeyMapInsert = 4;
const int kKeyMapDelete = 5;
const int kKeyMapHome = 6;
const int kKeyMapEnd = 7;
const int kKeyMapPageUp = 8;
const int kKeyMapPageDown = 9;
const int kKeyMapF1 = 10;
const int kKeyMapF2 = 11;
const int kKeyMapF3 = 12;
const int kKeyMapF4 = 13;
const int kKeyMapF5 = 14;
const int kKeyMapF6 = 15;
const int kKeyMapF7 = 16;
const int kKeyMapF8 = 17;
const int kKeyMapF9 = 18;
const int kKeyMapF10 = 19;
const int kKeyMapF11 = 20;
const int kKeyMapF12 = 21;

extern char gKeyMap[kKeyMapMax][6];

void minitscr();
void mendwin();
void mmove(int y, int x);
void mmove_immediately(int y, int x);
int mmvprintw(int y, int x, char* str, ...);
int mprintw(char* str, ...);

const int kCAReverse = 0x1;
const int kCABold = 0x2;
const int kCAUnderline = 0x4;
const int kCABlack = 0x8;
const int kCARed = 0x10;
const int kCAGreen = 0x20;
const int kCAYellow = 0x40;
const int kCABlue = 0x80;
const int kCAMagenta = 0x100;
const int kCACyan = 0x200;
const int kCAWhite = 0x400;
const int kCABackBlack = 0x800;
const int kCABackRed = 0x1000;
const int kCABackGreen = 0x2000;
const int kCABackYellow = 0x4000;
const int kCABackBlue = 0x8000;
const int kCABackMagenta = 0x10000;
const int kCABackCyan = 0x20000;
const int kCABackWhite = 0x40000;

void mattron(int attrs);
void mattroff();

int mgetmaxx();
int mgetmaxy();
void mclear_immediately();
void mclear();
void mclear_online(int y, int lastline);

void mbox(int y, int x, int width, int height);

void mrefresh();
int mkbuf_exist();
int mgetch(int* meta);

extern struct termios gTtySave;

enum eKanjiCode { kEuc, kSjis, kUtf };
extern enum eKanjiCode gKanjiCode;

extern int is_kanji(unsigned char c);

#endif
