#ifndef MFILER3_COMMON_H
#define MFILER3_COMMON_H

#include "config.h"

#if defined(__CYGWIN__)
#define _LARGEFILE64_SOURCE       // サイズが大きいファイルを扱うために必要

#include <sys/stat.h>     // ↑のマクロを使ってコンパイルしないといけない
#define stat64 stat
#define __off64_t long long int
#define lstat64 lstat
#undef _LARGEFILE64_SOURCE
#elif defined(__DARWIN__)

#include <sys/stat.h>     // ↑のマクロを使ってコンパイルしないといけない
#define stat64 stat
#define __off64_t long long int
#define lstat64 lstat
#elif defined(__LINUX__)
#define _LARGEFILE64_SOURCE      // サイズが大きいファイルを扱うために必要

#include <sys/stat.h>     // ↑のマクロを使ってコンパイルしないといけない
#include <linux/stat.h>

#undef _LARGEFILE64_SOURCE

extern int lstat (__const char *__restrict __file,
    struct stat *__restrict __buf) __attribute__ ((__nothrow__)) __attribute__ ((__nonnull__ (1, 2)));

extern int lstat64 (__const char *__restrict __file,
      struct stat64 *__restrict __buf)
     __attribute__ ((__nothrow__)) __attribute__ ((__nonnull__ (1, 2)));
extern int mknod (__const char *__path, __mode_t __mode, __dev_t __dev)
     __THROW __nonnull ((1));
extern int symlink (__const char *__from, __const char *__to)
     __THROW __nonnull ((1, 2)) __wur;
extern int lchown (__const char *__file, __uid_t __owner, __gid_t __group)
     __THROW __nonnull ((1)) __wur;
#endif

// よくわからないが、これが宣言されない。gcc -Eでは定義されているのに謎。

#include <unistd.h>
extern ssize_t readlink (__const char *__restrict __path,
    char *__restrict __buf, size_t __len)
     __attribute__ ((__nothrow__)) __attribute__ ((__nonnull__ (1, 2))) ;

// これもそうだ。GNUのヘッダーって訳がわからない。

#ifndef	NSIG
# ifdef	_NSIG
# define	NSIG		_NSIG
# else
#  ifdef	DJGPP
#  define	NSIG		301
#  else
#  define	NSIG		64
#  endif
# endif
#endif

#ifdef __LINUX__

#include <linux/limits.h>
/*
#define __USE_POSIX
#define __USE_XOPEN_EXTENDED
#define __USE_POSIX199309
#define __USE_UNIX98
*/
#include <signal.h>
/*
#undef __USE_POSIX
#undef __USE_XOPEN_EXTENDED
#undef __USE_POSIX199309
#undef __USE_UNIX98
*/
#include <sys/wait.h>

#else

#include <signal.h>
#include <sys/stat.h>
#include <sys/wait.h>

#endif


#include <saphire_extra.h>             // 自作ライブラリ群
#include <saphire_curses.h>
#include <saphire_vector.h>
#include <saphire_string.h>
#include <saphire_list.h>
#include <saphire_hash.h>
#include <saphire_debug.h>

#include <saphire.h>                // 自作シェルスクリプトライブラリ

#include "filer.h"

#include <oniguruma.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#if defined(__LINUX__)
#include <linux/limits.h>
#endif
#include <limits.h>

#if defined(S_ISTXT)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISTXT)
#elif defined(S_ISVTX)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISVTX)
#else
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID)
#endif

#define S_IXUGO (S_IXOTH | S_IXGRP | S_IXUSR)

//////////////////////////////////////////////
// main.c
///////////////////////////////////////////////
extern char gHomeDir[PATH_MAX];     // ~/.mfiler3/のパス
extern char gTempDir[PATH_MAX];     // 一時ディレクトリのパス
extern BOOL gMainLoop;              // メインループを回すかどうか
extern BOOL gExitCode;              // 終了コード

extern void (*gView)();             // 登録描写関数(関数を登録しておけばviewで実行される)

volatile extern BOOL gSigInt;
volatile extern BOOL gSigUser;

void set_signal_mfiler();

void view(BOOL cmdline_draw);                        // 全体の描写関数

///////////////////////////////////////////////
// menu.c
///////////////////////////////////////////////
typedef struct {
    char* mName;
    int mKey;
    char* mCmd;
} sMenuItem;

typedef struct {
    char mTitle[256];

    int mScrollTop;
    int mCursor;

    vector_obj* mMenuItems; 
} sMenu;

extern hash_obj* gMenu;
extern sMenu* gActiveMenu;

sMenu* sMenu_new(char* title);
void menu_view(sMenu* self);
void menu_input(sMenu* self, int meta, int key);
void menu_append(sMenu* self, char* name, int key, char* cmd);
void menu_init();
void menu_final();
void menu_start(char* menu_name);

///////////////////////////////////////////////////
// isearch.c
///////////////////////////////////////////////////
#if defined(HAVE_MIGEMO_H)
#include "migemo.h"
extern migemo* gMigemo;
#endif

extern BOOL gISearch;        // インクリメンタルサーチ中かどうか

void isearch_init();         // インクリメンタルサーチ初期化
void isearch_final();        // インクリメンタルサーチ解放

void isearch_input(int meta, int key); // インクリメンタルサーチキー入力
void isearch_view();                  // インクリメンタルサーチ描写

extern BOOL gISearchExplore;           // エキスプローラー風インクリメンタルサーチ
BOOL IsISearchExploreChar(int meta, int key);
void isearch_explore_input(int meta, int key);
void isearch_explore_view();
BOOL IsISearchNULL();
void ISearchClear();

///////////////////////////////////////////////////
// cmdline
///////////////////////////////////////////////////
extern BOOL gCmdLineActive;
extern string_obj* gCmdLine;
extern int gCmdLineCursor;
#define kCmdLineMax 16000

void cmdline_init();
void cmdline_final();
void cmdline_input(int meta, int key);
void cmdline_view();
void cmdline_convert();

extern int gHistoryScrollTop;
extern int gHistoryCursor;

extern vector_obj* gHCandidate;

void cmdline_history_view();
void cmdline_history_input(int meta, int key);
void cmdline_hcandidate_refresh();
void cmdline_start(char* str, int cursor, BOOL quick, BOOL continue_);
void cmdline_write_history();
void cmdline_read_history();
void add_history(char* str);

///////////////////////////////////////////////////
// cmdline_completion.c
///////////////////////////////////////////////////
extern vector_obj* gCCandidate;
extern vector_obj* gPrograms;             // プログラム名補完候補
extern vector_obj* gEnvirons;             // 環境変数補完候補

void cmdline_completion_init();
void cmdline_completion_final();

void cmdline_completion_view();
void cmdline_completion_input(int meta, int key);

void cmdline_completion_main();

void cmdline_completion(vector_obj* all_candidate, char* editing, BOOL add_space);
void cmdline_completion2(vector_obj* all_candidate, char* editing, BOOL add_space, int candidate_len);

void cmdline_completion_file(char* editing_dir, char* editing_file, char* editing, int editing_position);
void cmdline_completion_program(char* editing_dir, char* editing_file, char* editing, int editing_position);

void cmdline_completion_clear();

///////////////////////////////////////////////////
// gui.c
///////////////////////////////////////////////////
char* choise(char* msg, char* str[], int len, int cancel);
void merr_msg(char* msg, ...);
void msg_nonstop(char* msg, ...);
int select_str(char* msg, char* str[], int len, int cancel);
int select_str2(char* msg, char* str[], int len, int cancel);
int input_box(char* msg, char* result, char* def_input, int def_cursor);

///////////////////////////////////////////////////
// commands.c
///////////////////////////////////////////////////
void commands_init();
void commands_final();

///////////////////////////////////////////////////
// file.c
///////////////////////////////////////////////////
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel, kSelectNewer };
extern enum eCopyOverride gCopyOverride;

enum eWriteProtected { kWPNone, kWPYesAll, kWPNoAll, kWPCancel };
extern enum eWriteProtected gWriteProtected;

BOOL file_copy(char* spath, char* dpath, BOOL move, BOOL preserve);
BOOL file_remove(char* path, BOOL no_ctrl_c, BOOL msg);

#endif

