#! /bin/sh

set -e

mhash_name="mhash-0.9.6"
mhash_file="$mhash_name.tar.bz2"

echo "Current pwd is [$(pwd)]"
cd $(dirname "$0")
echo "Current pwd is [$(pwd)]"

echo "Extracting $mhash_file..."
bunzip2 -c "$mhash_file" | tar xf -
mv "$mhash_name" mhash

echo "Applying patch..."
perl -p -i -e 's/AC_CONFIG_HEADER/AM_CONFIG_HEADER/g' mhash/configure.in

echo "Creating Makefile.am..."
cat << EOH > Makefile.am
SUBDIRS = mhash
EOH
