/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.sound.midi.MidiDevice;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.rz.midiplayer.AppConstants;
import org.rz.midiplayer.context.Device;
import org.rz.midiplayer.context.MidiEventHandler;
import org.rz.midiplayer.context.Player;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.midi.MIDIDeviceManager;
import org.rz.midiplayer.midi.MidiEventListener;
import org.rz.midiplayer.plugin.PluginManager;
import org.rz.midiplayer.plugin.renderer.RendererPlugin;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayer.xmlmodule.XSDConstants;
import org.rz.midiplayer.xmlmodule.appconfig.ApplicationConfig;
import org.rz.midiplayer.xmlmodule.midispec.Spec;
import org.xml.sax.SAXException;

public class Context
implements Loggable,
MidiEventListener {
    private ApplicationConfig config;
    private JAXBElement<ApplicationConfig> configElement;
    private Device device = new Device(AppConstants.DEVICE_DEF_DIR);
    private Player player;
    private final ArrayList<MidiEventHandler> midiEventHandlers = new ArrayList();
    private final Hashtable<String, Spec> midiSpecTable = new Hashtable();
    private final ArrayList<Spec> midiSpecArray = new ArrayList();
    private PluginManager<RendererPlugin> rendererPluginManager;

    public Context() throws JAXBException, SAXException, ClassNotFoundException, IOException {
        this.initialize();
    }

    private void initialize() throws JAXBException, SAXException, ClassNotFoundException, IOException {
        this.initializeAppConfig();
        this.initializeMidiSpec();
        this.loadDeviceFile();
        this.rendererPluginManager = new PluginManager<RendererPlugin>(RendererPlugin.class, AppConstants.PLUGIN_RENDERER_DIR);
        this.player = new Player();
        this.player.setMidiEventLister(this);
        this.setMidiOut(this.config.getMidiout().getName());
    }

    private void initializeAppConfig() {
        JAXBUtil<ApplicationConfig> appConfUtil = new JAXBUtil<ApplicationConfig>(ApplicationConfig.class);
        try {
            this.configElement = appConfUtil.loadFromFile(XSDConstants.APPCONFIG_XSD_URI, AppConstants.APP_CONFIG_FILE);
            this.config = (ApplicationConfig)this.configElement.getValue();
            logger.info("config file loaded.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to loading Application Config file.", e);
            logger.warning("try to using the Default Config : /org/rz/midiplayer/xmlmodule/ApplicationConfig.xml.default");
            try {
                this.configElement = appConfUtil.loadFromClasspath(XSDConstants.APPCONFIG_XSD_URI, "/org/rz/midiplayer/xmlmodule/ApplicationConfig.xml.default");
                this.config = (ApplicationConfig)this.configElement.getValue();
                logger.warning("OK. Using the Default Config : /org/rz/midiplayer/xmlmodule/ApplicationConfig.xml.default:" + this.config);
            }
            catch (Exception ee) {
                logger.log(Level.SEVERE, "FATAL ERROR", ee);
            }
        }
    }

    private void initializeMidiSpec() {
        JAXBUtil<Spec> midiSpecUtil = new JAXBUtil<Spec>(Spec.class);
        logger.info("Loding MIDI Specification files...");
        try {
            File dir = new File(AppConstants.MIDI_DEF_DIR);
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File p) {
                    return p.isFile() && p.getName().endsWith(".xml");
                }
            });
            this.midiSpecTable.clear();
            this.midiSpecArray.clear();
            for (File f : files) {
                logger.info(f.getName());
                Spec p = (Spec)midiSpecUtil.loadFromFile(XSDConstants.MIDISPEC_XSD_URI, f.getAbsoluteFile()).getValue();
                this.midiSpecTable.put(p.getName(), p);
                this.midiSpecArray.add(p);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to loading MIDI Specification file.", e);
        }
    }

    public synchronized void dispose() {
        logger.info("******************* DISPOSE CONTEXT - BEGIN *******************");
        logger.info("dispose player");
        this.player.dispose();
        logger.info("dispose midiEventListeners");
        this.midiEventHandlers.clear();
        logger.info("close all midi devices");
        MIDIDeviceManager.closeAllDevice();
        logger.info("******************* DISPOSE CONTEXT - END *******************");
    }

    public synchronized void loadDeviceFile() throws JAXBException, SAXException {
        this.loadDeviceFile(this.config.getDevicefile().getFile());
    }

    public synchronized void loadDeviceFile(String fileName) throws JAXBException, SAXException {
        this.device.load(fileName);
        this.config.getDevicefile().setFile(fileName);
        logger.info("loaded device file: " + fileName);
    }

    public synchronized void setMidiOut(String devName) {
        MidiDevice d = MIDIDeviceManager.searchMidiOutDevice(devName);
        if (d != null) {
            this.player.setMidiOutDevice(d);
            this.config.getMidiout().setName(devName);
            logger.info("set MIDI OUT: " + devName);
        } else {
            logger.warning(devName + " is invalid name.");
        }
    }

    public synchronized void play(String file) {
        this.play(new File(file));
    }

    public synchronized boolean play(File f) {
        MidiDevice midiOut = MIDIDeviceManager.searchMidiOutDevice(this.config.getMidiout().getName());
        MidiDevice midiIn = MIDIDeviceManager.searchMidiInDevice(this.config.getMidiin().getName());
        this.player.setMidiOutDevice(midiOut);
        this.player.setMidiInDevice(midiIn);
        boolean ret = this.player.play(f);
        this.config.getLastdirectory().setDir(f.getParent());
        return ret;
    }

    public synchronized boolean startRealTimeInput() {
        MidiDevice midiOut = MIDIDeviceManager.searchMidiOutDevice(this.config.getMidiout().getName());
        MidiDevice midiIn = MIDIDeviceManager.searchMidiInDevice(this.config.getMidiin().getName());
        this.player.setMidiOutDevice(midiOut);
        this.player.setMidiInDevice(midiIn);
        return this.player.startRealTimeInput();
    }

    public synchronized void stop() {
        this.player.stop();
    }

    public boolean isPlaying() {
        return this.player != null && this.player.isPlaying();
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public Device getDevice() {
        return this.device;
    }

    public synchronized Vector<File> getDeviceInfoList() {
        File[] files;
        Vector<File> ret = new Vector<File>(32);
        File dir = new File(AppConstants.DEVICE_DEF_DIR);
        for (File f : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) {
            ret.addElement(f);
        }
        return ret;
    }

    public Hashtable<String, Spec> getMidiSpecTable() {
        return this.midiSpecTable;
    }

    public ArrayList<Spec> getMidiSpecArray() {
        return this.midiSpecArray;
    }

    public int getCurrentTimeInSecond() {
        return this.player.getCurrentTimeInSecond();
    }

    public int getPlayTimeInSecond() {
        return this.player.getPlayTimeInSecond();
    }

    public int getBPM() {
        return this.player.getBPM();
    }

    public synchronized void saveAppConfig() {
        JAXBUtil<ApplicationConfig> appConfUtil = new JAXBUtil<ApplicationConfig>(ApplicationConfig.class);
        try {
            logger.info("Saving the config file : " + AppConstants.APP_CONFIG_FILE);
            appConfUtil.writeToFile(this.configElement, XSDConstants.APPCONFIG_XSD_URI, new File(AppConstants.APP_CONFIG_FILE));
            logger.info("Saving the config file successfully. ");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "ERROR", e);
        }
    }

    public PluginManager<RendererPlugin> getRendererPluginManager() {
        return this.rendererPluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMidiEventHandler(MidiEventHandler e) {
        ArrayList<MidiEventHandler> arrayList = this.midiEventHandlers;
        synchronized (arrayList) {
            if (e != null && !this.midiEventHandlers.contains(e)) {
                this.midiEventHandlers.add(e);
                logger.info("added MIDIEventListener : " + this.midiEventHandlers.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMidiEventHandler(MidiEventHandler e) {
        ArrayList<MidiEventHandler> arrayList = this.midiEventHandlers;
        synchronized (arrayList) {
            if (e != null && this.midiEventHandlers.contains(e)) {
                this.midiEventHandlers.remove(e);
                logger.info("removed MIDIEventListener : " + this.midiEventHandlers.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMidiEvent(int ch, int status, byte[] data, int length) {
        boolean ret = false;
        ArrayList<MidiEventHandler> arrayList = this.midiEventHandlers;
        synchronized (arrayList) {
            for (MidiEventHandler e : this.midiEventHandlers) {
                boolean b = e.handleMidiEvent(ch, status, data, length);
                if (!b || ret) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleSysExEvent(byte[] data, int length) {
        boolean ret = false;
        ArrayList<MidiEventHandler> arrayList = this.midiEventHandlers;
        synchronized (arrayList) {
            for (MidiEventHandler e : this.midiEventHandlers) {
                boolean b = e.handleSysExEvent(data, length);
                if (!b || ret) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMetaEvent(int type, byte[] data, int length) {
        boolean ret = false;
        ArrayList<MidiEventHandler> arrayList = this.midiEventHandlers;
        synchronized (arrayList) {
            for (MidiEventHandler e : this.midiEventHandlers) {
                boolean b = e.handleMetaEvent(type, data, length);
                if (!b || ret) continue;
                ret = true;
            }
        }
        return ret;
    }
}

