/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer.pianoroll;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.DefaultMidiEventHandler;
import org.rz.midiplayer.context.MidiChannelEventAdaptor;
import org.rz.midiplayer.context.MidiChannelEventListener;
import org.rz.midiplayer.context.MidiEventHandler;
import org.rz.midiplayer.plugin.renderer.SimpleRenderer;
import org.rz.midiplayer.util.PathUtil;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayerplugin.renderer.pianoroll.NoteObject;
import org.rz.midiplayerplugin.renderer.pianoroll.config.Color;
import org.rz.midiplayerplugin.renderer.pianoroll.config.Config;

public class PianorollRenderer
extends SimpleRenderer {
    static final int NOTE_OBJ_NUM = 1024;
    private Context context;
    private final Dimension screenSize = new Dimension(512, 384);
    private DefaultMidiEventHandler midiEventHandler;
    private final LinkedList<NoteObject> masterObjList = new LinkedList();
    private final LinkedList<NoteObject> activeObjList = new LinkedList();
    public static final java.awt.Color[] DEFAULT_COLORS = new java.awt.Color[]{new java.awt.Color(8388564), new java.awt.Color(11591910), new java.awt.Color(16767673), new java.awt.Color(16752762), new java.awt.Color(10025880), new java.awt.Color(0xFFFF00), new java.awt.Color(16766720), new java.awt.Color(0xEE82EE), new java.awt.Color(15684210), new java.awt.Color(13789470), new java.awt.Color(64154), new java.awt.Color(0x7FFF00), new java.awt.Color(16113331), new java.awt.Color(16758465), new java.awt.Color(16716947), new java.awt.Color(49151), new java.awt.Color(12092939), new java.awt.Color(16737095)};
    private final java.awt.Color[] pianoRollColors = new java.awt.Color[16];

    public void onInit(Context ctx, String pluginDir) {
        int i;
        this.context = ctx;
        this.midiEventHandler = new DefaultMidiEventHandler(ctx);
        this.midiEventHandler.addMidiChannelEventListener((MidiChannelEventListener)new MidiChannelEventAdaptor(){

            public void noteOff(int ch, int note) {
                PianorollRenderer.this.noteOff(ch, note);
            }

            public void noteOn(int ch, int note, int vel) {
                PianorollRenderer.this.noteOn(ch, note, vel);
            }
        });
        ctx.addMidiEventHandler((MidiEventHandler)this.midiEventHandler);
        try {
            for (i = 0; i < 16; ++i) {
                this.pianoRollColors[i] = DEFAULT_COLORS[i];
            }
            JAXBUtil jaxbConfig = new JAXBUtil(Config.class);
            Config config = (Config)jaxbConfig.loadFromFile(PathUtil.package2ClasspathString(((Object)((Object)this)).getClass()) + "/config.xsd", PathUtil.buildPath((String)pluginDir, (String)"config.xml")).getValue();
            for (Color c : config.getPianoroll().getColor()) {
                try {
                    java.awt.Color col;
                    short ch = c.getMidich();
                    this.pianoRollColors[ch] = col = java.awt.Color.decode(c.getColor());
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Failed to loading a config file", e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to loading a config file", e);
        }
        this.activeObjList.clear();
        this.masterObjList.clear();
        for (i = 0; i < 1024; ++i) {
            this.masterObjList.addLast(new NoteObject());
        }
    }

    public Component getComponent() {
        Component c = super.getComponent();
        c.setPreferredSize(this.screenSize);
        return c;
    }

    public void onMidiPlayingBefore(File midiFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMidiStoped() {
        LinkedList<NoteObject> linkedList = this.activeObjList;
        synchronized (linkedList) {
            for (NoteObject o : this.activeObjList) {
                o.noteOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOn(int ch, int noteNo, int vel) {
        LinkedList<NoteObject> linkedList = this.masterObjList;
        synchronized (linkedList) {
            LinkedList<NoteObject> linkedList2 = this.activeObjList;
            synchronized (linkedList2) {
                NoteObject no = !this.masterObjList.isEmpty() ? this.masterObjList.removeFirst() : this.activeObjList.removeFirst();
                no.reset();
                no.noteOn(472, 382 - 3 * noteNo);
                no.noteNo = noteNo;
                no.channel = ch;
                no.setColor(this.pianoRollColors[ch]);
                this.activeObjList.addLast(no);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void noteOff(int ch, int noteNo) {
        LinkedList<NoteObject> linkedList = this.activeObjList;
        synchronized (linkedList) {
            for (NoteObject no : this.activeObjList) {
                if (no.channel != ch || no.noteNo != noteNo) continue;
                no.noteOff();
            }
        }
    }

    public void onDispose(Context ctx) {
        ctx.removeMidiEventHandler((MidiEventHandler)this.midiEventHandler);
        super.onDispose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        LinkedList<NoteObject> linkedList = this.masterObjList;
        synchronized (linkedList) {
            LinkedList<NoteObject> linkedList2 = this.activeObjList;
            synchronized (linkedList2) {
                int i = 0;
                while (i < this.activeObjList.size()) {
                    NoteObject n = this.activeObjList.get(i);
                    if (!n.visible) {
                        this.activeObjList.remove(i);
                        this.masterObjList.addLast(n);
                        continue;
                    }
                    n.update();
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g) {
        g.setColor(java.awt.Color.black);
        g.fillRect(0, 0, this.screenSize.width, this.screenSize.height);
        LinkedList<NoteObject> linkedList = this.activeObjList;
        synchronized (linkedList) {
            for (NoteObject n : this.activeObjList) {
                n.render(g);
            }
        }
    }

    public boolean isEnabledResizeWindow() {
        return false;
    }
}

