//******************************************************************************
//
// MIDITrail / DXPrimitive
//
// v~eBu`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// DrawPrimitive, DrawIndexedPrimitive ̑bvNXB
// CfbNXobt@쐬ȂDrawPrimitive
// CfbNXobt@쐬DrawIndexedPrimitive
// gpB

#pragma once

#include <d3d9.h>
#include <d3dx9.h>


//******************************************************************************
// v~eBu`NX
//******************************************************************************
class DXPrimitive
{
public:

	//RXgN^^fXgN^
	DXPrimitive(void);
	virtual ~DXPrimitive(void);

	//\[X
	void Release();
	
	//
	int Initialize(
			unsigned long vertexSize,
			unsigned long fvfFormat,
			D3DPRIMITIVETYPE type
		);

	//_obt@^CfbNXobt@̐
	int CreateVertexBuffer(LPDIRECT3DDEVICE9 pD3DDevice, unsigned long vertexNum);
	int CreateIndexBuffer(LPDIRECT3DDEVICE9 pD3DDevice, unsigned long indexNum);

	//_f[^^CfbNXf[^o^
	//  obt@̃bN^AbN͎Iɍs
	//  {\bhɎw肵f[^͗pґj
	int SetAllVertex(LPDIRECT3DDEVICE9 pD3DDevice, void* pVertex);
	int SetAllIndex(LPDIRECT3DDEVICE9 pD3DDevice, unsigned long* pIndex);

	//}eAo^iȗj
	void SetMaterial(D3DMATERIAL9 material);

	//ړ
	void Transform(D3DXMATRIX worldMatrix);

	//`
	int Draw(
			LPDIRECT3DDEVICE9 pD3DDevice,
			LPDIRECT3DTEXTURE9 pTexture = NULL,
			int drawPrimitiveNum = -1
		);

	//_obt@^CfbNXobt@̃bN
	//  obt@̓eɂ̓bNăobt@̃|C^擾
	//  obt@̓eIAbN
	int LockVertex(void** pPtrVertex);
	int UnlockVertex();
	int LockIndex(unsigned long** pPtrIndex);
	int UnlockIndex();

private:

	//_
	unsigned long m_VertexSize;
	unsigned long m_FVFFormat;
	D3DPRIMITIVETYPE m_PrimitiveType;
	LPDIRECT3DVERTEXBUFFER9 m_pVertexBuffer;
	unsigned long m_VertexNum;
	bool m_IsVertexLocked;
	
	//CfbNX
	LPDIRECT3DINDEXBUFFER9 m_pIndexBuffer;
	unsigned long m_IndexNum;
	bool m_IsIndexLocked;
	
	//`
	D3DMATERIAL9 m_Material;
	D3DXMATRIX m_WorldMatrix;

	int _GetPrimitiveNum(unsigned long* pNum);
	void _GetDefaultMaterial(D3DMATERIAL9* pMaterial);

};

