//******************************************************************************
//
// Simple Base Library / YNPathUtil
//
// pX[eBeBNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNErrCtrl.h"
#include "YNPathUtil.h"
#include <stdlib.h>
#include <shlobj.h>
#include <stdio.h>

namespace YNBaseLib {


//******************************************************************************
// RXgN^
//******************************************************************************
YNPathUtil::YNPathUtil(void)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
YNPathUtil::~YNPathUtil(void)
{
}

//******************************************************************************
// vZXst@CfBNgpX擾
//******************************************************************************
int YNPathUtil::GetModuleDirPath(
		TCHAR* pBuf,
		unsigned long bufSize
	)
{
	int result = 0;
	DWORD apiresult = 0;
	errno_t eresult = 0;
	TCHAR path[_MAX_PATH];
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];

	//vZXst@CpX擾
	apiresult = GetModuleFileName(GetModuleHandle(NULL), path, _MAX_PATH);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//pXvf̕
	eresult = _tsplitpath_s(
					path,		//pX
					drive,		//hCuobt@
					_MAX_DRIVE,	//obt@TCY
					dir,		//fBNgobt@
					_MAX_DIR,	//obt@TCY
					fname,		//t@Cobt@
					_MAX_FNAME,	//obt@TCY
					ext,		//gqobt@
					_MAX_EXT	//obt@TCY
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//pX쐬
	eresult = _tmakepath_s(
					pBuf,		//pXi[obt@
					bufSize,	//obt@TCY
					drive,		//hCu
					dir,		//fBNg
					NULL,		//t@C
					NULL		//gq
				);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// fXgN^
//******************************************************************************
int YNPathUtil::GetAppDataDirPath(
		TCHAR* pBuf,
		unsigned long bufSize
	)
{
	int result = 0;
	HRESULT hresult = 0;
	errno_t eresult = 0;
	TCHAR path[MAX_PATH];

	hresult = SHGetFolderPath(
					NULL,				//I[i[EBhE
					CSIDL_APPDATA,		//tH_w
					NULL,				//ANZXg[N
					SHGFP_TYPE_CURRENT,	//tOF݂̃tH_pX
										//  [UύXĂ\
					path				//pXi[obt@
				);
	if (hresult != S_OK) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	eresult = _tcscpy_s(pBuf, bufSize, path);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	eresult = _tcscat_s(pBuf, bufSize, _T("\\"));
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

} // end of namespace

