//******************************************************************************
//
// MIDITrail / DIKeyCtrl
//
// DirectInput L[͐NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DIKeyCtrl.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
DIKeyCtrl::DIKeyCtrl(void)
{
	m_pDI = NULL;
	m_pDIDevice = NULL;
	ZeroMemory(m_KeyStatus, sizeof(unsigned char) * 256);
}

//******************************************************************************
// fXgN^
//******************************************************************************
DIKeyCtrl::~DIKeyCtrl(void)
{
	Terminate();
}

//******************************************************************************
// 
//******************************************************************************
int DIKeyCtrl::Initialize(
		HWND hWnd
	)
{
	int result = 0;
	HRESULT hresult = DI_OK;
	HINSTANCE hInstance = NULL;

	Terminate();

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)GetWindowLongPtr(hWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hWnd);
		goto EXIT;
	}

	//DirectInputIuWFNg̐
	hresult = DirectInput8Create(
				hInstance,				//AvP[VCX^Xnh
				DIRECTINPUT_VERSION,	//DirectInputo[Wԍ
				IID_IDirectInput8,		//C^[tF[Xʎq
				(void**)&m_pDI,			//쐬ꂽC^[tF[X|C^
				NULL					//IUnknownC^[tFCX|C^
			);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, (DWORD)hInstance);
		goto EXIT;
	}

	//foCXIuWFNg̐
	hresult = m_pDI->CreateDevice(
					GUID_SysKeyboard,	//̓foCX̃CX^XGUID
					&m_pDIDevice,		//쐬ꂽC^[tF[X|C^
					NULL				//IUnknownC^[tFCX|C^
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//foCX̃f[^tH[}bgݒF`ς݃O[oϐw
	hresult = m_pDIDevice->SetDataFormat(&c_dfDIKeyboard);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//foCX̋xݒ
	hresult = m_pDIDevice->SetCooperativeLevel(
					hWnd,					//foCXɊ֘AtĂEBhEnh
					DISCL_FOREGROUND		//xFtHAOhANZX
					| DISCL_NONEXCLUSIVE	//xFrIANZX
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, (DWORD)hWnd);
		goto EXIT;
	}

	//foCX̃vpeBݒ
	DIPROPDWORD diprop;
	diprop.diph.dwSize       = sizeof(DIPROPDWORD);
	diprop.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diprop.diph.dwObj        = 0;			//DIPH_DEVICȄꍇ̓[
	diprop.diph.dwHow        = DIPH_DEVICE;	//dwObj̉ߕ@FfoCXS
	diprop.dwData            = 8;			//ݒ肷vpeBFobt@TCY

	hresult = m_pDIDevice->SetProperty(
					DIPROP_BUFFERSIZE,	//ݒΏۃvpeBGUID
					&diprop.diph		//ݒ肷DIPROPHEADER\
				);
	if (FAILED(hresult) && (hresult != DI_PROPNOEFFECT)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// I
//******************************************************************************
void DIKeyCtrl::Terminate()
{
	if (m_pDIDevice != NULL) {
		m_pDIDevice->Unacquire();
		m_pDIDevice->Release();
		m_pDIDevice = NULL;
	}

	if (m_pDI != NULL) {
		m_pDI->Release();
		m_pDI = NULL;
	}

	return;
}

//******************************************************************************
// foCXANZX擾
//******************************************************************************
int DIKeyCtrl::Acquire()
{
	int result = 0;
	HRESULT hresult = DI_OK;

	if (m_pDIDevice == NULL) goto EXIT;

	//ANZX擾F//foCX擾ς(S_FALSE)͐Ƃ݂Ȃ
	hresult = m_pDIDevice->Acquire();
	if (FAILED(hresult) && (hresult != S_FALSE)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// foCXANZX
//******************************************************************************
int DIKeyCtrl::Unacquire()
{
	int result = 0;
	HRESULT hresult = DI_OK;

	if (m_pDIDevice == NULL) goto EXIT;

	//ANZX
	hresult = m_pDIDevice->Unacquire();
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// L[Ԏ擾
//******************************************************************************
int DIKeyCtrl::GetKeyStatus()
{
	int result = 0;
	HRESULT hresult = DI_OK;

	hresult = m_pDIDevice->GetDeviceState(256, m_KeyStatus);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//EBhEANeBuԂłGetDeviceState()̓G[ɂȂ(0x8007000c)
	//ǂ悤EEE

EXIT:;
	return result;
}

//******************************************************************************
// L[ԊmF
//******************************************************************************
bool DIKeyCtrl::IsKeyDown(
		unsigned char key
	)
{
	bool isDown = false;

	if ((m_KeyStatus[key] & 0x80) != 0) {
		isDown = true;
	}

	return isDown;
}

