//******************************************************************************
//
// Simple MIDI Library / SMDevInfo
//
// MIDIデバイス情報クラス
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import <CoreMIDI/CoreMIDI.h>
#import <CoreAudio/CoreAudio.h>


//******************************************************************************
// MIDIデバイス情報クラス
//******************************************************************************
class SMDevInfo
{
public:
	
	//コンストラクタ／デストラクタ
	SMDevInfo(void);
	virtual ~SMDevInfo(void);
	
	//表示名称登録
	void SetDisplayName(NSString* pDisplayName);
	
	//識別名称登録："メーカー名/モデル名/エンドポイントプロパティ名"
	void SetIdName(NSString* pIdName);
	
	//エンドポイント登録
	void SetEndpointRef(MIDIEndpointRef endpointRef);
	
	//表示名称取得
	NSString* GetDisplayName();
	
	//識別名称取得
	NSString* GetIdName();
	
	//エンドポイント取得
	MIDIEndpointRef GetEndpointRef();
	
private:
	
	NSString* m_pDisplayName;
	NSString* m_pIdName;
	MIDIEndpointRef m_EndpointRef;
	
};


