//******************************************************************************
//
// Simple MIDI Library / SMSequencer
//
// V[PTNX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ^C}[Xbh͉ts߁AMIDIo̓foCX̐ɐO
// B̃XbhŉʍXVsĂ͂ȂȂB
// Xbhւ̒ʒmPostMessageŎB
// _TimerCallBack()_OnTimer()EEE

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMSequencer.h"
#include "SMEventMIDI.h"
#include "SMEventSysEx.h"
#include "SMEventMeta.h"
#include "SMFPUCtrl.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMSequencer::SMSequencer(void)
{
	m_Status = StatusStop;
	m_PlayIndex = 0;
	m_UserRequest = RequestNone;
	m_PortNo = 0;
	m_pSeqData = NULL;
	m_TimerID = NULL;
	m_TimerResolution = 0;
	m_TimeDivision = 0;
	m_Tempo = SM_DEFAULT_TEMPO;

	m_PrevTimerTime = 0;
	m_CurPlayTime = 0;
	m_PrevEventTime = 0;
	m_NextEventTime = 0.0;
	m_NextNtcTime = 0;
	m_TotalTickTime = 0;
	m_TotalTickTimeTemp = 0;
	m_PlaybackSpeed = 1;
	m_PlaySpeedRatio = 1.0;

	//XLbv
	m_isSkipping = false;
	m_SkipTargetTime = 0;
	m_NotesCount = 0;
	m_MovingTimeSpanInMsec = 0;

	//ߔԍn
	m_TickTimeOfBar = 0;
	m_CurBarNo = 1;
	m_PrevBarTickTime = 0;

	//qL
	m_BeatNumerator = 0;
	m_BeatDenominator = 0;

	//|[gNA
	_ClearPortInfo();
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMSequencer::~SMSequencer(void)
{
	//|[gNA
	_ClearPortInfo();

	//MIDIo̓foCX
	_CloseMIDIOutDev();

	//^C}foCX
	_ReleaseTimerDev();
}

//******************************************************************************
// 
//******************************************************************************
int SMSequencer::Initialize(
		HWND hTargetWnd,
		unsigned long msgId
	)
{
	int result = 0;

	if (m_Status != StatusStop) {
		result = YN_SET_ERR("Program error.", m_Status, 0);
		goto EXIT;
	}

	//MIDIo̓foCX
	result = m_OutDevCtrl.Initialize();
	if (result != 0) goto EXIT;

	//|[gNA
	_ClearPortInfo();

	//Cxg]IuWFNg
	result = m_MsgTrans.Initialize(hTargetWnd, msgId);
	if (result != 0) goto EXIT;

	//CxgEHb`[
	result = m_EventWatcher.Initialize(&m_MsgTrans);
	if (result != 0) goto EXIT;

	//^C}foCX
	result = _InitializeTimerDev();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// |[gΉfoCXo^
//******************************************************************************
int SMSequencer::SetPortDev(
		unsigned char portNo,
		const char* pProductName
	)
{
	int result = 0;
	errno_t eresult = 0;

	if (portNo >= SM_MIDIOUT_PORT_NUM_MAX) {
		result = YN_SET_ERR("Program error.", portNo, 0);
		goto EXIT;
	}

	eresult = strcpy_s(m_PortDevName[portNo], MAXPNAMELEN, pProductName);
	if (eresult != 0) {
		result = YN_SET_ERR("Program error.", portNo, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// V[PXf[^o^
//******************************************************************************
int SMSequencer::SetSeqData(
		SMSeqData* pSeqData
	)
{
	int result = 0;
	unsigned long numerator = 0;
	unsigned long denominator = 0;

	if (m_Status != StatusStop) {
		result = YN_SET_ERR("Program error.", m_Status, 0);
		goto EXIT;
	}

	m_pSeqData = pSeqData;

	//}[Wς݃gbN擾
	result = m_pSeqData->GetMergedTrack(&m_Track);
	if (result != 0) goto EXIT;

	//\擾Fl̒l (ex. 48, 480, ...)
	m_TimeDivision = m_pSeqData->GetTimeDivision();
	if (m_TimeDivision == 0) {
		//f[^ُFSMFǂݍݎɃ`FbNĂ͂
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//e|擾
	m_Tempo = m_pSeqData->GetTempo();
	if (m_Tempo == 0) {
		//f[^ُ
		result = YN_SET_ERR("Invalid data found.", 0, 0);
		goto EXIT;
	}

	//qL1߂̃`bN^CZo
	numerator = m_pSeqData->GetBeatNumerator();
	denominator = m_pSeqData->GetBeatDenominator();
	if (denominator == 0) {
		//f[^ُ
		result = YN_SET_ERR("Invalid data found.", numerator, denominator);
		goto EXIT;
	}
	m_TickTimeOfBar = (numerator * m_TimeDivision * 4) / denominator;

	m_BeatNumerator = numerator;
	m_BeatDenominator = denominator;

EXIT:;
	return result;
}

//******************************************************************************
// tJn
//******************************************************************************
int SMSequencer::Play()
{
	int result = 0;
	SMFPUCtrl fpuCtrl;

	if (m_pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//tȂ牽Ȃ
	if (m_Status == StatusPlay) goto EXIT;

	//_Zx{xɐݒ
	result = fpuCtrl.Start(SMFPUCtrl::FPUDouble);
	if (result != 0) goto EXIT;

	//擪牉tJn
	if (m_Status == StatusStop) {
		//ĐJnp[^
		result = _InitializeParamsOnPlayStart();
		if (result != 0) goto EXIT;

		//MIDIo̓foCXJ
		result = _OpenMIDIOutDev();
		if (result != 0) goto EXIT;
	}
	//ꎞ~牉tĊJ
	if (m_Status == StatusPause) {
		m_PrevTimerTime = _GetCurTimeInNano();
	}
	m_Status = StatusPlay;
	m_UserRequest = RequestNone;
	m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_PLAY);

	//^C}N
	m_TimerID = timeSetEvent(
					m_TimerResolution, //Cxgxi~bj
					m_TimerResolution, //Cxg\i~bj
					_TimerCallBack,    //R[obN֐
					(DWORD_PTR)this,   //[U[R[obNf[^
					TIME_PERIODIC      //^C}[ʁFĂяo
				);
	if (m_TimerID == NULL) {
		result = YN_SET_ERR("Timer device error.", m_TimerResolution, 0);
		goto EXIT;
	}

	result = fpuCtrl.End();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// tꎞ~
//******************************************************************************
void SMSequencer::Pause()
{
	//v󂯕t邾iL[CO͂Ȃj
	//ۂ̏̓^C}[XbhɈϔC
	m_UserRequest = RequestPause;
}

//******************************************************************************
// tĊJ
//******************************************************************************
int SMSequencer::Resume()
{
	int result = 0;

	//݂Play()ĊJ˂Ă
	result = Play();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// t~
//******************************************************************************
void SMSequencer::Stop()
{

	if (m_Status == StatusPause) {
		//ꎞ~̏ꍇ̓^C}[Xbh~Ă邽
		//Iʒm
		m_Status = StatusStop;
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
	}
	else {
		//t͗v󂯕t邾iL[CO͂Ȃj
		//ۂ̏̓^C}[XbhɈϔC
		m_UserRequest = RequestStop;
	}
}

//******************************************************************************
// ĐXs[hݒin{j
//******************************************************************************
void SMSequencer::SetPlaybackSpeed(
		unsigned long nTimes
	)
{
	m_PlaybackSpeed =  nTimes;
}

//******************************************************************************
// ĐXs[hݒip[Zgj
//******************************************************************************
void SMSequencer::SetPlaySpeedRatio(
		unsigned long ratio
	)
{
	m_PlaySpeedRatio =  (double)ratio / 100.0;
}

//******************************************************************************
// Ch^XLbvړԐݒ
//******************************************************************************
void SMSequencer::SetMovingTimeSpanInMsec(
		unsigned long timeSpan
	)
{
	m_MovingTimeSpanInMsec = timeSpan;
}

//******************************************************************************
//tʒuXLbv
//******************************************************************************
int SMSequencer::Skip(
		int relativeTimeInMsec
	)
{
	int result = 0;
	unsigned long long diffTime = 0;

	//tłȂΉȂ
	if (m_Status != StatusPlay) goto EXIT;

	//tʒu
	if (relativeTimeInMsec < 0) {
		diffTime = (unsigned long long)(-1 * relativeTimeInMsec) * 1000000;
		if (m_CurPlayTime < diffTime) {
			m_SkipTargetTime = 0;
		}
		else {
			m_SkipTargetTime = m_CurPlayTime - diffTime;
		}
	}
	else {
		diffTime = (unsigned long long)(relativeTimeInMsec) * 1000000;
		m_SkipTargetTime = m_CurPlayTime + diffTime;
		//Ȃ̏IԂ𒴂\
	}

	//t͗v󂯕t邾iL[CO͂Ȃj
	//ۂ̏̓^C}[XbhɈϔC
	m_UserRequest = RequestSkip;

EXIT:;
	return result;
}

//******************************************************************************
// ^C}foCX
//******************************************************************************
int SMSequencer::_InitializeTimerDev()
{
	int result = 0;
	UINT apiresult = 0;
	TIMECAPS tc;

	if (m_TimerResolution != 0) goto EXIT;

	//^C}foCX̍ŏ\擾iʏ1msj
	apiresult = timeGetDevCaps(&tc, sizeof(TIMECAPS));
	if (apiresult != TIMERR_NOERROR) {
		result = YN_SET_ERR("Timer device error.", apiresult, 0);
		goto EXIT;
	}
	m_TimerResolution = tc.wPeriodMin;

	//ŏ^C}\̐ݒ
	timeBeginPeriod(m_TimerResolution);

EXIT:;
	return result;
}

//******************************************************************************
// ^C}foCX
//******************************************************************************
int SMSequencer::_ReleaseTimerDev()
{
	int result = 0;
	UINT apiresult = 0;

	if (m_TimerResolution != 0) {
		apiresult = timeEndPeriod(m_TimerResolution);
		if (apiresult != TIMERR_NOERROR) {
			result = YN_SET_ERR("Timer device error.", apiresult, 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// |[gNA
//******************************************************************************
void SMSequencer::_ClearPortInfo()
{
	unsigned char portNo = 0;

	for (portNo = 0; portNo < SM_MIDIOUT_PORT_NUM_MAX; portNo++) {
		m_PortDevName[portNo][0] = '\0';
	}
}

//******************************************************************************
// MIDIo̓foCXI[v
//******************************************************************************
int SMSequencer::_OpenMIDIOutDev()
{
	int result = 0;
	unsigned char portNo = 0;

	//|[gΉfoCXMIDIo̓foCXɓo^
	for (portNo = 0; portNo < SM_MIDIOUT_PORT_NUM_MAX; portNo++) {
		if (strlen(m_PortDevName[portNo]) > 0) {
			result = m_OutDevCtrl.SetPortDev(portNo, m_PortDevName[portNo]);
			if (result != 0) goto EXIT;
		}
	}

	//S|[g̃foCXJ
	result = m_OutDevCtrl.OpenPortDevAll();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// MIDIo̓foCXN[Y
//******************************************************************************
int SMSequencer::_CloseMIDIOutDev()
{
	int result = 0;

	result = m_OutDevCtrl.ClosePortDevAll();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// tC^[o
//******************************************************************************
int SMSequencer::_IntervalProc(
		BOOL* pIsContinue
	)
{
	int result = 0;
	unsigned long deltaTime = 0;

	*pIsContinue = true;

	//tʒuXV
	result = _UpdatePlayPosition();
	if (result != 0) goto EXIT;

	//CxgɓBĂ瑗Ms
	if ((unsigned long long)m_NextEventTime <= m_CurPlayTime) {

		//`bN^Cv
		m_TotalTickTime += m_PrevDeltaTime;

		while (deltaTime == 0) {
			//CxgM
			result = _OutputMIDIEvent(m_PortNo, &m_Event);
			if (result != 0) goto EXIT;

			//f[^I[Ȃ牉tI
			m_PlayIndex++;
			if (m_PlayIndex >= m_Track.GetSize()) {
				if (!m_isSkipping) {
					_AllTrackNoteOff();
					m_MsgTrans.PostPlayTime((unsigned long)(m_CurPlayTime/1000000), m_TotalTickTime);
					m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
					m_Status = StatusStop;
				}
				*pIsContinue = false;
				break;
			}

			//Cxg擾
			m_Track.GetDataSet(m_PlayIndex, &deltaTime, &m_Event, &m_PortNo);
		}
		//ʒm̂߃CxgL
		//ʒm͌ȐxKvƂȂ1msec͖
		m_PrevEventTime = (unsigned long long)m_NextEventTime;

		//CxgMʒuZo
		m_NextEventTime += _ConvTick2TimeNanosec(deltaTime);
		m_PrevDeltaTime = deltaTime;
	}

EXIT:;
	return result;
}

//******************************************************************************
// tʒuXV
//******************************************************************************
int SMSequencer::_UpdatePlayPosition()
{
	int result = 0;
	unsigned long long curTime = 0;
	unsigned long long diffTime = 0;
	unsigned long diffTickTime = 0;
	unsigned long nextBarTickTime = 0;
	unsigned long long ntcSpan = 0;

	curTime = _GetCurTimeInNano();

	//O^C}[̌oߎԂ𗘗pĉtԂXV
	//  Nォ49܂P[Xł̌vZŖȂ
	diffTime = curTime - m_PrevTimerTime;

	//O^C}[̌oߎԂ𗘗pĉtԂXV
	if (m_isSkipping) {
		//XLbv̏ꍇ͉zI5msec.o߂
		diffTime = 5 * 1000000;
	}
	else {
		//XLbvłȂΎۂ̌oߎԂZo
		diffTime = curTime - m_PrevTimerTime;
	}

	//ĐXs[h𔽉fin{j
	if (m_PlaybackSpeed == 1) {
		diffTime = (unsigned long long)((double)diffTime * m_PlaySpeedRatio);
	}
	else {
		diffTime = diffTime * m_PlaybackSpeed;
	}

	m_CurPlayTime += diffTime;
	m_PrevTimerTime = curTime;

	//OCxǧoߎԂ`bN^CɊZ
	//  ϊ덷邪덷~ςȂߖȂ
	diffTickTime = _ConvTimeNanosec2Tick(m_CurPlayTime - m_PrevEventTime);

	//Ȑ擪̃`bN^Cv
	//m_TotalTickTime̓Cxgɂ̂ݍXV邽߂ł͏Ȃ
	m_TotalTickTimeTemp = m_TotalTickTime + diffTickTime;

	//ʒmԂɓB牉tԂʒm
	if ((m_NextNtcTime <= m_CurPlayTime) && (!m_isSkipping)) {
		m_MsgTrans.PostPlayTime((unsigned long)(m_CurPlayTime/1000000), m_TotalTickTimeTemp);
		//ʒmԊu60FPS\l0.01b(10msec = 10000000nanosec)Ƃ
		//TODO: OԊuwł悤ɂ
		ntcSpan = 10 * 1000000;;
		m_NextNtcTime = m_CurPlayTime - (m_CurPlayTime % ntcSpan) + ntcSpan;
	}

	//ߔԍXV̊mF
	nextBarTickTime = m_PrevBarTickTime + m_TickTimeOfBar;
	if (nextBarTickTime <= m_TotalTickTimeTemp) {
		m_CurBarNo++;
		m_PrevBarTickTime = nextBarTickTime;
		if (!m_isSkipping) {
			m_MsgTrans.PostBar(m_CurBarNo);
		}
	}

//EXIT:;
	return result;
}

//******************************************************************************
// `bN^CԂւ̕ϊiimbj
//******************************************************************************
double SMSequencer::_ConvTick2TimeNanosec(
		unsigned long tickTime
	)
{
	double timeNanosec = 0;
	
	//(1) l̕\ division
	//    F48
	//(2) gbNf[^̃f^^C delta
	//    \̒lpĕ\鎞ԍ
	//    \48Ńf^^C24Ȃ甪̎ԍ
	//(3) e|ݒi}CNbj tempo
	//    l̎ԊԊu
	//
	// f^^CɑΉԊԊui~bj
	//  = (delta / division) * tempo / 1000
	//  = (delta * tempo) / (division * 1000)
	
	timeNanosec = ((double)tickTime * (double)m_Tempo) * 1000.0 / ((double)m_TimeDivision);
	
	return timeNanosec;
}

//******************************************************************************
// ԁiimbj`bN^Cւ̕ϊ
//******************************************************************************
unsigned long SMSequencer::_ConvTimeNanosec2Tick(
		unsigned long long timeNanosec
	)
{
	unsigned long tickTime = 0;
	unsigned long long a = 0;
	unsigned long long b = 0;
	
	a = timeNanosec * m_TimeDivision / 1000;
	b = a / m_Tempo;
	tickTime = (unsigned long)b;
	
	return tickTime;
}

//******************************************************************************
// CxgM
//******************************************************************************
int SMSequencer::_OutputMIDIEvent(
		unsigned char portNo,
		SMEvent* pEvent
	)
{
	int result = 0;

	//MIDICxgM
	if (pEvent->GetType() == SMEvent::EventMIDI) {
		SMEventMIDI eventMIDI;
		eventMIDI.Attach(pEvent);
		result = _SendMIDIEvent(portNo, &eventMIDI);
		if (result != 0) goto EXIT;
	}
	//SysExCxgM
	else if (pEvent->GetType() == SMEvent::EventSysEx) {
		SMEventSysEx eventSysEx;
		eventSysEx.Attach(pEvent);
		result = _SendSysExEvent(portNo, &eventSysEx);
		if (result != 0) goto EXIT;
	}
	//^CxgM
	else if (pEvent->GetType() == SMEvent::EventMeta) {
		SMEventMeta eventMeta;
		eventMeta.Attach(pEvent);
		result = _SendMetaEvent(portNo, &eventMeta);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgM
//******************************************************************************
int SMSequencer::_SendMIDIEvent(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	int result = 0;
	unsigned long msg = 0;
	bool isFiltered = false;

	//bZ[W擾
	result = pMIDIEvent->GetMIDIOutShortMsg(&msg);
	if (result != 0) goto EXIT;

	//MIDICxgtB^
	result = _FilterMIDIEvent(portNo, pMIDIEvent, &isFiltered);
	if (result != 0) goto EXIT;

	//MIDICxgM
	if (!isFiltered) {
		//bZ[WóFo͊܂Ő䂪߂Ȃ
		result = m_OutDevCtrl.SendShortMsg(portNo, msg);
		if (result != 0) goto EXIT;

		//MIDICxgbZ[W|Xg
		result =  m_EventWatcher.WatchEventMIDI(portNo, pMIDIEvent);
		if (result != 0) goto EXIT;
	}

	//m[gONJEg
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOn) {
		m_NotesCount++;
	}

	//Rg[`FWĎ
	//  sb`xhxERPNĎ
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::ControlChange) {
		result = m_EventWatcher.WatchEventControlChange(portNo, pMIDIEvent);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// SysExCxgM
//******************************************************************************
int SMSequencer::_SendSysExEvent(
		unsigned char portNo,
		SMEventSysEx* pSysExEvent
	)
{
	int result = 0;
	unsigned char* pVarMsg = NULL;
	unsigned long size = 0;

	//bZ[W擾
	pSysExEvent->GetMIDIOutLongMsg(&pVarMsg, &size);

	//bZ[WóFo͊܂Ő䂪߂Ȃ
	result = m_OutDevCtrl.SendLongMsg(portNo, pVarMsg, size);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ^CxgM
//******************************************************************************
int SMSequencer::_SendMetaEvent(
		unsigned char portNo,
		SMEventMeta* pMetaEvent
	)
{
	int result = 0;

	//^CxgMIDIfoCXɑMȂ

	//e|
	if (pMetaEvent->GetType() == 0x51) {
		//f^^CvZɔf
		m_Tempo = pMetaEvent->GetTempo();
		if (m_Tempo == 0) {
			//f[^ُ
			result = YN_SET_ERR("Invalid data found.", 0, 0);
			goto EXIT;
		}

		//ʒm
		if (!m_isSkipping) {
			m_MsgTrans.PostTempo(m_Tempo);
		}
	}

	//qL
	if (pMetaEvent->GetType() == 0x58) {
		//q擾
		unsigned long numerator = 0;
		unsigned long denominator = 0;
		pMetaEvent->GetTimeSignature(&numerator, &denominator);
		if (denominator == 0) {
			//f[^ُ
			result = YN_SET_ERR("Invalid data found.", numerator, denominator);
			goto EXIT;
		}
		m_BeatNumerator = numerator;
		m_BeatDenominator = denominator;

		//ʒm
		if (!m_isSkipping) {
			m_MsgTrans.PostBeat((unsigned short)numerator, (unsigned short)denominator);
		}

		//1߂̃`bN^CXV
		m_TickTimeOfBar = (numerator * m_TimeDivision * 4) / denominator;

		//qLXV̂1ߖڊJnn_ƂĒʒm
		if (m_PrevBarTickTime != m_TotalTickTime) {
			m_CurBarNo++;
			m_PrevBarTickTime = m_TotalTickTime;
			if (!m_isSkipping) {
				m_MsgTrans.PostBar(m_CurBarNo);
			}
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// [Uv
//******************************************************************************
int SMSequencer::_ProcUserRequest(
		BOOL* pIsContinue
	)
{
	int result = 0;

	if (m_UserRequest == RequestNone) goto EXIT;

	//SgbNm[gIt
	result = _AllTrackNoteOff();
	if (result != 0) goto EXIT;

	*pIsContinue = false;

	//ꎞ~vꂽꍇ
	if (m_UserRequest == RequestPause) {
		m_Status = StatusPause;
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_PAUSE);
	}

	//~vꂽꍇ
	if (m_UserRequest == RequestStop) {
		m_Status = StatusStop;
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
	}

	//XLbvvꂽꍇ
	if (m_UserRequest == RequestSkip) {
		*pIsContinue = true;
		result = _ProcSkip(m_SkipTargetTime, pIsContinue);
		if (result != 0) goto EXIT;
	}

	m_UserRequest = RequestNone;

EXIT:;
	return result;
}

//******************************************************************************
// SgbNm[gIt
//******************************************************************************
int SMSequencer::_AllTrackNoteOff()
{
	int result = 0;

	result = m_OutDevCtrl.NoteOffAll();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ݎ擾iimbj
//******************************************************************************
unsigned long long SMSequencer::_GetCurTimeInNano()
{
	return ((unsigned long long)(timeGetTime()) * 1000000);
}

//******************************************************************************
// ĐJnp[^
//******************************************************************************
int SMSequencer::_InitializeParamsOnPlayStart()
{
	int result = 0;
	unsigned long deltaTime = 0;

	//tʒuȂ̐擪ɖ߂
	m_PlayIndex = 0;
	result = m_Track.GetDataSet(m_PlayIndex, &deltaTime, &m_Event, &m_PortNo);
	if (result != 0) goto EXIT;

	m_PrevTimerTime = _GetCurTimeInNano();
	m_CurPlayTime = 0;
	m_PrevEventTime = 0;
	m_NextEventTime = _ConvTick2TimeNanosec(deltaTime);
	m_NextNtcTime = 0;
	m_PrevDeltaTime = deltaTime;
	m_TotalTickTime = 0;
	m_TotalTickTimeTemp = 0;
	m_CurBarNo = 1;
	m_PrevBarTickTime = 0;
	m_NotesCount = 0;

	//CxgEHb`[
	result = m_EventWatcher.Initialize(&m_MsgTrans);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgLbVNA
//******************************************************************************
void SMSequencer::_ClearMIDIEventCache()
{
	unsigned long portNo = 0;
	unsigned long chNo = 0;

	for (portNo = 0; portNo < SM_MAX_PORT_NUM; portNo++) {
		for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
			m_CachePitchBend[portNo][chNo][0] = 0xFF;
			m_CachePitchBend[portNo][chNo][1] = 0xFF;
			m_CacheCC001_Modulation[portNo][chNo] = 0xFF;
			m_CacheCC007_Volume[portNo][chNo] = 0xFF;
			m_CacheCC010_Panpot[portNo][chNo] = 0xFF;
			m_CacheCC011_Expression[portNo][chNo] = 0xFF;
		}
	}

	return;
}

//******************************************************************************
// MIDICxgtB^
//******************************************************************************
int SMSequencer::_FilterMIDIEvent(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent,
		bool* pIsFiltered
	)
{
	int result = 0;
	unsigned char* pData = NULL;
	unsigned long shortMsg = 0;
	unsigned long size = 0;
	unsigned char chNo = 0;
	unsigned char ccNo = 0;
	unsigned char ccValue = 0;

	*pIsFiltered = false;

	//XLbv̂݃tB^
	if (!m_isSkipping) goto EXIT;

	chNo = pMIDIEvent->GetChNo();

	//m[gON/OFF͑MȂ
	if ((pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOff) ||
		(pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOn)) {
		*pIsFiltered = true;
	}

	//sb`xh͑MȂ
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::PitchBend) {
		*pIsFiltered = true;
		result = pMIDIEvent->GetMIDIOutShortMsg(&shortMsg);
		if (result != 0) goto EXIT;
		
		//sb`xh̒lLFEn dl dm 2,3oCgڂQ
		pData = (unsigned char*)(&shortMsg);
		m_CachePitchBend[portNo][chNo][0] = pData[1];
		m_CachePitchBend[portNo][chNo][1] = pData[2];
	}

	//Rg[`FẄꕔ͑MȂ
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::ControlChange) {
		ccNo = pMIDIEvent->GetCCNo();
		ccValue = pMIDIEvent->GetCCValue();

		//CC#1 W[V
		if (ccNo == 1) {
			*pIsFiltered = true;
			m_CacheCC001_Modulation[portNo][chNo] = ccValue;
		}
		//CC#7 {[
		else if (ccNo == 7) {
			*pIsFiltered = true;
			m_CacheCC007_Volume[portNo][chNo] = ccValue;
		}
		//CC#10 p|bg
		else if (ccNo == 10) {
			*pIsFiltered = true;
			m_CacheCC010_Panpot[portNo][chNo] = ccValue;
		}
		//CC#11 GNXvbV
		else if (ccNo == 11) {
			*pIsFiltered = true;
			m_CacheCC011_Expression[portNo][chNo] = ccValue;
		}
		//CC#121 ZbgI[Rg[
		else if (ccNo = 121) {
			//NAΏۃp[^̃LbVj
			m_CachePitchBend[portNo][chNo][0] = 0xFF;
			m_CachePitchBend[portNo][chNo][1] = 0xFF;
			m_CacheCC001_Modulation[portNo][chNo] = 0xFF;
			//ΏۊO m_CacheCC007_Volume[portNo][chNo] = 0xFF;
			//ΏۊO m_CacheCC010_Panpot[portNo][chNo] = 0xFF;
			m_CacheCC011_Expression[portNo][chNo] = 0xFF;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgLbVM
//******************************************************************************
int SMSequencer::_SendMIDIEventCache()
{
	int result = 0;
	unsigned long index = 0;
	unsigned char portNo = 0;
	unsigned char chNo = 0;
	unsigned char pitchBend[2];
	unsigned char ccValue = 0;

	for (index = 0; index < SM_MAX_PORT_NUM; index++) {
		portNo = (unsigned char)index;
		for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
			//sb`xh
			pitchBend[0] = m_CachePitchBend[portNo][chNo][0];
			pitchBend[1] = m_CachePitchBend[portNo][chNo][1];
			if (pitchBend[0] < 0xFF) {
				result = _SendMIDIEventPitchBend(portNo, chNo, pitchBend);
				if (result != 0) goto EXIT;
			}
			//CC#1 W[V
			ccValue = m_CacheCC001_Modulation[portNo][chNo];
			if (ccValue < 0x80) {
				result = _SendMIDIEventCC(portNo, chNo, 1, ccValue);
				if (result != 0) goto EXIT;
			}
			//CC#7 {[
			ccValue = m_CacheCC007_Volume[portNo][chNo];
			if (ccValue < 0x80) {
				result = _SendMIDIEventCC(portNo, chNo, 7, ccValue);
				if (result != 0) goto EXIT;
			}
			//CC#10 p|bg
			ccValue = m_CacheCC010_Panpot[portNo][chNo];
			if (ccValue < 0x80) {
				result = _SendMIDIEventCC(portNo, chNo, 10, ccValue);
				if (result != 0) goto EXIT;
			}
			//CC#11 GNXvbV
			ccValue = m_CacheCC011_Expression[portNo][chNo];
			if (ccValue < 0x80) {
				result = _SendMIDIEventCC(portNo, chNo, 11, ccValue);
				if (result != 0) goto EXIT;
			}
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgLbVMFsb`xh
//******************************************************************************
int SMSequencer::_SendMIDIEventPitchBend(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char* pPtichBend
	)
{
	int result = 0;
	SMEvent event;
	SMEventMIDI eventMIDI;

	//MIDICxgf[^쐬
	event.SetMIDIData(0xE0 | chNo, pPtichBend, 2);
	eventMIDI.Attach(&event);

	//MIDICxgM
	result = _SendMIDIEvent(portNo, &eventMIDI);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgLbVMFRg[`FW
//******************************************************************************
int SMSequencer::_SendMIDIEventCC(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char ccNo,
		unsigned char ccValue
	)
{
	int result = 0;
	unsigned char data[2];
	SMEvent event;
	SMEventMIDI eventMIDI;

	//MIDICxgf[^쐬
	data[0] = ccNo;
	data[1] = ccValue;
	event.SetMIDIData(0xB0 | chNo, data, 2);
	eventMIDI.Attach(&event);

	//MIDICxgM
	result = _SendMIDIEvent(portNo, &eventMIDI);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// XLbv
//******************************************************************************
int SMSequencer::_ProcSkip(
		unsigned long long targetTimeInNanoSec,
		BOOL* pIsContinue
	)
{
	int result = 0;
	unsigned long long startPlayTime = 0;
	unsigned long startTickTime = 0;
	unsigned long endTickTime = 0;

	if (m_Status != StatusPlay) goto EXIT;

	startPlayTime = m_CurPlayTime;
	startTickTime = m_TotalTickTimeTemp;

	//XLbv̏ꍇ
	if (targetTimeInNanoSec < m_CurPlayTime) {
		//ĐJnp[^
		result = _InitializeParamsOnPlayStart();
		if (result != 0) goto EXIT;
		
		m_MsgTrans.PostSkipStart(SM_SKIP_BACK);
	}
	//OXLbv̏ꍇ
	else {
		m_MsgTrans.PostSkipStart(SM_SKIP_FORWARD);
	}

	//MIDICxgLbVNA
	_ClearMIDIEventCache();

	//w莞܂MIDICxg
	m_isSkipping = true;
	while (*pIsContinue) {
		//XbhC^[o
		result = _IntervalProc(pIsContinue);
		if (result != 0) goto EXIT;
		
		//w莞ɒBXLbvIƂ
		if (targetTimeInNanoSec <= m_CurPlayTime) break;
	}
	m_isSkipping = false;

	//LbVM
	result = _SendMIDIEventCache();
	if (result != 0) goto EXIT;

	//Đړ
	endTickTime = m_TotalTickTimeTemp;
	_SlidePlaybackTime(startPlayTime, startTickTime, endTickTime);

	//XLbvړ̏Ԃʒm
	m_MsgTrans.PostPlayTime((unsigned long)(m_CurPlayTime/1000000), endTickTime);
	m_MsgTrans.PostTempo(m_Tempo);
	m_MsgTrans.PostBeat((unsigned short)m_BeatNumerator, (unsigned short)m_BeatDenominator);
	m_MsgTrans.PostBar(m_CurBarNo);

	//ĐJnXV
	m_PrevTimerTime = _GetCurTimeInNano();

	//XLbvI
	m_MsgTrans.PostSkipEnd(m_NotesCount);

	//OXLbvɂĐI
	if (!(*pIsContinue)) {
		_AllTrackNoteOff();
		m_MsgTrans.PostPlayTime((unsigned long)(m_CurPlayTime/1000000), m_TotalTickTime);
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
		m_Status = StatusStop;
	}

EXIT:;
	return result;
}

//******************************************************************************
// Đړ
//******************************************************************************
void SMSequencer::_SlidePlaybackTime(
		unsigned long long startPlayTime,
		unsigned long startTickTime,
		unsigned long endTickTime
	)
{
	unsigned long i = 0;
	unsigned long tickTime = 0;
	unsigned long tickTimeStep = 0;
	unsigned long waitTimeInMsec = 10;  //10msec.Ƃɒʒm
	unsigned long stepNum = 0;
	bool isRewind = false;

	//Đʒm
	stepNum = m_MovingTimeSpanInMsec / waitTimeInMsec;

	//`bN^Cݒl
	if (startTickTime > endTickTime) {
		isRewind = true;
		tickTimeStep = (startTickTime - endTickTime) / stepNum;
	}
	else {
		isRewind = false;
		tickTimeStep = (endTickTime - startTickTime) / stepNum;
	}

	//Đړ
	tickTime = startTickTime;
	for (i = 0; i < stepNum; i ++) {
		//ĐʒmF`bN^ĈݍXV
		if (isRewind) {
			tickTime -= tickTimeStep;
		}
		else {
			tickTime += tickTimeStep;
		}
		m_MsgTrans.PostPlayTime((unsigned long)(startPlayTime/1000000), tickTime);
		
		//ҋ@
		Sleep(waitTimeInMsec);
	}

	return;
}

//******************************************************************************
// ^C}[Ăяo
//******************************************************************************
int SMSequencer::_OnTimer()
{
	int result = 0;
	BOOL isContinue = true;

	unsigned long deltaTime = 0;

	//_Zx{xɐݒ
	//  ^C}[Jn1񂾂s
	if (!(m_FPUCtrl.IsLocked())) {
		result = m_FPUCtrl.Start(SMFPUCtrl::FPUDouble);
		if (result != 0) goto EXIT;
	}

	//XbhC^[o
	result = _IntervalProc(&isContinue);
	if (result != 0) goto EXIT;

	//[UNGXg̏
	if (isContinue) {
		result = _ProcUserRequest(&isContinue);
		if (result != 0) goto EXIT;
	}

	if (!isContinue) {
		timeKillEvent(m_TimerID);
		m_TimerID = NULL;
		m_FPUCtrl.End();
	}

EXIT:;
	return result;
}

//******************************************************************************
// ^C}[R[obN֐
//******************************************************************************
void SMSequencer::_TimerCallBack(
		UINT uTimerID,
		UINT uMsg,
		DWORD_PTR dwUser,
		DWORD_PTR dw1,
		DWORD_PTR dw2
	)
{
	int result = 0;

	SMSequencer* pSequencer = (SMSequencer*)dwUser;
	if (pSequencer == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	result = pSequencer->_OnTimer();
	if (result != 0) goto EXIT;

EXIT:;
	if (result != 0) YN_SHOW_ERR(NULL);
	return;
}

} // end of namespace

