//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrl
//
// sAmL[{[hNX
//
// Copyright (C) 2010-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ̃sAmL[{[hǗNXB
// eL[{[h̔zuƃL[̉Ԃ𐧌䂷B
// 1|[g(16ch)̕`݂̂ɑΉĂB
// 2|[gڈȍ~̕`ɂ͑ΉĂȂB

#pragma once

#include "SMIDILib.h"
#include "MTPianoKeyboard.h"
#include "MTPianoKeyboardDesign.h"
#include "MTNotePitchBend.h"
#include "MTNoteDesign.h"

using namespace SMIDILib;


//******************************************************************************
// sAmL[{[hNX
//******************************************************************************
class MTPianoKeyboardCtrl
{
public:

	//RXgN^^fXgN^
	MTPianoKeyboardCtrl(void);
	virtual ~MTPianoKeyboardCtrl(void);

	//
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend,
			bool isSingleKeyboard
		);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//tԐݒ
	void SetPlayTimeMSec(unsigned long playTimeMsec);

	//Zbg
	void Reset();

	//\ݒ
	void SetEnable(bool isEnable);

	//XLbv
	void SetSkipStatus(bool isSkipping);

private:

	//L[
	enum KeyStatus {
		BeforeNoteON,
		NoteON,
		AfterNoteOFF
	};

	//m[g\
	struct NoteStatus {
		bool isActive;
		KeyStatus keyStatus;
		unsigned long index;
		float keyDownRate;
	};

private:

	//m[gfUC
	MTNoteDesign m_NoteDesign;

	//L[{[h`IuWFNgF|C^z
	MTPianoKeyboard* m_pPianoKeyboard[SM_MAX_CH_NUM];

	//L[{[hfUC
	MTPianoKeyboardDesign m_KeyboardDesign;

	//m[gXg
	SMNoteList m_NoteListRT;

	//m[gǗ
	unsigned long m_PlayTimeMSec;
	unsigned long m_CurTickTime;
	unsigned long m_CurNoteIndex;
	NoteStatus* m_pNoteStatus;
	float m_KeyDownRate[SM_MAX_CH_NUM][SM_MAX_NOTE_NUM];

	//XLbv
	bool m_isSkipping;

	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;

	//\
	bool m_isEnable;

	//VOL[{[htO
	bool m_isSingleKeyboard;

	int _CreateNoteStatus();
	int _CreateKeyboards(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

	int _TransformActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateStatusOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateNoteStatus(
				unsigned long playTimeMSec,
				unsigned long keyDownDuration,
				unsigned long keyUpDuration,
				SMNote note,
				NoteStatus* pNoteStatus
			);
	int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	float _GetPichBendShiftPosX(unsigned char portNo, unsigned char chNo);

};


