//******************************************************************************
//
// MIDITrail / MTSettingBGIMGViewCtrl
//
// 背景画像選択ビュークラス
//
// Copyright (C) 2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTParam.h"
#import "MTSettingBGIMGViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTSettingBGIMGViewCtrl ()

//ファイル一覧生成
- (int)makeFileList;

//テーブルセル作成：ファイル
- (UITableViewCell*)makeFileCellForIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント：ファイル一覧
- (void)onSelectFileCellForIndexPath:(NSIndexPath*)indexPath tableView:(UITableView*)tableView;

@end


@implementation MTSettingBGIMGViewCtrl

//******************************************************************************
// 初期化
//******************************************************************************
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
	int result = 0;
	
	self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
	if (self) {
		//ビュー設定
		self.title = @"Background Image";
		
		//ユーザ設定初期化
		m_pUserConf = [[YNUserConf alloc] init];
		if (m_pUserConf == nil) {
			result = YN_SET_ERR(@"Program error.", 0, 0);
			goto EXIT;
		}
		
		//背景画像の設定を取得
		[m_pUserConf setCategory:MT_CONF_CATEGORY_GRAPHIC];
		[m_pUserConf setSection:MT_CONF_SECTION_BGIMG];
		m_pImageFileName = [m_pUserConf strValueForKey:@"ImageFileName" defaultValue:@""];
		
		//ファイル一覧生成
		[self makeFileList];
	}
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return self;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	return;
}

//******************************************************************************
// ビュー解除完了
//******************************************************************************
//  iOS6で廃止
//- (void)viewDidUnload
//{
//    [super viewDidUnload];
//    // Release any retained subviews of the main view.
//
//	return;
//}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{	
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// ファイル一覧生成
//******************************************************************************
- (int)makeFileList
{
	int result = 0;
	int i = 0;
	NSArray* pPathList = nil;
	NSString* pDocDirPath = nil;
	NSString* pPath = nil;
	NSString* pFile = nil;
	NSArray* pFileArrayTmp = nil;
	NSMutableArray* pFileArray = nil;
	BOOL isDir = NO;
	
	pFileArray = [[NSMutableArray alloc] init];
	
	//Documentsディレクトリパスを取得
	pPathList = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	pDocDirPath = [pPathList objectAtIndex:0];
	
	//ディレクトリ配下のファイル一覧を取得
	pFileArrayTmp = [[NSFileManager defaultManager] contentsOfDirectoryAtPath:pDocDirPath error:nil];
	
	//画像ファイル一覧を作成（ディレクトリは除外する）
	for (i = 0; i < [pFileArrayTmp count]; i++) {
		pFile = [pFileArrayTmp objectAtIndex:i];
		pPath = [pDocDirPath stringByAppendingPathComponent:pFile];
		[[NSFileManager defaultManager] fileExistsAtPath:pPath isDirectory:&isDir];
		if (!isDir) {
			if (([[pPath pathExtension] caseInsensitiveCompare:@"jpg"] == NSOrderedSame) ||
			    ([[pPath pathExtension] caseInsensitiveCompare:@"png"] == NSOrderedSame)) {
				//画像ファイル一覧に追加
				[pFileArray addObject:pFile];
			}
		}
	}
	
	//ファイル名ソート：大文字小文字を区別しない
	m_pFileArray = [pFileArray sortedArrayUsingComparator:^(id str1, id str2) {
		return [((NSString*)str1) compare:((NSString*)str2) options:NSCaseInsensitiveSearch]; }];
	[m_pFileArray retain];
	
	if ([m_pFileArray count] == 0) {
		m_pTableView.allowsSelection = NO;
	}
	
	[pFileArray release];
	return result;
}

//******************************************************************************
// セクション数
//******************************************************************************
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView
{
    return 1;
} 

//******************************************************************************
// セクションヘッダ
//******************************************************************************
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section
{
    return nil;
} 

//******************************************************************************
// セクションごとの項目数
//******************************************************************************
- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
	NSInteger numOfRows = 0;
	
	switch (section) {
		case 0:
			//ファイル一覧
			numOfRows = [m_pFileArray count];
			
			//ファイルなしの場合はメッセージを表示
			if (numOfRows == 0) {
				numOfRows = 1;
			}
			//ファイルありの場合はnoneを項目に追加
			else {
				numOfRows += 1;
			}
			break;
		default:
			break;
	}
	
	return numOfRows;
}

//******************************************************************************
// 項目表示内容
//******************************************************************************
- (UITableViewCell*)tableView:(UITableView*)tableView
		cellForRowAtIndexPath:(NSIndexPath*)indexPath
{
	UITableViewCell* pCell = nil;
	
	switch (indexPath.section) {
		case 0:
			//ファイル一覧
			pCell = [self makeFileCellForIndexPath:indexPath];
			break;
		default:
			break;
	}
	
	return pCell;
}

//******************************************************************************
// テーブルセル作成：ファイル
//******************************************************************************
- (UITableViewCell*)makeFileCellForIndexPath:(NSIndexPath*)indexPath
{
	static NSString* pCellIdentifier = @"MTSettingBGIMGViewCtrl";
	UITableViewCell* pCell = nil;
    bool isCheckmark = false;
	
	//再利用可能セル生成
	pCell = [m_pTableView dequeueReusableCellWithIdentifier:pCellIdentifier];
	if (pCell == nil) {
		pCell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle
									   reuseIdentifier:pCellIdentifier];
	}
	
	//ラベル設定
	if ([m_pFileArray count] == 0) {
		//ファイルなしの場合はメッセージを表示
		pCell.textLabel.text = @"Image file not found.";
		pCell.detailTextLabel.text = @"You can import your Image files through iTunes File Sharing.";
		pCell.detailTextLabel.numberOfLines = 0;
	}
	else {
		//ファイルありの場合
		if (indexPath.row == 0) {
			//先頭にnoneを表示
			pCell.textLabel.text = @"(none)";
            if ([m_pImageFileName length] == 0) {
                isCheckmark = true;
            }
		}
		else {
			//ファイル名を表示
			pCell.textLabel.text = [m_pFileArray objectAtIndex:(indexPath.row - 1)];
            if ([pCell.textLabel.text isEqualToString:m_pImageFileName]) {
                isCheckmark = true;
            }
		}
		
		//チェックマーク設定
        pCell.accessoryType = UITableViewCellAccessoryNone;
		if (isCheckmark) {
			pCell.accessoryType = UITableViewCellAccessoryCheckmark;
		}
	}
	
	return pCell;
}

//******************************************************************************
// テーブルセル選択イベント
//******************************************************************************
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath
{
	//選択状態解除
	[tableView deselectRowAtIndexPath:indexPath animated:YES];
	
	switch (indexPath.section) {
		case 0:
			//ファイル一覧
			[self onSelectFileCellForIndexPath:indexPath tableView:tableView];
			break;
		default:
			break;
	}
	
	return;
}

//******************************************************************************
// テーブルセル選択イベント：ファイル一覧
//******************************************************************************
- (void)onSelectFileCellForIndexPath:(NSIndexPath*)indexPath tableView:(UITableView *)tableView
{
	//NSLog(@"selected %d", indexPath.row);
	
	//ファイルなしの場合は何もしない
	if ([m_pFileArray count] == 0) goto EXIT;
	
	if (indexPath.row == 0) {
		m_pImageFileName = @"";
	}
	else {
		m_pImageFileName = [m_pFileArray objectAtIndex:(indexPath.row - 1)];
	}
	
	//選択されたエンコーディング名称を保存
	[m_pUserConf setCategory:MT_CONF_CATEGORY_GRAPHIC];
	[m_pUserConf setSection:MT_CONF_SECTION_BGIMG];
	[m_pUserConf setStr:m_pImageFileName forKey:@"ImageFileName"];
	
	//再表示
	[tableView performSelector:@selector(reloadData) withObject:nil afterDelay:0.1f];
	
	//1階層戻る
	//[self.navigationController popViewControllerAnimated:YES];
	
EXIT:;
	return;
}


@end

