//******************************************************************************
//
// Simple MIDI Library / SMNetworkSession
//
// ネットワークセッションクラス
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "SMNetworkSession.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
SMNetworkSession::SMNetworkSession()
{
	m_pNetworkSession = nil;
}

//******************************************************************************
// デストラクタ
//******************************************************************************
SMNetworkSession::~SMNetworkSession()
{
	[m_pNetworkSession release];
}

//******************************************************************************
// 初期化
//******************************************************************************
int SMNetworkSession::Initialize()
{
	int result = 0;
	
	m_pNetworkSession = [MIDINetworkSession defaultSession];
	m_pNetworkSession.connectionPolicy = MIDINetworkConnectionPolicy_Anyone;
	
	return result;
}

//******************************************************************************
// 有効化
//******************************************************************************
void SMNetworkSession::Enable()
{
	m_pNetworkSession.enabled = YES;
}

//******************************************************************************
// 無効化
//******************************************************************************
void SMNetworkSession::Disable()
{
	m_pNetworkSession.enabled = NO;
}

