//******************************************************************************
//
// Simple MIDI Library / SMBarList
//
// 小節リストクラス
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "SMSimpleList.h"


//******************************************************************************
// 小節リストクラス
//******************************************************************************
class SMBarList
{
public:
	
	//コンストラクタ／デストラクタ
	SMBarList(void);
	virtual ~SMBarList(void);
	
	//クリア
	void Clear();
	
	//小節追加
	int AddBar(unsigned int tickTime);
	
	//小節取得
	int GetBar(unsigned int index, unsigned int* pTickTime);
	
	//小節数取得
	unsigned int GetSize();
	
	//コピー
	int CopyFrom(SMBarList* pSrcList);
	
private:
	
	SMSimpleList m_List;
	
	//代入とコピーコンストラクタの禁止
	void operator=(const SMBarList&);
	SMBarList(const SMBarList&);

};


