//******************************************************************************
//
// Simple MIDI Library / SMBarList
//
// 小節リストクラス
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "SMBarList.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
SMBarList::SMBarList(void)
 : m_List(sizeof(unsigned int), 100)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
SMBarList::~SMBarList(void)
{
	Clear();
}

//******************************************************************************
// クリア
//******************************************************************************
void SMBarList::Clear(void)
{
	m_List.Clear();
}

//******************************************************************************
// 小節情報追加
//******************************************************************************
int SMBarList::AddBar(
		unsigned int tickTime
	)
{
	return m_List.AddItem(&tickTime);
}

//******************************************************************************
// 小節情報取得
//******************************************************************************
int SMBarList::GetBar(
		unsigned int index,
		unsigned int* pTickTime
	)
{
	return m_List.GetItem(index, pTickTime);
}

//******************************************************************************
// 小節数取得
//******************************************************************************
unsigned int SMBarList::GetSize()
{
	return m_List.GetSize();
}

//******************************************************************************
// リストコピー
//******************************************************************************
int SMBarList::CopyFrom(
		SMBarList* pSrcList
	)
{
	return m_List.CopyFrom(&(pSrcList->m_List));
}


