//******************************************************************************
//
// MIDITrail / DXCamera
//
// JNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>


//******************************************************************************
// JNX
//******************************************************************************
class DXCamera
{
public:

	//RXgN^^fXgN^
	DXCamera(void);
	virtual ~DXCamera(void);

	//
	int Initialize();

	//{p[^ݒ
	void SetBaseParam(
			float viewAngle,
			float nearPlane,
			float farPlane
		);

	//Jʒuݒ
	void SetPosition(
			D3DXVECTOR3 camVector,
			D3DXVECTOR3 camLookAtVector,
			D3DXVECTOR3 camUpVector
		);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

private:

	//J̉p
	float m_ViewAngle;

	//Nearv[F0Z䂪Ȃ
	float m_NearPlane;

	//Farv[
	float m_FarPlane;

	//Jʒu
	D3DXVECTOR3 m_CamVector;

	//ړ_
	D3DXVECTOR3 m_CamLookAtVector;

	//J̏
	D3DXVECTOR3 m_CamUpVector;

	void _Clear();

	int _GetProjMatrix(
			LPDIRECT3DDEVICE9 pD3DDevice,
			D3DXMATRIX* pViewMatrix
		);
	int _GetViewMatrix(
			D3DXMATRIX* pViewMatrix
		);

};

