//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrlLive
//
// Cuj^psAmL[{[hNX
//
// Copyright (C) 2012-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTPianoKeyboard.h"
#include "MTPianoKeyboardCtrlLive.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTPianoKeyboardCtrlLive::MTPianoKeyboardCtrlLive(void)
{
	unsigned char chNo = 0;
	
	//L[{[hIuWFNgz񏉊
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		m_pPianoKeyboard[chNo] = NULL;
	}
	
	//m[gz񏉊
	_ClearNoteStatus();
	
	m_isEnable = true;
	m_isSingleKeyboard = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTPianoKeyboardCtrlLive::~MTPianoKeyboardCtrlLive(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTPianoKeyboardCtrlLive::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		MTNotePitchBend* pNotePitchBend,
		bool isSingleKeyboard
	)
{
	int result = 0;
	
	Release();
	
	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, NULL);
	if (result != 0) goto EXIT;
	
	//L[{[hfUC
	result = m_KeyboardDesign.Initialize(pSceneName, NULL);
	if (result != 0) goto EXIT;
	
	//m[gz񏉊
	_ClearNoteStatus();
	
	//L[{[h
	result = _CreateKeyboards(pD3DDevice, pSceneName);
	if (result != 0) goto EXIT;
	
	//sb`xh
	m_pNotePitchBend = pNotePitchBend;
	
	//VOL[{[htO
	m_isSingleKeyboard = isSingleKeyboard;
	
EXIT:;
	return result;
}

//******************************************************************************
// m[gz񏉊
//******************************************************************************
void MTPianoKeyboardCtrlLive::_ClearNoteStatus()
{
	unsigned long chNo = 0;
	unsigned long noteNo = 0;
	
	//m[gԃXg
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		for (noteNo = 0; noteNo < SM_MAX_NOTE_NUM; noteNo++) {
			m_NoteStatus[chNo][noteNo].isActive = false;
			m_NoteStatus[chNo][noteNo].startTime = 0;
			m_NoteStatus[chNo][noteNo].endTime = 0;
			m_NoteStatus[chNo][noteNo].keyDownRate = 0.0f;
		}
	}
	
	return;
}

//******************************************************************************
// L[{[h`IuWFNg
//******************************************************************************
int MTPianoKeyboardCtrlLive::_CreateKeyboards(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName
	)
{
	int result = 0;
	unsigned char chNo = 0;
	LPDIRECT3DTEXTURE9 pTexture = NULL;
	
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		try {
			m_pPianoKeyboard[chNo] = new MTPianoKeyboard;
		}
		catch (std::bad_alloc) {
			result = YN_SET_ERR("Could not allocate memory.", 0, 0);
			goto EXIT;
		}
		
		result = m_pPianoKeyboard[chNo]->Create(pD3DDevice, pSceneName, NULL, pTexture);
		if (result != 0) goto EXIT;
		
		//擪IuWFNgō쐬eNX`ėp
		pTexture = m_pPianoKeyboard[chNo]->GetTexture();
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTPianoKeyboardCtrlLive::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	unsigned char portNo = 0;
	unsigned char chNo = 0;
	D3DXVECTOR3 moveVector;
	
	//ݔm[g̒_XV
	result = _TransformActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//eL[{[ḧړ
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		
		//ړxNgFL[{[hW
		moveVector = m_KeyboardDesign.GetKeyboardBasePos(portNo, chNo);
		
		//ړxNgFsb`xhVtg𔽉f
		moveVector.x += _GetPichBendShiftPosX(portNo, chNo);
		
		//ړxNgFĐʂɒǏ]
		//moveVector.y += m_NoteDesign.GetPlayPosX(m_CurTickTime);
		
		//L[{[hړ
		result = m_pPianoKeyboard[chNo]->Transform(pD3DDevice, moveVector, rollAngle);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_
//******************************************************************************
int MTPianoKeyboardCtrlLive::_TransformActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	
	//m[g̏ԍXV
	result = _UpdateStatusOfActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//m[g̒_XV
	result = _UpdateVertexOfActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g̏ԍXV
//******************************************************************************
int MTPianoKeyboardCtrlLive::_UpdateStatusOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long chNo = 0;
	unsigned long noteNo = 0;
	unsigned long keyUpDuration = 0;
	unsigned long curTime = 0;
	unsigned long targetChNo = 0;
	
	curTime = timeGetTime();
	
	//L[㏸~(msec)
	keyUpDuration = m_KeyboardDesign.GetKeyUpDuration();
	
	//m[gXV
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		for (noteNo = 0; noteNo < SM_MAX_NOTE_NUM; noteNo++) {
			//m[gOFF̏ԂXV
			if ((m_NoteStatus[chNo][noteNo].isActive) && (m_NoteStatus[chNo][noteNo].endTime != 0)) {
				//m[gOFFL[Abv܂Ŋꍇ̓L[NA
				if ((curTime - m_NoteStatus[chNo][noteNo].endTime) > keyUpDuration) {
					m_NoteStatus[chNo][noteNo].isActive = false;
					m_NoteStatus[chNo][noteNo].startTime = 0;
					m_NoteStatus[chNo][noteNo].endTime = 0;
					m_NoteStatus[chNo][noteNo].keyDownRate = 0.0f;
					//VOL[{[hł͕`l̃L[Ԃ擪`lɏW񂷂
					targetChNo = chNo;
					if (m_isSingleKeyboard) {
						targetChNo = 0;
					}
					result = m_pPianoKeyboard[targetChNo]->ResetKey((unsigned char)noteNo);
					if (result != 0) goto EXIT;
				}
				//L[XV
				else {
					m_NoteStatus[chNo][noteNo].keyDownRate
						= 1.0f - ((float)(curTime - m_NoteStatus[chNo][noteNo].endTime) / (float)keyUpDuration);
				}
			}
		}
	}
		
EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_XV
//******************************************************************************
int MTPianoKeyboardCtrlLive::_UpdateVertexOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long portNo = 0;
	unsigned long chNo = 0;
	unsigned long noteNo = 0;
	unsigned long elapsedTime = 0;
	unsigned long curTime = 0;
	unsigned long targetChNo = 0;
	D3DXCOLOR noteColor;
	D3DXCOLOR* pActiveKeyColor = NULL;
	
	curTime = timeGetTime();
	
	//L[̏ԍXV
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		for (noteNo = 0; noteNo < SM_MAX_NOTE_NUM; noteNo++) {
			//łȂ΃XLbv
			if (!(m_NoteStatus[chNo][noteNo].isActive)) continue;
			
			//Jňoߎ
			elapsedTime = curTime - m_NoteStatus[chNo][noteNo].startTime;
			
			//VOL[{[hł͕`l̃L[Ԃ擪`lɏW񂷂
			targetChNo = chNo;
			if (m_isSingleKeyboard) {
				targetChNo = 0;
			}
			
			//m[g̐F
			noteColor = m_NoteDesign.GetNoteBoxColor((unsigned char)portNo, (unsigned char)chNo, (unsigned char)noteNo);
			pActiveKeyColor = &noteColor;
			
			//ΏۃL[]
			result = m_pPianoKeyboard[targetChNo]->PushKey(
								(unsigned char)noteNo,
								m_NoteStatus[chNo][noteNo].keyDownRate,
								elapsedTime,
								pActiveKeyColor
							);
			if (result != 0) goto EXIT;
		}
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTPianoKeyboardCtrlLive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	unsigned char chNo = 0;
	unsigned long count = 0;
	unsigned long dispNum = 0;
	
	if (!m_isEnable) goto EXIT;
	
	//L[{[hő\
	dispNum = SM_MAX_CH_NUM;
	if (m_KeyboardDesign.GetKeyboardMaxDispNum() < dispNum) {
		dispNum = m_KeyboardDesign.GetKeyboardMaxDispNum();
	}
	
	//L[{[h̕`
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		//L[{[h\̐mF
		count++;
		if (dispNum < count) break;
		
		//L[{[h`
		result = m_pPianoKeyboard[chNo]->Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// sb`xhfFL[{[hVtg
//******************************************************************************
float MTPianoKeyboardCtrlLive::_GetPichBendShiftPosX(
		unsigned char portNo,
		unsigned char chNo
	)
{
	float shift = 0.0f;
	short pitchBendValue = 0;
	unsigned char pitchBendSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;
	
	//`l̃sb`xh
	pitchBendValue =       m_pNotePitchBend->GetValue(portNo, chNo);
	pitchBendSensitivity = m_pNotePitchBend->GetSensitivity(portNo, chNo);
	
	//sb`xhɂL[{[hVtg
	shift = m_KeyboardDesign.GetPitchBendShift(pitchBendValue, pitchBendSensitivity);
	
	return shift;
}

//******************************************************************************
// 
//******************************************************************************
void MTPianoKeyboardCtrlLive::Release()
{
	unsigned char chNo = 0;
	
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		if (m_pPianoKeyboard[chNo] != NULL) {
			m_pPianoKeyboard[chNo]->Release();
			delete m_pPianoKeyboard[chNo];
			m_pPianoKeyboard[chNo] = NULL;
		}
	}
	
	return;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTPianoKeyboardCtrlLive::Reset()
{
	int result = 0;
	unsigned long chNo = 0;
	unsigned long noteNo = 0;
	
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		for (noteNo = 0; noteNo < SM_MAX_NOTE_NUM; noteNo++) {
			m_NoteStatus[chNo][noteNo].isActive = false;
			m_NoteStatus[chNo][noteNo].startTime = 0;
			m_NoteStatus[chNo][noteNo].endTime = 0;
			m_NoteStatus[chNo][noteNo].keyDownRate = 0.0f;
			result = m_pPianoKeyboard[chNo]->ResetKey((unsigned char)noteNo);
			if (result != 0) goto EXIT;
		}
	}

EXIT:;
	return;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTPianoKeyboardCtrlLive::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTPianoKeyboardCtrlLive::SetNoteOn(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		unsigned char velocity
	)
{
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//m[go^
	m_NoteStatus[chNo][noteNo].isActive = true;
	m_NoteStatus[chNo][noteNo].startTime = curTime;
	m_NoteStatus[chNo][noteNo].endTime = 0;
	m_NoteStatus[chNo][noteNo].keyDownRate = 1.0f;
	
	return;
}

//******************************************************************************
// m[gOFFo^
//******************************************************************************
void MTPianoKeyboardCtrlLive::SetNoteOff(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo
	)
{
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//m[gXV
	m_NoteStatus[chNo][noteNo].endTime = curTime;
	
	return;
}

//******************************************************************************
// Sm[gOFF
//******************************************************************************
void MTPianoKeyboardCtrlLive::AllNoteOff()
{
	unsigned long chNo = 0;
	unsigned long noteNo = 0;
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//m[gOFFݒ肳ĂȂm[gɏIݒ
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		for (noteNo = 0; noteNo < SM_MAX_NOTE_NUM; noteNo++) {
			if ((m_NoteStatus[chNo][noteNo].isActive)
				&& (m_NoteStatus[chNo][noteNo].endTime == 0)) {
					m_NoteStatus[chNo][noteNo].endTime = curTime;
			}
		}
	}
	
	return;
}

//******************************************************************************
// Sm[gOFFi`lwj
//******************************************************************************
void MTPianoKeyboardCtrlLive::AllNoteOffOnCh(
		unsigned char portNo,
		unsigned char chNo
	)
{
	unsigned long noteNo = 0;
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//w`lŃm[gOFFݒ肳ĂȂm[gɏIݒ
	for (noteNo = 0; noteNo < SM_MAX_NOTE_NUM; noteNo++) {
		if ((m_NoteStatus[chNo][noteNo].isActive)
			&& (m_NoteStatus[chNo][noteNo].endTime == 0)) {
				m_NoteStatus[chNo][noteNo].endTime = curTime;
		}
	}
	
	return;
}


