//******************************************************************************
//
// MIDITrail / MTHowToViewCtrl
//
// HowToビュー制御クラス
//
// Copyright (C) 2012-2020 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTHowToViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTHowToViewCtrl ()

@end


@implementation MTHowToViewCtrl

//******************************************************************************
// 生成
//******************************************************************************
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{	
	NSString* pFileName = nil;
	NSString* pHtmlPath = nil;
	WKWebViewConfiguration* pWebConfiguration = nil;
	
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	//Webビュー設定
	pWebConfiguration = [[WKWebViewConfiguration alloc] init];
	if (@available(iOS 10.0, *)) {
		pWebConfiguration.dataDetectorTypes = WKDataDetectorTypeNone; //データ検出なし（iOS 10以降で有効）
	}
	
	//Webビュー生成
	m_pWebView = [[WKWebView alloc] initWithFrame:m_pBaseView.frame configuration:pWebConfiguration];
	
	//Webビューをベースビューに貼り付ける
	m_pWebView.translatesAutoresizingMaskIntoConstraints = NO;
	[m_pBaseView addSubview:m_pWebView];
	
	//デリゲート設定：現状使用しない
	//m_pWebView.navigationDelegate = self;
	//m_pWebView.UIDelegate = self;
	
	//HTMLファイル名
	if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
		//iPhone / iPod touch
		pFileName = @"doc/HowToView-iPhone.html";
	}
	else {
		//iPad
		pFileName = @"doc/HowToView-iPad.html";
	}
	
	//HTMLファイルパス生成
	pHtmlPath = [NSString stringWithFormat:@"%@/%@", [YNPathUtil resourceDirPath], pFileName];
	
	//HTMLファイル表示
	[m_pWebView loadRequest:[NSURLRequest requestWithURL:[NSURL fileURLWithPath:pHtmlPath]]];
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	BOOL isRotate = NO;
	
	if ((interfaceOrientation == UIInterfaceOrientationLandscapeLeft)
		|| (interfaceOrientation == UIInterfaceOrientationLandscapeRight)) {
		isRotate = YES;
	}
	
	return isRotate;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//横長のみに対応する
	return UIInterfaceOrientationMaskLandscape;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// 完了ボタン押下
//******************************************************************************
- (IBAction)onDoneButton
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//******************************************************************************
// レイアウト処理終了
//******************************************************************************
- (void)viewDidLayoutSubviews
{
	CGRect baseViewFrame;
	CGRect webViewFrame;
	
	baseViewFrame = m_pBaseView.frame;
	webViewFrame = CGRectMake(0, 0, baseViewFrame.size.width, baseViewFrame.size.height);
	m_pWebView.frame = webViewFrame;

	return;
}

@end

