//******************************************************************************
//
// MIDITrail / MTScenePianoRoll2D
//
// ピアノロール2Dシーン描画クラス
//
// Copyright (C) 2010-2020 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTScenePianoRoll2D.h"


//******************************************************************************
// コンストラクタ
//******************************************************************************
MTScenePianoRoll2D::MTScenePianoRoll2D(void)
{
}

//******************************************************************************
// デストラクタ
//******************************************************************************
MTScenePianoRoll2D::~MTScenePianoRoll2D(void)
{
}

//******************************************************************************
// 名称取得
//******************************************************************************
NSString* MTScenePianoRoll2D::GetName()
{
	return @"PianoRoll2D";
}

//******************************************************************************
// シーン生成
//******************************************************************************
int MTScenePianoRoll2D::Create(
		UIView* pView,
		CGRect viewBounds,
		OGLDevice* pOGLDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	
	//ピアノロール2Dはライトなし
	//  ノートボックスの幅をゼロにするので表と裏が同一平面状で重なる
	//  ライトを有効にすると表と裏の色が異なりZファイティングを誘発する
	m_IsEnableLight = false;
	
	result = MTScenePianoRoll3D::Create(pView, viewBounds, pOGLDevice, pSeqData);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}


