//******************************************************************************
//
// MIDITrail / MTSettingNoteLengthViewCtrl
//
// 四分音符長拡大率設定ビュークラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTParam.h"
#import "MTSettingNoteLengthViewCtrl.h"


//******************************************************************************
// プライベートメソッド定義
//******************************************************************************
@interface MTSettingNoteLengthViewCtrl ()

// 拡大率リスト初期化
- (void)initMagArray;

@end


@implementation MTSettingNoteLengthViewCtrl

//******************************************************************************
// 初期化
//******************************************************************************
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
	int result = 0;
	
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
		//ビュー設定
		self.title = @"Quater Note Length";
		
		//四分音符長拡大率リスト初期化
		[self initMagArray];
		
		//ユーザ設定初期化
		m_pUserConf = [[YNUserConf alloc] init];
		if (m_pUserConf == nil) {
			result = YN_SET_ERR(@"Program error.", 0, 0);
			goto EXIT;
		}
		[m_pUserConf setCategory:MT_CONF_CATEGORY_GRAPHIC];
		[m_pUserConf setSection:MT_CONF_SECTION_QNOTE];
		
		//四分音符設定
		m_QuarterNoteLengthMag = [m_pUserConf intValueForKey:@"LengthMagnification" defaultValue:100];
    }
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
    return self;
}

//******************************************************************************
// ビュー登録完了
//******************************************************************************
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
	
	return;
}

//******************************************************************************
// インターフェース自動回転確認
//******************************************************************************
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

//******************************************************************************
// インターフェース自動回転確認（iOS6以降）
//******************************************************************************
- (BOOL)shouldAutorotate
{
	//回転を許可する
	return YES;
}

//******************************************************************************
// インターフェース自動回転確認：回転方向（iOS6以降）
//******************************************************************************
- (NSUInteger)supportedInterfaceOrientations
{
	//全方向に対応する
	return UIInterfaceOrientationMaskAll;
}

//******************************************************************************
// ビュー表示
//******************************************************************************
- (void)viewWillAppear:(BOOL)animated
{	
	return;
}

//******************************************************************************
// ビュー非表示
//******************************************************************************
- (void)viewWillDisappear:(BOOL)animated
{
	return;
}

//******************************************************************************
// セクション数
//******************************************************************************
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView
{
    return 1;
} 

//******************************************************************************
// セクションヘッダ
//******************************************************************************
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section
{
    return nil;
} 

//******************************************************************************
// セクションごとの項目数
//******************************************************************************
- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
	NSInteger numOfRows = 0;
	
	switch (section) {
		case 0:
			//ビューモード
			numOfRows = [m_pMagArray count];
			break;
		default:
			break;
	}
	
	return numOfRows;
}

//******************************************************************************
// 項目表示内容
//******************************************************************************
- (UITableViewCell*)tableView:(UITableView*)tableView
		cellForRowAtIndexPath:(NSIndexPath*)indexPath
{
    static NSString* pCellIdentifier = @"MTSettingEncodingViewCtrl";
	UITableViewCell* pCell = nil;
	int mag = 0;
	
	//再利用可能セル生成
	pCell = [m_pTableView dequeueReusableCellWithIdentifier:pCellIdentifier];
	if (pCell == nil) {
		pCell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
									   reuseIdentifier:pCellIdentifier];
	}
	
	//範囲外なら処理終了
	if ([m_pMagArray count] <= indexPath.row) goto EXIT;
	
	//ラベル設定
	mag = [[m_pMagArray objectAtIndex:indexPath.row] intValue];
	if (mag == 100) {
		pCell.textLabel.text = [NSString stringWithFormat:@"%d %% (default)", mag];
	}
	else {
		pCell.textLabel.text = [NSString stringWithFormat:@"%d %%", mag];
	}
	
	//チェックマーク設定
	pCell.accessoryType = UITableViewCellAccessoryNone;
	if (mag == m_QuarterNoteLengthMag) {
		pCell.accessoryType = UITableViewCellAccessoryCheckmark;
	}
	
EXIT:;
	return pCell;
}

//******************************************************************************
// テーブルセル選択イベント
//******************************************************************************
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath
{
	//選択状態解除
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
	
	//選択行の拡大率を取得
	m_QuarterNoteLengthMag = [[m_pMagArray objectAtIndex:indexPath.row] intValue];
	
	//選択された拡大率を保存
	[m_pUserConf setInt:m_QuarterNoteLengthMag forKey:@"LengthMagnification"];
	
	//再表示
	[tableView performSelector:@selector(reloadData) withObject:nil afterDelay:0.1f];
	
	//1階層戻る
	//[self.navigationController popViewControllerAnimated:YES];
	
	return;
}

//******************************************************************************
// 選択四分音符長拡大率取得
//******************************************************************************
- (int)selectedQuarterNoteLengthMag
{
	return m_QuarterNoteLengthMag;
}

//******************************************************************************
// 拡大率リスト初期化
//******************************************************************************
- (void)initMagArray
{
	int mag = 0;
	
	m_pMagArray = [[NSMutableArray alloc] init];
	
	for (mag = MT_QNOTE_LENGTH_MAG_MIN; mag <= MT_QNOTE_LENGTH_MAG_MAX; mag += MT_QNOTE_LENGTH_MAG_STEP) {
		[m_pMagArray addObject:[NSNumber numberWithInteger:mag]];
	}
	
	return;
}

@end

