//******************************************************************************
//
// MIDITrail / MTScene
//
// MIDITrail シーン基底クラス
//
// Copyright (C) 2010-2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <GameController/GameController.h>
#import "OGLUtil.h"
#import "SMIDILib.h"
#import "MTTouchCtrl.h"
#import <string>


//******************************************************************************
// パラメータ定義
//******************************************************************************
//マウスボタン種別
#define WM_LBUTTONDOWN  (0)
#define WM_RBUTTONDOWN  (1)
#define WM_MBUTTONDOWN  (2)

//******************************************************************************
// MIDITrail シーン基底クラス
//******************************************************************************
class MTScene : public OGLScene
{
public:
	
	enum EffectType {
		EffectPianoKeyboard,
		EffectRipple,
		EffectPitchBend,
		EffectStars,
		EffectCounter,
        EffectBackgroundImage,
		EffectFPS,
		EffectFileName
	};
	
	enum ScreenType {
		StandardView,
		VRViewSingleLens,
		VRViewDualLens
	};
	
	typedef std::map<std::string, float>  MTViewParamMap;
	typedef std::pair<std::string, float> MTViewParamMapPair;
	
public:
	
	//コンストラクタ／デストラクタ
	MTScene(void);
	virtual ~MTScene(void);
	
	//名称取得
	virtual NSString* GetName();
	
	//生成
	virtual int Create(
					UIView* pView,
					CGRect viewBounds,
					OGLDevice* pD3DDevice,
					SMSeqData* pSeqData
				);
	
	//変換
	virtual int Transform(OGLDevice* pD3DDevice, OGLScene::CameraType cameraType = CameraNormal);
	
	//描画
	virtual int Draw(OGLDevice* pD3DDevice, OGLScene::CameraType cameraType = CameraNormal);
	
	//破棄
	virtual void Release();
	
	//ウィンドウクリックイベント受信
	virtual int OnWindowClicked(
					unsigned int button,
					unsigned int wParam,
					unsigned int lParam
				);
	
	//マウスホイールイベント受信
	virtual int OnScrollWheel(
					float deltaWheelX,	//ホイール左右傾斜
					float deltaWheelY,	//ホイール回転
					float deltaWheelZ	//？
				);
	
	//演奏開始イベント受信
	virtual int OnPlayStart();
	
	//演奏終了イベント受信
	virtual int OnPlayEnd();
	
	//シーケンサメッセージ受信
	virtual int OnRecvSequencerMsg(
					unsigned int wParam,
					unsigned int lParam
				);
	
	//巻き戻し
	virtual int Rewind();
	
	//視点取得／登録
	virtual void GetDefaultViewParam(MTViewParamMap* pParamMap);
	virtual void GetViewParam(MTViewParamMap* pParamMap);
	virtual void SetViewParam(MTViewParamMap* pParamMap);
	
	//視点リセット／移動
	virtual void ResetViewpoint();
	virtual void MoveToStaticViewpoint(unsigned int viewpointNo);
	
	//表示効果設定
	virtual void SetEffect(EffectType type, bool isEnable);
	
	//アクティブ状態設定
	virtual void SetActiveState(bool isActive);
	
	//演奏速度設定
	virtual void SetPlaySpeedRatio(unsigned int ratio);
	
	//パラメータ登録／取得
	int SetParam(NSString* pKey, NSString* pValue);
	NSString* GetParam(NSString* pKey);
	
	//タッチイベント
	virtual void OnTouchesBegan(NSSet* pTouches);
	virtual void OnTouchesMoved(NSSet* pTouches);
	virtual void OnTouchesEnd(NSSet* pTouches);
	virtual void OnTouchesCanceled(NSSet* pTouches);
	
	//タッチ操作種別取得
	virtual MTTouchCtrl::OperationType GetCurOperationType();
	
    //スクリーンロック
    virtual void LockScreen(bool isLocked);
	
	//スクリーン種別
	virtual void SetScreenType(ScreenType type);
	
	//デバイス方向設定
	virtual void SetDeviceDirection(OGLQuaternion quaternion);
	
	//FSP設定
	virtual void SetFPS(float fps);
	
	//ゲームコントローラー更新
	virtual int OnGameControllerChanged();
	
protected:
	
	//ウィンドウアクティブ状態
	bool m_isActive;
	
	//シーンパラメータ
	NSMutableDictionary* m_pSceneParamDictionary;
	
};


