//******************************************************************************
//
// MIDITrail / MTSettingWavetableViewCtrl
//
// Wavetableファイル(DLS/SF2)選択ビュークラス
//
// Copyright (C) 2018-2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "YNBaseLib.h"
#import "MTFileEditViewCtrl.h"


//******************************************************************************
// Wavetableファイル(DLS/SF2)選択ビュー制御クラス
//******************************************************************************
@interface MTSettingWavetableViewCtrl : UIViewController <UIDocumentPickerDelegate> {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//対象ディレクトリパス
	NSString* m_pTargetDirPath;
	
	//サブパス一覧
	NSMutableArray* m_pSubPathArray;
	
	//選択ファイルインデックス
	NSInteger m_SelectedFileIndex;
	
	//選択ファイルサブパス
	NSString* m_pWavetableFileSubPath;
	
	//ユーザ設定
	YNUserConf* m_pUserConf;
	
	//ファイル編集ビュー制御
	MTFileEditViewCtrl* m_pFileEditViewCtrl;
	
	//リフレッシュ制御
	UIRefreshControl* m_pRefreshCtrl;
	
	//整理ボタン
	UIBarButtonItem* m_pOrganizeButton;
	
	//ファイル選択ビュー制御
	UIDocumentPickerViewController* m_pDocumentPickerViewCtrl;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択行ファイルパス取得
- (NSString*)selectedFilePath;

//編集開始終了通知
- (void)setEditing:(BOOL)editing animated:(BOOL)animated;

//行単位削除可否判定
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath;

//行削除イベント
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath;

//ファイル編集イベント
- (void)onEditFile:(NSNotification*)pNotification;

//ファイル一覧更新
- (int)updateFileList;

//整理ボタン押下イベント
-(void)onOrganizeButton:(id)sender;

//ファイル選択完了通知 iOS 11以降廃止
- (void)documentPicker:(UIDocumentPickerViewController*)pController didPickDocumentAtURL:(NSURL*)pUrl;

//ファイル選択完了通知 iOS 11以降
- (void)documentPicker:(UIDocumentPickerViewController*)pController didPickDocumentsAtURLs:(NSArray<NSURL*>*)pUrls;

//ファイル選択キャンセル通知
- (void)documentPickerWasCancelled:(UIDocumentPickerViewController*)pController;

@end

