//******************************************************************************
//
// MIDITrail / MTColorConf
//
// J[ݒNX
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTParam.h"
#include "MTConfFile.h"
#include "MTColorConf.h"
#include "DXColorUtil.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTColorConf::MTColorConf(void)
{
	unsigned long i = 0;

	m_SelectedColorPaletteNo = 0;
	
	for (i = 0; i < MT_COLOR_PALETTE_NUM_MAX; i++) {
		m_pColorPalette[i] = NULL;
	}

	return;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTColorConf::~MTColorConf(void)
{
	unsigned long i = 0;
	
	for (i = 0; i < MT_COLOR_PALETTE_NUM_MAX; i++) {
		if (m_pColorPalette[i] != NULL) {
			delete m_pColorPalette[i];
		}
		m_pColorPalette[i] = NULL;
	}
	
	return;
}

//******************************************************************************
// 
//******************************************************************************
int MTColorConf::Initialize(const TCHAR* pDefaultSceneName)
{
	int result = 0;
	int i = 0;
		
	//FpbgƏ
	for (i = 0; i < MT_COLOR_PALETTE_NUM_MAX; i++) {
		try {
			m_pColorPalette[i] = new MTColorPalette();
		}
		catch (std::bad_alloc) {
			result = YN_SET_ERR("Could not allocate memory.", i, 0);
			goto EXIT;
		}
		result = m_pColorPalette[i]->Initialize();
		if (result != 0) goto EXIT;
	}
	
	//ݒt@C
	result = _InitConfFile();
	if (result != 0) goto EXIT;
	
	//[Uݒǂݍ
	result = _LoadColorConf(pDefaultSceneName);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// IJ[pbgԍ擾F0 ftHgA1-6 pbgԍ
//******************************************************************************
unsigned long MTColorConf::GetSelectedColorPaletteNo()
{
	return m_SelectedColorPaletteNo;
}

//******************************************************************************
// IJ[pbgԍo^F0 ftHgA1-6 pbgԍ
//******************************************************************************
int MTColorConf::SetSelectedColorPaletteNo(unsigned long paletteNo)
{
	int result = 0;
	
	if (paletteNo >= MT_COLOR_PALETTE_NUM_MAX) {
		result = YN_SET_ERR("Program error.", paletteNo, 0);
		goto EXIT;
	}
	
	m_SelectedColorPaletteNo = paletteNo;
	
EXIT:;
	return result;
}

//******************************************************************************
// J[pbg擾F0 ftHgA1-6 pbgԍ
//******************************************************************************
int MTColorConf::GetColorPalette(
		unsigned long paletteNo,
		MTColorPalette* pColorPalette
	)
{
	int result = 0;
	
	if (paletteNo >= MT_COLOR_PALETTE_NUM_MAX) {
		result = YN_SET_ERR("Program error.", paletteNo, 0);
		goto EXIT;
	}
	
	pColorPalette->CopyFrom(m_pColorPalette[paletteNo]);
	
EXIT:;
	return result;
}

//******************************************************************************
// IJ[pbg擾
//******************************************************************************
void MTColorConf::GetSelectedColorPalette(MTColorPalette* pColorPalette)
{
	pColorPalette->CopyFrom(m_pColorPalette[m_SelectedColorPaletteNo]);
}

//******************************************************************************
// J[pbgo^F1-6 pbgԍA0 ftHg͓o^s
//******************************************************************************
int MTColorConf::SetColorPalette(
		unsigned long paletteNo,
		MTColorPalette* pColorPalette
	)
{
	int result = 0;
	
	//ftHg0̃pbg͏s
	if ((paletteNo == 0) || (paletteNo >= MT_COLOR_PALETTE_NUM_MAX)) {
		result = YN_SET_ERR("Program error.", paletteNo, 0);
		goto EXIT;
	}
	
	m_pColorPalette[paletteNo]->CopyFrom(pColorPalette);
	
EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MTColorConf::_InitConfFile()
{
	int result = 0;
	TCHAR userConfFilePath[_MAX_PATH] = {_T('\0')};

	result = YNPathUtil::GetAppDataDirPath(userConfFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_DIR);
	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_COLOR);

	result = m_ConfFile.Initialize(userConfFilePath);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// [Uݒǂݍ
//******************************************************************************
int MTColorConf::_LoadColorConf(const TCHAR* pDefaultSceneName)
{
	int result = 0;
	unsigned long paletteNo = 0;
	
	//ZNVݒ
	result = m_ConfFile.SetCurSection(_T("ColorSelect"));
	if (result != 0) goto EXIT;
	
	//[Uݒl擾FIJ[pbgԍ
	result = m_ConfFile.GetInt(_T("SelectedColorPaletteNo"), &m_SelectedColorPaletteNo, 0);
	if (result != 0) goto EXIT;
	if ((m_SelectedColorPaletteNo < 0) || (m_SelectedColorPaletteNo >= MT_COLOR_PALETTE_NUM_MAX)) {
		m_SelectedColorPaletteNo = 0;
	}
	
	//ftHgJ[pbgǂݍ
	result = _LoadColorPaletteDefault(pDefaultSceneName, m_pColorPalette[0]);
	if (result != 0) goto EXIT;

	//J[pbgݒǂݍ
	for (paletteNo = 1; paletteNo < MT_COLOR_PALETTE_NUM_MAX; paletteNo++) {
		result = _LoadColorPalettes(paletteNo, m_pColorPalette[paletteNo]);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// ftHgJ[pbgǂݍ
//******************************************************************************
int MTColorConf::_LoadColorPaletteDefault(
		const TCHAR* pDefaultSceneName,
		MTColorPalette* pColorPalette
	)
{
	int result = 0;
	unsigned long chNo = 0;
	TCHAR key[32] = {_T('\0')};
	TCHAR hexColor[16] = {_T('\0')};
	MTConfFile confFile;
	
	//ݒt@Cǂݍ
	result = confFile.Initialize(pDefaultSceneName);
	if (result != 0) goto EXIT;
	
	//ZNVw
	result = confFile.SetCurSection(_T("Color"));
	if (result != 0) goto EXIT;
	
	//`lF擾
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		_stprintf_s(key, 32, _T("Ch-%02d-NoteRGBA"), chNo+1);
		result = confFile.GetStr(key, hexColor, 16, _T("FFFFFFFF"));
		if (result != 0) goto EXIT;
		pColorPalette->SetChColor(chNo, DXColorUtil::MakeColorFromHexRGBA(hexColor));
	}
	//wiF擾
	result = confFile.GetStr(_T("BackGroundRGB"), hexColor, 16, _T("000000FF"));
	if (result != 0) goto EXIT;
	pColorPalette->SetBackgroundColor(DXColorUtil::MakeColorFromHexRGB(hexColor));
	
	//ObhCF擾
	result = confFile.GetStr(_T("GridLineRGBA"), hexColor, 16, "444444FF");
	if (result != 0) goto EXIT;
	pColorPalette->SetGridLineColor(DXColorUtil::MakeColorFromHexRGBA(hexColor));
	
	//JE^[F擾
	result = confFile.GetStr(_T("CaptionRGBA"), hexColor, 16, "FFFFFFFF");
	if (result != 0) goto EXIT;
	pColorPalette->SetCounterColor(DXColorUtil::MakeColorFromHexRGBA(hexColor));

EXIT:;
	return result;
}

//******************************************************************************
// J[pbgǂݍ
//******************************************************************************
int MTColorConf::_LoadColorPalettes(
		unsigned long paletteNo,
		MTColorPalette* pColorPalette
	)
{
	int result = 0;
	unsigned long chNo = 0;
	TCHAR section[32] = {_T('\0')};
	TCHAR key[32] = {_T('\0')};
	TCHAR hexColor[16] = {_T('\0')};
	
	//ZNVݒ
	_stprintf_s(section, 32, _T("ColorPalette-%u"), paletteNo);
	result = m_ConfFile.SetCurSection(section);
	if (result != 0) goto EXIT;
	
	//`lF擾
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		_stprintf_s(key, 32, _T("Ch-%02u-NoteRGBA"), chNo+1);
		result = m_ConfFile.GetStr(key, hexColor, 16, _T("FFFFFFFF"));
		if (result != 0) goto EXIT;
		pColorPalette->SetChColor(chNo, DXColorUtil::MakeColorFromHexRGBA(hexColor));
	}
	
	//wiF擾
	result = m_ConfFile.GetStr(_T("BackGroundRGBA"), hexColor, 16, _T("000000FF"));
	if (result != 0) goto EXIT;
	pColorPalette->SetBackgroundColor(DXColorUtil::MakeColorFromHexRGBA(hexColor));
	
	//ObhCF擾
	result = m_ConfFile.GetStr(_T("GridLineRGBA"), hexColor, 16, _T("444444FF"));
	if (result != 0) goto EXIT;
	pColorPalette->SetGridLineColor(DXColorUtil::MakeColorFromHexRGBA(hexColor));
	
	//JE^[F擾
	result = m_ConfFile.GetStr(_T("CaptionRGBA"), hexColor, 16, _T("FFFFFFFF"));
	if (result != 0) goto EXIT;
	pColorPalette->SetCounterColor(DXColorUtil::MakeColorFromHexRGBA(hexColor));
	
EXIT:;
	return result;
}

//******************************************************************************
// ݒۑ
//******************************************************************************
int MTColorConf::Save()
{
	int result = 0;
	unsigned long paletteNo = 0;
	
	//IJ[pbgԍۑ
	result = m_ConfFile.SetCurSection(_T("ColorSelect"));
	if (result != 0) goto EXIT;
	result = m_ConfFile.SetInt(_T("SelectedColorPaletteNo"), m_SelectedColorPaletteNo);
	if (result != 0) goto EXIT;
	
	//J[pbg 1-6 ۑ
	for (paletteNo = 1; paletteNo < MT_COLOR_PALETTE_NUM_MAX; paletteNo++) {
		result = _SaveColorPalette(paletteNo, m_pColorPalette[paletteNo]);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// J[pbgۑ
//******************************************************************************
int MTColorConf::_SaveColorPalette(
		unsigned long paletteNo,
		MTColorPalette* pColorPalette
	)
{
	int result = 0;
	unsigned long chNo = 0;
	TCHAR section[32] = {_T('\0')};
	TCHAR key[32] = {_T('\0')};
	TCHAR hexColor[16] = {_T('\0')};
	D3DXCOLOR color;
	
	//ZNVݒ
	_stprintf_s(section, 32, _T("ColorPalette-%u"), paletteNo);
	result = m_ConfFile.SetCurSection(section);
	if (result != 0) goto EXIT;
	
	//`lFo^
	for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
		_stprintf_s(key, 32, _T("Ch-%02u-NoteRGBA"), chNo+1);
		result = pColorPalette->GetChColor(chNo, &color);
		if (result != 0) goto EXIT;
		DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
		result = m_ConfFile.SetStr(key, hexColor);
		if (result != 0) goto EXIT;
	}
	
	//wiFo^
	pColorPalette->GetBackgroundColor(&color);
	DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
	result = m_ConfFile.SetStr(_T("BackGroundRGBA"), hexColor);
	if (result != 0) goto EXIT;
	
	//ObhCFo^
	pColorPalette->GetGridLineColor(&color);
	DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
	result = m_ConfFile.SetStr(_T("GridLineRGBA"), hexColor);
	if (result != 0) goto EXIT;
	
	//JE^[Fo^
	pColorPalette->GetCounterColor(&color);
	DXColorUtil::MakeHexRGBAFromColor(color, hexColor, 16);
	result = m_ConfFile.SetStr(_T("CaptionRGBA"), hexColor);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}


