//******************************************************************************
//
// MIDITrail / MTColorPalette
//
// J[pbgNX
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "SMIDILib.h"
#include <d3d9.h>
#include <d3dx9.h>


//******************************************************************************
// J[pbgNX
//******************************************************************************
class MTColorPalette
{
public:
	
	//RXgN^^fXgN^
	MTColorPalette(void);
	virtual ~MTColorPalette(void);
	
	//
	int Initialize();
	
	//`lF擾
	int GetChColor(unsigned int chNo, D3DXCOLOR* pColor);
	
	//`lFo^
	int SetChColor(unsigned int chNo, D3DXCOLOR color);
	
	//wiF擾
	void GetBackgroundColor(D3DXCOLOR* pColor);

	//wiFo^
	void SetBackgroundColor(D3DXCOLOR color);
	
	//ObhCF擾
	void GetGridLineColor(D3DXCOLOR* pColor);

	//ObhCFo^
	void SetGridLineColor(D3DXCOLOR color);
	
	//JE^[F擾
	void GetCounterColor(D3DXCOLOR* pColor);

	//JE^[Fo^
	void SetCounterColor(D3DXCOLOR color);

	//Rs[
	int CopyFrom(MTColorPalette* pColorSrc);
	
private:
	
	//ƃRs[RXgN^̋֎~
	void operator=(const MTColorPalette&);
	MTColorPalette(const MTColorPalette&);
	
	D3DXCOLOR m_ChColor[SM_MAX_CH_NUM];
	D3DXCOLOR m_BgColor;
	D3DXCOLOR m_GridLineColor;
	D3DXCOLOR m_CounterColor;
	
	void _Clear();
	
};


