//******************************************************************************
//
// MIDITrail / MTColorParamImportDlg
//
// J[p[^̓_CAO
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "resource.h"
#include "YNBaseLib.h"
#include "MTColorParamImportDlg.h"

using namespace YNBaseLib;


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTColorParamImportDlg* MTColorParamImportDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTColorParamImportDlg::MTColorParamImportDlg(void)
{
	m_pThis = this;
	m_hInstance = NULL;
	m_hWnd = NULL;
	m_hEditBox = NULL;
	m_ParamString[0] = _T('\0');
	m_isExecImport = false;

	return;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTColorParamImportDlg::~MTColorParamImportDlg(void)
{
	return;
}

//******************************************************************************
// \
//******************************************************************************
int MTColorParamImportDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_COLOR_PARAM_IMPORT),	//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
//C|[gstO擾
//******************************************************************************
bool MTColorParamImportDlg::IsExecImport()
{
	return m_isExecImport;
}

//******************************************************************************
//p[^擾
//******************************************************************************
TCHAR* MTColorParamImportDlg::GetParamString()
{
	return m_ParamString;
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTColorParamImportDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTColorParamImportDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	LRESULT lresult = 0;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDC_BTN_IMPORT) {
				m_ParamString[0] = _T('\0');
				GetWindowText(m_hEditBox, m_ParamString, MT_COLOR_PARAM_IMPORT_STRING_LENGTH_MAX);
				m_isExecImport = true;
				EndDialog(hDlg, LOWORD(wParam));
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
			}
			else if (LOWORD(wParam) == IDC_BTN_PASTE) {
				result = _OnBtnPaste();
				if (result != 0) goto EXIT;
			}
			break;
		default:
			//ȂbZ[W
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return lresult;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTColorParamImportDlg::_OnInitDlg(HWND hDlg)
{
	int result = 0;

	m_hWnd = hDlg;
	m_isExecImport = false;
	m_hEditBox = GetDlgItem(m_hWnd, IDC_EDIT_TEXT_IMPORT);

	//GfBbg{bNX̍ő͕𐧌
	SendMessage(m_hEditBox, EM_SETLIMITTEXT, (WPARAM)(MT_COLOR_PARAM_IMPORT_STRING_LENGTH_MAX - 1), 0);

//EXIT:;
	return result;
}

//******************************************************************************
// y[Xg{^
//******************************************************************************
int MTColorParamImportDlg::_OnBtnPaste()
{
	int result = 0;
	BOOL bresult = FALSE;
	HGLOBAL hGlobalMemory = NULL;
	TCHAR* pGlobalMemory = NULL;
	size_t length = 0;

	///Nbv{[h̃f[^݊mF
	bresult = IsClipboardFormatAvailable(CF_TEXT);
	if (!bresult) {
		//eLXgf[^ȂΉȂ
		goto EXIT;
	}

	//Nbv{[hJ
	bresult = OpenClipboard(m_hWnd);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Nbv{[h̃f[^擾
	hGlobalMemory = (HGLOBAL)GetClipboardData(CF_TEXT);
	if (hGlobalMemory == NULL) {
		CloseClipboard();
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//bN
	pGlobalMemory = (LPSTR)GlobalLock(hGlobalMemory);
	if (pGlobalMemory == NULL) {
		CloseClipboard();
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//TCYmF
	length = _tcslen(pGlobalMemory);
	if (length >= MT_COLOR_PARAM_IMPORT_STRING_LENGTH_MAX) {
		//Nbv{[h̃f[^傫邽
		CloseClipboard();
		result = YN_SET_ERR("The clipboad data is too long.", length, 0);
		goto EXIT;
	}

	//Ƀp[^
	_tcscpy_s(m_ParamString, MT_COLOR_PARAM_IMPORT_STRING_LENGTH_MAX, pGlobalMemory);

	//bN
	bresult = GlobalUnlock(hGlobalMemory);
	if ((!bresult) && (GetLastError() != NO_ERROR)) {
		CloseClipboard();
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//Nbv{[h
	bresult = CloseClipboard();
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	//p[^\
	bresult = SetWindowText(m_hEditBox, m_ParamString);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

EXIT:;
	return result;
}


