//******************************************************************************
//
// MIDITrail / MTDashboard
//
// _bV{[h`NX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DXColorUtil.h"
#include "MTParam.h"
#include "MTConfFile.h"
#include "MTColorConf.h"
#include "MTDashboard.h"
#include <string>

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTDashboard::MTDashboard(void)
{
	m_hWnd = NULL;
	m_PosCounterX = 0.0f;
	m_PosCounterY = 0.0f;
	m_CounterMag = MTDASHBOARD_DEFAULT_MAGRATE;

	m_PlayTimeSec = 0;
	m_TotalPlayTimeSec = 0;
	m_TempoBPM = 0;
	m_BeatNumerator = 0;
	m_BeatDenominator = 0;
	m_BarNo = 0;
	m_BarNum = 0;
	m_NoteCount = 0;
	m_NoteNum = 0;
	m_PlaySpeedRatio = 100;

	m_TempoBPMOnStart = 0;
	m_BeatNumeratorOnStart = 0;
	m_BeatDenominatorOnStart = 0;

	m_CaptionColor = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);

	m_isEnable = true;
	m_isEnableFileName = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTDashboard::~MTDashboard(void)
{
	Release();
}

//******************************************************************************
// _bV{[h
//******************************************************************************
int MTDashboard::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		HWND hWnd
   )
{
	int result = 0;
	std::wstring title;
	std::wstring fileName;
	SMTrack track;
	SMNoteList noteList;
	WCHAR counter[100];

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	m_hWnd = hWnd;

	//ݒǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	//^CgLvV
	title = pSeqData->GetTitle();
	if (title.size() == 0) {
		//󕶎ł̓eNX`ŃG[ƂȂ邽ߋ󔒕Ƃ
		title += L" ";
	}
	result = m_Title.Create(
					pD3DDevice,
					MTDASHBOARD_FONTNAME,	//tHg
					MTDASHBOARD_FONTSIZE,	//tHgTCY
					(WCHAR*)title.c_str()	//LvV
				);
	if (result != 0) goto EXIT;
	m_Title.SetColor(m_CaptionColor);

	//t@CLvV
	fileName = pSeqData->GetFileName();
	result = m_FileName.Create(
					pD3DDevice,
					MTDASHBOARD_FONTNAME,	//tHg
					MTDASHBOARD_FONTSIZE,	//tHgTCY
					(WCHAR*)fileName.c_str()	//t@C
				);
	if (result != 0) goto EXIT;
	m_FileName.SetColor(m_CaptionColor);

	//JE^LvV
	result = m_Counter.Create(
					pD3DDevice,
					MTDASHBOARD_FONTNAME,		//tHg
					MTDASHBOARD_FONTSIZE,		//tHgTCY
					MTDASHBOARD_COUNTER_CHARS,	//\
					MTDASHBOARD_COUNTER_SIZE	//LvVTCY
				);
	if (result != 0) goto EXIT;
	m_Counter.SetColor(m_CaptionColor);

	//S̉t
	SetTotalPlayTimeSec(pSeqData->GetTotalPlayTime()/1000);

	//e|(BPM)
	SetTempoBPM(pSeqData->GetTempoBPM());
	m_TempoBPMOnStart = pSeqData->GetTempoBPM();

	//qL
	SetBeat(pSeqData->GetBeatNumerator(), pSeqData->GetBeatDenominator());
	m_BeatNumeratorOnStart = pSeqData->GetBeatNumerator();
	m_BeatDenominatorOnStart = pSeqData->GetBeatDenominator();

	//ߔԍ
	SetBarNo(1);

	//ߐ
	SetBarNum(pSeqData->GetBarNum());

	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	result = track.GetNoteList(&noteList);
	if (result != 0) goto EXIT;

	m_NoteNum = noteList.GetSize();

	result = _GetCounterStr(counter, 100);
	if (result != 0) goto EXIT;

	result = m_Counter.SetString(counter);
	if (result != 0) goto EXIT;
	
	//JE^\ʒuZo
	result = _GetCounterPos(&m_PosCounterX, &m_PosCounterY);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTDashboard::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector
	)
{
	int result = 0;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTDashboard::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	D3DXMATRIX mtxWorld;
	WCHAR counter[100];

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	if (!m_isEnable) goto EXIT;

	if (m_isEnableFileName) {
		//t@C`FJE^Ɠg嗦ŕ\
		result = m_FileName.Draw(pD3DDevice, MTDASHBOARD_FRAMESIZE, MTDASHBOARD_FRAMESIZE, m_CounterMag);
		if (result != 0) goto EXIT;
	}
	else {
		//^Cg`FJE^Ɠg嗦ŕ\
		result = m_Title.Draw(pD3DDevice, MTDASHBOARD_FRAMESIZE, MTDASHBOARD_FRAMESIZE, m_CounterMag);
		if (result != 0) goto EXIT;
	}

	//JE^`
	result = _GetCounterStr(counter, 100);
	if (result != 0) goto EXIT;

	result = m_Counter.SetString(counter);
	if (result != 0) goto EXIT;

	result = m_Counter.Draw(pD3DDevice, m_PosCounterX, m_PosCounterY, m_CounterMag);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTDashboard::Release()
{
	m_Title.Release();
	m_FileName.Release();
	m_Counter.Release();
}

//******************************************************************************
// JE^\ʒu擾
//******************************************************************************
int MTDashboard::_GetCounterPos(
		float* pX,
		float* pY
	)
{
	int result = 0;
	BOOL bresult = 0;
	RECT rect;
	unsigned long cw = 0;
	unsigned long ch = 0;
	unsigned long tw = 0;
	unsigned long th = 0;
	unsigned long charHeight = 0;
	unsigned long charWidth = 0;
	unsigned long captionWidth = 0;
	float newMag = 0.0f;

	//NCAg̈̃TCY擾
	bresult = GetClientRect(m_hWnd, &rect);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	cw = rect.right - rect.left;
	ch = rect.bottom - rect.top;

	//eNX`TCY擾
	m_Counter.GetTextureSize(&th, &tw);

	//TCY
	charHeight = th;
	charWidth = tw / (unsigned long)wcslen(MTDASHBOARD_COUNTER_CHARS);

	//g嗦1.0̃LvVTCY
	captionWidth = (unsigned long)(charWidth * MTDASHBOARD_COUNTER_SIZE);

	//JE^񂪉ʂ͂ݏoꍇ͉ʂɎ܂悤Ɋg嗦XV
	//  ^Cg͂ݏô͋CɂȂƂɂ
	if (((cw - (MTDASHBOARD_FRAMESIZE*2)) < captionWidth) && (tw > 0)) {
		newMag = (float)(cw - (MTDASHBOARD_FRAMESIZE*2)) / (float)captionWidth;
		if (m_CounterMag > newMag) {
			m_CounterMag = newMag;
		}
	}

	//eNX`̕\{lĕ\ʒuZo
	*pX = MTDASHBOARD_FRAMESIZE;
	*pY = (float)ch - ((float)th * m_CounterMag) - MTDASHBOARD_FRAMESIZE;

EXIT:;
	return result;
}

//******************************************************************************
// tԓo^ibj
//******************************************************************************
void MTDashboard::SetPlayTimeSec(
		unsigned long playTimeSec
	)
{
	m_PlayTimeSec = playTimeSec;
}

//******************************************************************************
// S̉tԓo^ibj
//******************************************************************************
void MTDashboard::SetTotalPlayTimeSec(
		unsigned long totalPlayTimeSec
	)
{
	m_TotalPlayTimeSec = totalPlayTimeSec;
}

//******************************************************************************
// e|o^(BPM)
//******************************************************************************
void MTDashboard::SetTempoBPM(
		unsigned long bpm
	)
{
	m_TempoBPM = bpm;
}

//******************************************************************************
// qLo^
//******************************************************************************
void MTDashboard::SetBeat(
		unsigned long numerator,
		unsigned long denominator
	)
{
	m_BeatNumerator = numerator;
	m_BeatDenominator = denominator;
}

//******************************************************************************
// ߐo^
//******************************************************************************
void MTDashboard::SetBarNum(
		unsigned long barNum
	)
{
	m_BarNum = barNum;
}

//******************************************************************************
// ߔԍo^
//******************************************************************************
void MTDashboard::SetBarNo(
		unsigned long barNo
	)
{
	m_BarNo = barNo;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTDashboard::SetNoteOn()
{
	m_NoteCount++;
}

//******************************************************************************
// txo^
//******************************************************************************
void MTDashboard::SetPlaySpeedRatio(
		unsigned long ratio
	)
{
	m_PlaySpeedRatio = ratio;
}

//******************************************************************************
// m[go^
//******************************************************************************
void MTDashboard::SetNotesCount(
		unsigned long notesCount
	)
{
	m_NoteCount = notesCount;
}

//******************************************************************************
// JE^擾
//******************************************************************************
int MTDashboard::_GetCounterStr(
		WCHAR* pStr,
		unsigned long bufSize
	)
{
	int result = 0;
	int eresult = 0;
	WCHAR spdstr[16] = {0};

	eresult = swprintf_s(
				pStr,
				bufSize,
				L"TIME:%02d:%02d/%02d:%02d BPM:%03d BEAT:%d/%d BAR:%03d/%03d NOTES:%05d/%05d",
				m_PlayTimeSec / 60,
				m_PlayTimeSec % 60,
				m_TotalPlayTimeSec / 60,
				m_TotalPlayTimeSec % 60,
				m_TempoBPM,
				m_BeatNumerator,
				m_BeatDenominator,
				m_BarNo,
				m_BarNum,
				m_NoteCount,
				m_NoteNum
			);
	if (eresult < 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//tx100%ȊȌꍇɌJE^ɕ\
	if (m_PlaySpeedRatio != 100) {
		eresult = swprintf_s(spdstr, 16, L" SPEED:%03lu%%", m_PlaySpeedRatio);
		if (eresult < 0) {
			result = YN_SET_ERR("Program error.", 0, 0);
			goto EXIT;
		}
		wcscat_s(pStr, bufSize, spdstr);
	}

EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTDashboard::Reset()
{
	m_PlayTimeSec = 0;
	m_TempoBPM = m_TempoBPMOnStart;
	m_BeatNumerator = m_BeatNumeratorOnStart;
	m_BeatDenominator = m_BeatDenominatorOnStart;
	m_BarNo = 1;
	m_NoteCount = 0;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTDashboard::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	MTColorConf colorConf;
	MTColorPalette colorPalette;
	D3DXCOLOR color;
	
	//J[ݒ菉
	result = colorConf.Initialize(pSceneName);
	if (result != 0) goto EXIT;
	
	//IJ[pbgJE^[F擾
	colorConf.GetSelectedColorPalette(&colorPalette);
	colorPalette.GetCounterColor(&color);
	m_CaptionColor = color;

EXIT:;
	return result;
}

//******************************************************************************
// tԎ擾
//******************************************************************************
unsigned long MTDashboard::GetPlayTimeSec()
{
	return m_PlayTimeSec;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTDashboard::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}

//******************************************************************************
// t@C\ݒ
//******************************************************************************
void MTDashboard::SetEnableFileName(
		bool isEnable
	)
{
	m_isEnableFileName = isEnable;
}

