//******************************************************************************
//
// MIDITrail / MTDashboardLive
//
// Cuj^p_bV{[h`NX
//
// Copyright (C) 2012-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTParam.h"
#include "MTConfFile.h"
#include "MTColorConf.h"
#include "MTDashboardLive.h"
#include <mbctype.h>

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTDashboardLive::MTDashboardLive(void)
{
	m_hWnd = NULL;
	m_PosCounterX = 0.0f;
	m_PosCounterY = 0.0f;
	m_CounterMag = MTDASHBOARDLIVE_DEFAULT_MAGRATE;
	m_isMonitoring = false;
	m_NoteCount = 0;
	m_CaptionColor = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
	m_isEnable = true;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTDashboardLive::~MTDashboardLive(void)
{
	Release();
}

//******************************************************************************
// _bV{[h
//******************************************************************************
int MTDashboardLive::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		HWND hWnd
   )
{
	int result = 0;
	WCHAR counter[100];
	
	Release();
	
	m_hWnd = hWnd;
	
	//ݒǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;
	
	//^CgLvV
	result = SetMIDIINDeviceName(pD3DDevice, _T(""));
	if (result != 0) goto EXIT;
	
	//JE^LvV
	result = m_Counter.Create(
					pD3DDevice,
					MTDASHBOARDLIVE_FONTNAME,		//tHg
					MTDASHBOARDLIVE_FONTSIZE,		//tHgTCY
					MTDASHBOARDLIVE_COUNTER_CHARS,	//\
					MTDASHBOARDLIVE_COUNTER_SIZE	//LvVTCY
				);
	if (result != 0) goto EXIT;
	m_Counter.SetColor(m_CaptionColor);
	
	//JE^\񐶐
	result = _GetCounterStr(counter, 100);
	if (result != 0) goto EXIT;
	
	result = m_Counter.SetString(counter);
	if (result != 0) goto EXIT;
	
	//JE^\ʒuZo
	result = _GetCounterPos(&m_PosCounterX, &m_PosCounterY);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTDashboardLive::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector
	)
{
	int result = 0;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTDashboardLive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	WCHAR counter[100];
	
	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
	if (!m_isEnable) goto EXIT;
	
	//^Cg`FJE^Ɠg嗦ŕ\
	result = m_Title.Draw(pD3DDevice, MTDASHBOARDLIVE_FRAMESIZE, MTDASHBOARDLIVE_FRAMESIZE, m_CounterMag);
	if (result != 0) goto EXIT;
	
	//JE^`
	result = _GetCounterStr(counter, 100);
	if (result != 0) goto EXIT;
	
	result = m_Counter.SetString(counter);
	if (result != 0) goto EXIT;
	
	result = m_Counter.Draw(pD3DDevice, m_PosCounterX, m_PosCounterY, m_CounterMag);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTDashboardLive::Release()
{
	m_Title.Release();
	m_Counter.Release();
}

//******************************************************************************
// JE^\ʒu擾
//******************************************************************************
int MTDashboardLive::_GetCounterPos(
		float* pX,
		float* pY
	)
{
	int result = 0;
	BOOL bresult = 0;
	RECT rect;
	unsigned long cw = 0;
	unsigned long ch = 0;
	unsigned long tw = 0;
	unsigned long th = 0;
	unsigned long charHeight = 0;
	unsigned long charWidth = 0;
	unsigned long captionWidth = 0;
	float newMag = 0.0f;
	
	//NCAg̈̃TCY擾
	bresult = GetClientRect(m_hWnd, &rect);
	if (!bresult) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}
	cw = rect.right - rect.left;
	ch = rect.bottom - rect.top;
	
	//eNX`TCY擾
	m_Counter.GetTextureSize(&th, &tw);
	
	//TCY
	charHeight = th;
	charWidth = tw / (unsigned long)wcslen(MTDASHBOARDLIVE_COUNTER_CHARS);
	
	//g嗦1.0̃LvVTCY
	captionWidth = (unsigned long)(charWidth * MTDASHBOARDLIVE_COUNTER_SIZE);
	
	//JE^񂪉ʂ͂ݏoꍇ͉ʂɎ܂悤Ɋg嗦XV
	//  ^Cg͂ݏô͋CɂȂƂɂ
	if (((cw - (MTDASHBOARDLIVE_FRAMESIZE*2)) < captionWidth) && (tw > 0)) {
		newMag = (float)(cw - (MTDASHBOARDLIVE_FRAMESIZE*2)) / (float)captionWidth;
		if (m_CounterMag > newMag) {
			m_CounterMag = newMag;
		}
	}
	
	//eNX`̕\{lĕ\ʒuZo
	*pX = MTDASHBOARDLIVE_FRAMESIZE;
	*pY = (float)ch - ((float)th * m_CounterMag) - MTDASHBOARDLIVE_FRAMESIZE;

EXIT:;
	return result;
}

//******************************************************************************
// j^ԓo^
//******************************************************************************
void MTDashboardLive::SetMonitoringStatus(
		bool isMonitoring
	)
{
	m_isMonitoring = isMonitoring;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTDashboardLive::SetNoteOn()
{
	m_NoteCount++;
}

//******************************************************************************
// JE^擾
//******************************************************************************
int MTDashboardLive::_GetCounterStr(
		WCHAR* pStr,
		unsigned long bufSize
	)
{
	int result = 0;
	int eresult = 0;
	const WCHAR* pMonitorStatus = L"";
	
	if (m_isMonitoring) {
		pMonitorStatus = L"";
	}
	else {
		pMonitorStatus = L"[MONITERING OFF]";
	}
	
	eresult = swprintf_s(
				pStr,
				bufSize,
				L"NOTES:%08lu %s",
				m_NoteCount,
				pMonitorStatus
			);
	if (eresult < 0) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTDashboardLive::Reset()
{
	m_isMonitoring = false;
	m_NoteCount = 0;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTDashboardLive::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	MTColorConf colorConf;
	MTColorPalette colorPalette;
	D3DXCOLOR color;
	
	//J[ݒ菉
	result = colorConf.Initialize(pSceneName);
	if (result != 0) goto EXIT;
	
	//IJ[pbgJE^[F擾
	colorConf.GetSelectedColorPalette(&colorPalette);
	colorPalette.GetCounterColor(&color);
	m_CaptionColor = color;
	
EXIT:;
	return result;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTDashboardLive::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}

// 
// SMLibŃfoCXChŕԋpׂł邪A
// INIt@Cւ̃p[^ۑȂǍL͈͂ɉeyԂ߁A
// {NXŃChϊċzB
//******************************************************************************
//MIDI IN foCXo^
//******************************************************************************
int MTDashboardLive::SetMIDIINDeviceName(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pName
	)
{
	int result = 0;
	int eresult = 0;
	WCHAR title[256] = {0}; //MAXPNAMELEN 32 傫TCYɂ
	const WCHAR* pDisplayName = NULL;
	std::string deviceName;
	std::wstring deviceNameW;
	
	m_Title.Release();
	
	//Chϊ
	if (pName != NULL) {
		deviceName = pName;
		result = _StringToWstring(&deviceName, &deviceNameW);
		if (result != 0) goto EXIT;
	}

	//\ݒ
	if (pName == NULL) {
		pDisplayName = L"(none)";
	}
	else if (_tcslen(pName) == 0) {
		pDisplayName = L"(none)";
	}
	else {
		pDisplayName = deviceNameW.c_str();
	}
	
	//^CgLvV
	eresult = swprintf_s(
				title,
				256,
				L"MIDI IN: %s",
				pDisplayName
			);

	result = m_Title.Create(
					pD3DDevice,					//foCX
					MTDASHBOARDLIVE_FONTNAME,	//tHg
					MTDASHBOARDLIVE_FONTSIZE,	//tHgTCY
					title						//LvV
				);
	if (result != 0) goto EXIT;
	m_Title.SetColor(m_CaptionColor);

EXIT:;
	return result;
}

//******************************************************************************
// Chϊ
//******************************************************************************
int MTDashboardLive::_StringToWstring(std::string* pStr, std::wstring* pWstr)
{
	int result = 0;
	int apiresult = 0;
	int buffSize = 0;
	WCHAR* wstrBuff = NULL;

	//󕶎̏ꍇ͕ϊȂ
	if (pStr->length() == 0) {
		*pWstr = L"";
		goto EXIT;
	}

	//TQ[gyA0I[lobt@TCY
	buffSize = (int)(pStr->length()) * 2 + 1;

	try {
		wstrBuff = new WCHAR[buffSize];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", buffSize, 0);
		goto EXIT;
	}

	memset(wstrBuff, 0, sizeof(WCHAR) * buffSize);

	apiresult = MultiByteToWideChar(
						_getmbcp(),			//R[hy[W
						MB_PRECOMPOSED,		//tOF
						pStr->c_str(),		//ϊ}`oCg
						(int)(pStr->length()),	//ϊ}`oCgoCg
						wstrBuff,			//ϊ惏Chobt@
						buffSize - 1		//obt@TCYiChPʁj
					);
	if (apiresult == 0) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), 0);
		goto EXIT;
	}

	*pWstr = wstrBuff;

EXIT:;
	delete [] wstrBuff;
	return result;
}


