//******************************************************************************
//
// MIDITrail / MTDynamicCaption
//
// ILvV`NX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// Iȕ̍`B
// ID3DXFontGDI𗘗pĂ邽ߎgpȂB
// \镶̃eNX`쐬ĂiF"ABCD...0123..."jA
// ^CɕԎlp`|Sɓ\tB
// ̕ύX́A_f[^̃eNX`UVWXV邾B
// ̂߁Aȉ̐B
// (1) 炩ߎw肵gpłȂB  
//     eNX`摜Œ̂
// (2) 炩ߎw肵`łȂB
//     |SŒ̂
// (3) Œsb`tHggpłȂB
//     eNX`摜̕ʒu肷̂Ȃ̂
//
//   +-----------+
//   |A B C ... Z| eNX`摜
//   +-----------+
//   +-+-+-+-+
//   |N|E|K|O| |S1\tꂽeNX`
//   +-+-+-+-+

// BUG:
// VOoCgȂB
// eNX`rbg}bv̉4̔{ɂȂ悤ɕ␳B
// ̂1̐؂oŌ덷ꍇB

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "MTFontTexture.h"


//******************************************************************************
// p[^`
//******************************************************************************
//LvVő啶
#define MTDYNAMICCAPTION_MAX_CHARS  (256)

//******************************************************************************
// tHg^C`NX
//******************************************************************************
class MTDynamicCaption
{
public:

	//RXgN^^fXgN^
	MTDynamicCaption(void);
	virtual ~MTDynamicCaption(void);

	//
	//  pFontName   tHg
	//  fontSize    tHgTCYi|Cgj
	//  pCharacters Cӕw肷iő255jF"0123456789"
	//  captionSize LvV
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const WCHAR* pFontName,
			unsigned long fontSize,
			const WCHAR* pCharacters,
			unsigned long captionSize
		);

	//eNX`TCY擾
	void GetTextureSize(unsigned long* pHeight, unsigned long* pWidth);

	//ݒ
	//  CreateŎw肵ĂȂ͕`悳Ȃ
	//  CreateŎw肵LvV𒴂͕`悵Ȃ
	int SetString(WCHAR* pStr);

	//Fݒ
	void SetColor(D3DXCOLOR color);

	//`
	//  `ʒu͍Wϊςݒ_ƂĈFEBhEオ(0,0)
	//  eNX`TCYQƂŉʕ\{w肷
	//  magRate=1.0 ȂeNX`TCŶ܂ܕ`悷
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice, float x, float y, float magRate);

	//\[Xj
	void Release();

private:

	//_obt@\
	struct MTDYNAMICCAPTION_VERTEX {
		D3DXVECTOR3 p;		//_W
		float		rhw;	//Z
		DWORD		c;		//fBt[YF
		D3DXVECTOR2	t;		//eNX`摜ʒu
	};

	//_obt@[̃tH[}bg̒`FWϊς݂w
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1); }

	WCHAR m_Chars[MTDYNAMICCAPTION_MAX_CHARS];
	unsigned long m_CaptionSize;
	MTFontTexture m_FontTexture;
	MTDYNAMICCAPTION_VERTEX* m_pVertex;
	D3DXCOLOR m_Color;

	int _CreateTexture(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const WCHAR* pFontName,
			unsigned long fontSize,
			const WCHAR* pCharacters
		);

	int _CreateVertex();

	int _GetTextureUV(
			WCHAR target,
			D3DXVECTOR2* pV0,
			D3DXVECTOR2* pV1,
			D3DXVECTOR2* pV2,
			D3DXVECTOR2* pV3
		);

	void _SetVertexPosition(
			MTDYNAMICCAPTION_VERTEX* pVertex,
			float x,
			float y,
			float magRate
		);

	void _SetVertexColor(
			MTDYNAMICCAPTION_VERTEX* pVertex,
			D3DXCOLOR color
		);

};


