//******************************************************************************
//
// MIDITrail / MTGridRing
//
// ObhO`NX
//
// Copyright (C) 2019-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesignRing.h"

using namespace SMIDILib;


//******************************************************************************
//  ObhO`NX
//******************************************************************************
class MTGridRing
{
public:

	//RXgN^^fXgN^
	MTGridRing(void);
	virtual ~MTGridRing(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//\ݒ
	void SetEnable(bool isEnable);

private:

	DXPrimitive m_Primitive;
	SMPortList m_PortList;
	MTNoteDesignRing m_NoteDesign;
	bool m_isVisible;
	bool m_isEnable;

	//_obt@\
	struct MTGRIDBOX_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	//Obh_
	int _CreateVertexOfGrid(
			MTGRIDBOX_VERTEX* pVertex,
			unsigned long* pIbIndex,
			unsigned long totalTickTime,
			SMBarList* pBarList
		);

	//O_
	int _CreateVertexOfRing(
			MTGRIDBOX_VERTEX* pVertex,
			unsigned long* pVirtexIndex,
			unsigned long* pIndex,
			D3DXVECTOR3 basePos
		);

	void _MakeMaterial(D3DMATERIAL9* pMaterial);

};

