//******************************************************************************
//
// MIDITrail / MTMIDIOUTCfgDlg
//
// MIDI OUT ݒ_CAONX
//
// Copyright (C) 2010-2014 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "resource.h"
#include "MTParam.h"
#include "MTMIDIOUTCfgDlg.h"
#include <string>


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTMIDIOUTCfgDlg* MTMIDIOUTCfgDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTMIDIOUTCfgDlg::MTMIDIOUTCfgDlg(void)
{
	m_pThis = this;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTMIDIOUTCfgDlg::~MTMIDIOUTCfgDlg(void)
{
	m_hComboDevA = NULL;
	m_hComboDevB = NULL;
	m_hComboDevC = NULL;
	m_hComboDevD = NULL;
	m_hComboDevE = NULL;
	m_hComboDevF = NULL;
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTMIDIOUTCfgDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTMIDIOUTCfgDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	BOOL bresult = FALSE;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			bresult = TRUE;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				result = _Save();
				if (result != 0) goto EXIT;
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return (INT_PTR)bresult;
}

//******************************************************************************
// \
//******************************************************************************
int MTMIDIOUTCfgDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)(LONG_PTR)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_MIDIOUT_CFG),	//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTMIDIOUTCfgDlg::_OnInitDlg(
		HWND hDlg
	)
{
	int result = 0;

	//ݒt@C
	result = _InitConfFile();

	//MIDIo̓foCX䏉
	result = m_MIDIOutDevCtrl.Initialize();
	if (result != 0) goto EXIT;

	//MIDIo̓foCXIR{{bNX
	m_hComboDevA = GetDlgItem(hDlg, IDC_COMBO_PORT_A);
	m_hComboDevB = GetDlgItem(hDlg, IDC_COMBO_PORT_B);
	m_hComboDevC = GetDlgItem(hDlg, IDC_COMBO_PORT_C);
	m_hComboDevD = GetDlgItem(hDlg, IDC_COMBO_PORT_D);
	m_hComboDevE = GetDlgItem(hDlg, IDC_COMBO_PORT_E);
	m_hComboDevF = GetDlgItem(hDlg, IDC_COMBO_PORT_F);

	result = _InitComboDev(m_hComboDevA, _T("PortA"));
	if (result != 0) goto EXIT;
	result = _InitComboDev(m_hComboDevB, _T("PortB"));
	if (result != 0) goto EXIT;
	result = _InitComboDev(m_hComboDevC, _T("PortC"));
	if (result != 0) goto EXIT;
	result = _InitComboDev(m_hComboDevD, _T("PortD"));
	if (result != 0) goto EXIT;
	result = _InitComboDev(m_hComboDevE, _T("PortE"));
	if (result != 0) goto EXIT;
	result = _InitComboDev(m_hComboDevF, _T("PortF"));
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MTMIDIOUTCfgDlg::_InitConfFile()
{
	int result = 0;
	TCHAR userConfFilePath[_MAX_PATH] = {_T('\0')};

	result = YNPathUtil::GetAppDataDirPath(userConfFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_DIR);
	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_MIDI);

	result = m_ConfFile.Initialize(userConfFilePath);
	if (result != 0) goto EXIT;

	result = m_ConfFile.SetCurSection(_T("MIDIOUT"));
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// foCXIR{{bNX
//******************************************************************************
int MTMIDIOUTCfgDlg::_InitComboDev(
		HWND hComboDev,
		TCHAR* pPortName
	)
{
	int result = 0;
	LRESULT lresult = 0;
	unsigned long index = 0;
	unsigned long devNum = 0;
	int comboIndex = 0;
	int selectedIndex = -1;
	TCHAR devName[MAXPNAMELEN];
	std::string selectedProductName;
	std::string productName;

	//[UIfoCX擾
	result = m_ConfFile.GetStr(pPortName, devName, MAXPNAMELEN, _T(""));
	if (result != 0) goto EXIT;
	selectedProductName = devName;

	//[UIfoCXȂꍇ́uIȂvIԂɂ
	if (selectedProductName == _T("")) {
		selectedIndex = 0;
	}

	//uIȂvR{{bNXɒǉ
	lresult = SendMessage(hComboDev, CB_ADDSTRING, 0, (LPARAM)_T("(none)"));
	if ((lresult == CB_ERR) || (lresult == CB_ERRSPACE)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hComboDev);
		goto EXIT;
	}
	comboIndex++;

	//MIDIfoCX̐
	devNum = m_MIDIOutDevCtrl.GetDevNum();

	for (index = 0; index < devNum; index++) {
		//MIDI OUTfoCX擾
		result = m_MIDIOutDevCtrl.GetDevProductName(index, productName);
		if (result != 0) goto EXIT;

		//foCXR{{bNXɒǉ
		lresult = SendMessage(hComboDev, CB_ADDSTRING, 0, (LPARAM)productName.c_str());
		if ((lresult == CB_ERR) || (lresult == CB_ERRSPACE)) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hComboDev);
			goto EXIT;
		}
		if (selectedProductName == productName) {
			selectedIndex = comboIndex;
		}

		comboIndex++;
	}

	//USBfoCXl
	//[UIfoCXݐڑĂȂꍇ̓R{{bNX̖ɒǉ
	if (selectedIndex < 0) {
		//foCXR{{bNXɒǉ
		lresult = SendMessage(hComboDev, CB_ADDSTRING, 0, (LPARAM)selectedProductName.c_str());
		if ((lresult == CB_ERR) || (lresult == CB_ERRSPACE)) {
			result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hComboDev);
			goto EXIT;
		}
		selectedIndex = comboIndex;
		comboIndex++;
	}

	//IԐݒ
	lresult = SendMessage(hComboDev, CB_SETCURSEL, selectedIndex, 0);
	if (lresult == CB_ERR) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), selectedIndex);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// foCXIۑ
//******************************************************************************
int MTMIDIOUTCfgDlg::_Save()
{
	int result = 0;

	result = _SavePortCfg(m_hComboDevA, _T("PortA"));
	if (result != 0) goto EXIT;
	result = _SavePortCfg(m_hComboDevB, _T("PortB"));
	if (result != 0) goto EXIT;
	result = _SavePortCfg(m_hComboDevC, _T("PortC"));
	if (result != 0) goto EXIT;
	result = _SavePortCfg(m_hComboDevD, _T("PortD"));
	if (result != 0) goto EXIT;
	result = _SavePortCfg(m_hComboDevE, _T("PortE"));
	if (result != 0) goto EXIT;
	result = _SavePortCfg(m_hComboDevF, _T("PortF"));
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// |[gݒۑ
//******************************************************************************
int MTMIDIOUTCfgDlg::_SavePortCfg(
		HWND hComboDev,
		TCHAR* pPortName
	)
{
	int result = 0;
	LRESULT lresult = 0;
	unsigned long selectedIndex = 0;
	std::string selectedProductName;
	std::string productName;
	unsigned long devNum = 0;
	bool isUpdate = true;

	//MIDIfoCX̐
	devNum = m_MIDIOutDevCtrl.GetDevNum();

	//Iڂ̃CfbNX擾
	lresult = SendMessage(hComboDev, CB_GETCURSEL, 0, 0);
	if ((lresult == CB_ERR) || (lresult < 0)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD64)hComboDev);
		goto EXIT;
	}
	selectedIndex = (unsigned long)lresult;

	//Iڂ̃foCX擾
	if (selectedIndex == 0) {
		selectedProductName = _T("");
	}
	else if (selectedIndex <= devNum) {
		result = m_MIDIOutDevCtrl.GetDevProductName((selectedIndex-1), selectedProductName);
		if (result != 0) goto EXIT;
	}
	else {
		//ɒǉݐڑĂȂ[UIfoCXIꂽ܂
		isUpdate = false;
	}

	//ݒۑ
	if (isUpdate) {
		result = m_ConfFile.SetStr(pPortName, selectedProductName.c_str());
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

